/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import com.googlecode.ehcache.annotations.Cacheable;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.RDBMUserIdentityStore;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.layout.dao.IStylesheetUserPreferencesDao;
import org.jasig.portal.persondir.ILocalAccountDao;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.spring.locator.CounterStoreLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="userIdentityStore")
public class RDBMUserIdentityStore
implements IUserIdentityStore {
    private static final Log log = LogFactory.getLog(RDBMUserIdentityStore.class);
    private static final String PROFILE_TABLE = "UP_USER_PROFILE";
    private static final String templateAttrName = "uPortalTemplateUserName";
    private String defaultTemplateUserName;
    private JdbcOperations jdbcOperations;
    private TransactionOperations transactionOperations;
    private IPortletEntityDao portletEntityDao;
    private IStylesheetUserPreferencesDao stylesheetUserPreferencesDao;
    private ILocalAccountDao localAccountDao;
    private Ehcache userLockCache;
    private static final String IS_DEFAULT_USER_QUERY = "SELECT count(*)\nFROM up_user upuA\n\tright join up_user upuB on upuA.USER_ID = upuB.USER_DFLT_USR_ID\nWHERE upuA.user_name=?";

    @Value(value="${org.jasig.portal.services.Authentication.defaultTemplateUserName}")
    public void setDefaultTemplateUserName(String defaultTemplateUserName) {
        this.defaultTemplateUserName = defaultTemplateUserName;
    }

    @Autowired
    public void setPortletEntityDao(@Qualifier(value="persistence") IPortletEntityDao portletEntityDao) {
        this.portletEntityDao = portletEntityDao;
    }

    @Autowired
    public void setStylesheetUserPreferencesDao(IStylesheetUserPreferencesDao stylesheetUserPreferencesDao) {
        this.stylesheetUserPreferencesDao = stylesheetUserPreferencesDao;
    }

    @Autowired
    public void setLocalAccountDao(ILocalAccountDao localAccountDao) {
        this.localAccountDao = localAccountDao;
    }

    @Autowired
    @Qualifier(value="org.jasig.portal.RDBMUserIdentityStore.userLockCache")
    public void setUserLockCache(Ehcache userLockCache) {
        this.userLockCache = new SelfPopulatingCache(userLockCache, (CacheEntryFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Autowired
    public void setPlatformTransactionManager(@Qualifier(value="PortalDb") PlatformTransactionManager platformTransactionManager) {
        this.transactionOperations = new TransactionTemplate(platformTransactionManager);
    }

    @Resource(name="PortalDb")
    public void setDataSource(DataSource dataSource) {
        this.jdbcOperations = new JdbcTemplate(dataSource);
    }

    private Serializable getLock(IPerson person) {
        String username = (String)person.getAttribute("username");
        return this.userLockCache.get((Serializable)((Object)username));
    }

    public int getPortalUID(IPerson person) throws AuthorizationException {
        int uPortalUID = -1;
        uPortalUID = this.getPortalUID(person, false);
        return uPortalUID;
    }

    public void removePortalUID(String userName) {
        this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void removePortalUID(int uPortalUID) {
        this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getUsername(IPerson person) {
        return (String)person.getAttribute("username");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPortalUID(IPerson person, boolean createPortalData) throws AuthorizationException {
        int uid;
        String username = (String)person.getAttribute("username");
        if (PersonFactory.GUEST_USERNAME.equals(username)) {
            uid = this.__getPortalUID(person, createPortalData);
        } else {
            Serializable lock;
            Serializable serializable = lock = this.getLock(person);
            synchronized (serializable) {
                uid = this.__getPortalUID(person, createPortalData);
            }
        }
        return uid;
    }

    public String getPortalUserName(int uPortalUID) {
        List results = this.jdbcOperations.queryForList("SELECT USER_NAME FROM UP_USER WHERE USER_ID=?", String.class, new Object[]{uPortalUID});
        return (String)DataAccessUtils.singleResult((Collection)results);
    }

    public Integer getPortalUserId(String userName) {
        List results = this.jdbcOperations.queryForList("SELECT USER_ID FROM UP_USER WHERE USER_NAME=?", Integer.class, new Object[]{userName});
        return (Integer)DataAccessUtils.singleResult((Collection)results);
    }

    @Cacheable(cacheName="org.jasig.portal.RDBMUserIdentityStore.isDefaultUser")
    public boolean isDefaultUser(String username) {
        int defaultUserCount = this.jdbcOperations.queryForInt(IS_DEFAULT_USER_QUERY, new Object[]{username});
        return defaultUserCount > 0;
    }

    private int __getPortalUID(IPerson person, boolean createPortalData) throws AuthorizationException {
        PortalUser portalUser = null;
        try {
            String userName = this.getUsername(person);
            String templateName = this.getTemplateName(person);
            portalUser = this.getPortalUser(userName);
            if (createPortalData) {
                if (portalUser != null) {
                    boolean hasSavedLayout = this.userHasSavedLayout(portalUser.getUserId());
                    if (!hasSavedLayout) {
                        TemplateUser templateUser = this.getTemplateUser(templateName);
                        if (portalUser.getDefaultUserId() != templateUser.getUserId()) {
                            this.updateUser(portalUser.getUserId(), person, templateUser);
                        }
                    }
                } else {
                    TemplateUser templateUser = this.getTemplateUser(templateName);
                    if (templateUser == null) {
                        throw new AuthorizationException("No information found for template user = " + templateName + ". Cannot create new account for " + userName);
                    }
                    int newUID = this.getNewPortalUID(person);
                    int newPortalUID = this.addNewUser(newUID, person, templateUser);
                    portalUser = new PortalUser(this);
                    portalUser.setUserId(newPortalUID);
                }
            } else if (portalUser == null) {
                throw new AuthorizationException("No portal information exists for user " + userName);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return portalUser.getUserId();
    }

    protected int getNewPortalUID(IPerson person) throws Exception {
        return CounterStoreLocator.getCounterStore().getNextId("UP_USER");
    }

    protected static final void commit(Connection connection) {
        try {
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                connection.commit();
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMUserIdentityStore::commit(): " + e));
        }
    }

    protected static final void rollback(Connection connection) {
        try {
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                connection.rollback();
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMUserIdentityStore::rollback(): " + e));
        }
    }

    protected PortalUser getPortalUser(String userName) throws Exception {
        return (PortalUser)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected String getTemplateName(IPerson person) {
        String templateName = (String)person.getAttribute(templateAttrName);
        if (templateName == null || templateName.equals("")) {
            templateName = this.defaultTemplateUserName;
        }
        return templateName;
    }

    protected TemplateUser getTemplateUser(String templateUserName) throws Exception {
        return (TemplateUser)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean userHasSavedLayout(int userId) throws Exception {
        return (Boolean)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ILockableEntityGroup getSafeLockableGroup(IEntityGroup eg, IGroupMember gm) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating lockable group for group/member: " + eg + "/" + gm));
        }
        ILockableEntityGroup leg = null;
        try {
            if (eg.isEditable()) {
                leg = GroupService.findLockableGroup((String)eg.getKey(), (String)gm.getKey());
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to create lockable group for group/member: " + eg + "/" + gm), (Throwable)e);
        }
        return leg;
    }

    private void removePersonFromGroup(IPerson person, IGroupMember me, IEntityGroup eg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing " + person + " from group " + eg));
        }
        try {
            if (eg.isEditable()) {
                eg.removeMember(me);
                eg.updateMembers();
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to remove " + person + " from group " + eg), (Throwable)e);
        }
    }

    private void addPersonToGroup(IPerson person, IGroupMember me, IEntityGroup eg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding " + person + " to group " + eg));
        }
        try {
            if (eg.isEditable()) {
                eg.addMember(me);
                eg.updateMembers();
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to add " + person + " to group " + eg), (Throwable)e);
        }
    }

    protected void updateUser(int userId, IPerson person, TemplateUser templateUser) throws Exception {
        IGroupMember me = GroupService.getGroupMember((EntityIdentifier)person.getEntityIdentifier());
        Iterator myExistingGroups = me.getContainingGroups();
        while (myExistingGroups.hasNext()) {
            IEntityGroup eg = (IEntityGroup)myExistingGroups.next();
            ILockableEntityGroup leg = this.getSafeLockableGroup(eg, me);
            if (leg == null) continue;
            this.removePersonFromGroup(person, me, (IEntityGroup)leg);
        }
        IEntity template = GroupService.getEntity((String)templateUser.getUserName(), IPerson.class);
        Iterator templateGroups = template.getContainingGroups();
        while (templateGroups.hasNext()) {
            IEntityGroup eg = (IEntityGroup)templateGroups.next();
            ILockableEntityGroup leg = this.getSafeLockableGroup(eg, me);
            if (leg == null) continue;
            this.addPersonToGroup(person, me, (IEntityGroup)leg);
        }
        this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected int addNewUser(int newUID, IPerson person, TemplateUser templateUser) throws Exception {
        IGroupMember me = GroupService.getGroupMember((EntityIdentifier)person.getEntityIdentifier());
        IEntity template = GroupService.getEntity((String)templateUser.getUserName(), Class.forName("org.jasig.portal.security.IPerson"));
        Iterator templateGroups = template.getContainingGroups();
        while (templateGroups.hasNext()) {
            IEntityGroup eg = (IEntityGroup)templateGroups.next();
            ILockableEntityGroup leg = this.getSafeLockableGroup(eg, me);
            if (leg == null) continue;
            this.addPersonToGroup(person, me, (IEntityGroup)leg);
        }
        return (Integer)this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private int getNextKey() {
        return CounterStoreLocator.getCounterStore().getNextId(PROFILE_TABLE);
    }

    static /* synthetic */ JdbcOperations access$000(RDBMUserIdentityStore x0) {
        return x0.jdbcOperations;
    }

    static /* synthetic */ IPortletEntityDao access$100(RDBMUserIdentityStore x0) {
        return x0.portletEntityDao;
    }

    static /* synthetic */ IStylesheetUserPreferencesDao access$200(RDBMUserIdentityStore x0) {
        return x0.stylesheetUserPreferencesDao;
    }

    static /* synthetic */ ILocalAccountDao access$300(RDBMUserIdentityStore x0) {
        return x0.localAccountDao;
    }

    static /* synthetic */ Log access$400() {
        return log;
    }

    static /* synthetic */ String access$500(RDBMUserIdentityStore x0) {
        return x0.defaultTemplateUserName;
    }

    static /* synthetic */ int access$600(RDBMUserIdentityStore x0) {
        return x0.getNextKey();
    }
}

