/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.character.stream;

import java.util.Collection;
import java.util.regex.MatchResult;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.jasig.portal.character.stream.BasePlaceholderEventSource;
import org.jasig.portal.character.stream.events.CharacterEvent;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.utils.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PortletPlaceholderEventSource
extends BasePlaceholderEventSource {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPortletWindowRegistry portletWindowRegistry;
    private int portletIdGroup = 1;

    public void setPortletIdGroup(int portletIdGroup) {
        this.portletIdGroup = portletIdGroup;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public void generateCharacterEvents(HttpServletRequest servletRequest, XMLEventReader eventReader, StartElement event, Collection<CharacterEvent> eventBuffer) throws XMLStreamException {
        Tuple portletWindowAndElement = this.portletWindowRegistry.getPortletWindow(servletRequest, event);
        if (portletWindowAndElement == null) {
            this.logger.warn("Could not find IPortletWindow for StartElement " + event + ". No PortletPlaceholderEvent will be generated. " + event.getLocation());
            return;
        }
        IPortletWindowId portletWindowId = ((IPortletWindow)portletWindowAndElement.first).getPortletWindowId();
        this.generateCharacterEvents(portletWindowId, eventReader, event, eventBuffer);
    }

    protected void generateCharacterEvents(IPortletWindowId portletWindowId, XMLEventReader eventReader, StartElement event, Collection<CharacterEvent> eventBuffer) throws XMLStreamException {
        this.generateCharacterEvents(portletWindowId, event, eventBuffer);
        this.readToEndElement(eventReader, event);
    }

    protected void generateCharacterEvents(IPortletWindowId portletWindowId, StartElement event, Collection<CharacterEvent> eventBuffer) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void generateCharacterEvents(HttpServletRequest servletRequest, MatchResult matchResult, Collection<CharacterEvent> eventBuffer) {
        String subscribeId = matchResult.group(this.portletIdGroup);
        if (subscribeId == null) {
            this.logger.warn("MatchResult returned null for group " + this.portletIdGroup + ". No PortletPlaceholderEvent will be generated. " + matchResult);
            return;
        }
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(servletRequest, subscribeId);
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        this.generateCharacterEvents(portletWindowId, matchResult, eventBuffer);
    }

    protected void generateCharacterEvents(IPortletWindowId portletWindowId, MatchResult matchResult, Collection<CharacterEvent> eventBuffer) {
        throw new UnsupportedOperationException();
    }
}

