/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.io.Serializable;
import java.util.Map;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityCache;

public class MapBackedEntityCache
implements IEntityCache {
    private final Map<Serializable, IBasicEntity> cache;
    private final Class<? extends IBasicEntity> entityType;

    public MapBackedEntityCache(Map<Serializable, IBasicEntity> cache, Class<? extends IBasicEntity> entityType) {
        this.cache = cache;
        this.entityType = entityType;
    }

    public void add(IBasicEntity entity) throws CachingException {
        EntityIdentifier entityIdentifier = entity.getEntityIdentifier();
        Class addType = entityIdentifier.getType();
        if (!this.entityType.isAssignableFrom(addType)) {
            throw new CachingException("Problem adding " + entity + ": entity type '" + addType + "' is incompatible with cache type '" + this.entityType + "'.");
        }
        this.cache.put(entityIdentifier.getKey(), entity);
    }

    public void clearCache() throws CachingException {
        this.cache.clear();
    }

    public IBasicEntity get(String key) {
        return (IBasicEntity)this.cache.get(key);
    }

    public Class<? extends IBasicEntity> getEntityType() {
        return this.entityType;
    }

    public void remove(String entityKey) throws CachingException {
        this.cache.remove(entityKey);
    }

    public void update(IBasicEntity entity) throws CachingException {
        this.add(entity);
    }

    public int size() {
        return this.cache.size();
    }

    @Deprecated
    public void cleanupCache() throws CachingException {
    }
}

