/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.io.Serializable;
import java.lang.annotation.AnnotationFormatError;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.hibernate.management.impl.EhcacheHibernateMbeanNames;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jasig.portal.concurrency.caching.CacheStatistics;
import org.jasig.portal.concurrency.caching.RequestCache;
import org.jasig.portal.concurrency.caching.RequestCacheAspect;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.utils.ConcurrentMapUtils;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.MBeanExportOperations;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="requestCacheAspect")
public class RequestCacheAspect
implements InitializingBean {
    private static final String CACHE_MAP = RequestCacheAspect.class.getName() + ".CACHE_MAP";
    private static final Object NULL_PLACEHOLDER = new Object();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, CacheStatistics> methodStats = new ConcurrentHashMap();
    private final CacheStatistics overallStats = new CacheStatistics();
    private IPortalRequestUtils portalRequestUtils;
    private MBeanExportOperations mBeanExportOperations;

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired(required=false)
    public void setmBeanExportOperations(MBeanExportOperations mBeanExportOperations) {
        this.mBeanExportOperations = mBeanExportOperations;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mBeanExportOperations != null) {
            ObjectName name = new ObjectName("uPortal:section=Cache,RequestCache=RequestCache,name=OverallStatistics");
            this.registerMbean((Object)this.overallStats, name);
        }
    }

    @Pointcut(value="execution(public * *(..))")
    public void anyPublicMethod() {
    }

    @Around(value="anyPublicMethod() && @annotation(requestCache)")
    public Object cacheRequest(ProceedingJoinPoint pjp, RequestCache requestCache) throws Throwable {
        HttpServletRequest currentPortalRequest;
        long start = System.nanoTime();
        CacheKey cacheKey = this.createCacheKey(pjp, requestCache);
        try {
            currentPortalRequest = this.portalRequestUtils.getCurrentPortalRequest();
        }
        catch (IllegalStateException e) {
            this.logger.trace("No current portal request, will not cache result of: {}", (Object)cacheKey);
            return pjp.proceed();
        }
        CacheStatistics cacheStatistics = this.getCacheStatistics(pjp, requestCache);
        ConcurrentMap cache = PortalWebUtils.getMapRequestAttribute((ServletRequest)currentPortalRequest, (String)CACHE_MAP);
        Object result = cache.get(cacheKey);
        if (requestCache.cacheNull() && result == NULL_PLACEHOLDER) {
            long time = System.nanoTime() - start;
            cacheStatistics.recordHit(time);
            this.overallStats.recordHit(time);
            this.logger.debug("Found cached null for invocation of: {}", (Object)cacheKey);
            return null;
        }
        if (requestCache.cacheException() && result instanceof ExceptionHolder) {
            long time = System.nanoTime() - start;
            cacheStatistics.recordHit(time);
            this.overallStats.recordHit(time);
            this.logger.debug("Found cached exception for invocation of: {}", (Object)cacheKey);
            throw ((ExceptionHolder)result).getThrowable();
        }
        if (result != null) {
            long time = System.nanoTime() - start;
            cacheStatistics.recordHit(time);
            this.overallStats.recordHit(time);
            this.logger.debug("Found cached result for invocation of: {}", (Object)cacheKey);
            return result;
        }
        try {
            result = pjp.proceed();
            long time = System.nanoTime() - start;
            cacheStatistics.recordMissAndLoad(time);
            this.overallStats.recordMissAndLoad(time);
            if (result != null) {
                cache.put(cacheKey, result);
                this.logger.debug("Cached result for invocation of: {}", (Object)cacheKey);
            } else if (requestCache.cacheNull()) {
                cache.put(cacheKey, NULL_PLACEHOLDER);
                this.logger.debug("Cached null for invocation of: {}", (Object)cacheKey);
            }
            return result;
        }
        catch (Throwable t) {
            long time = System.nanoTime() - start;
            cacheStatistics.recordMissAndException(time);
            this.overallStats.recordMissAndException(time);
            if (requestCache.cacheException()) {
                cache.put(cacheKey, new ExceptionHolder(t));
                this.logger.debug("Cached exception for invocation of: {}", (Object)cacheKey);
            }
            throw t;
        }
    }

    protected void registerMbean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.mBeanExportOperations.registerManagedResource(object, name);
    }

    protected final CacheStatistics getCacheStatistics(ProceedingJoinPoint pjp, RequestCache requestCache) {
        Signature signature = pjp.getSignature();
        String signatureString = signature.toString();
        CacheStatistics cacheStatistics = (CacheStatistics)this.methodStats.get(signatureString);
        if (cacheStatistics == null) {
            CacheStatistics newStats = new CacheStatistics();
            cacheStatistics = (CacheStatistics)ConcurrentMapUtils.putIfAbsent((ConcurrentMap)this.methodStats, (Object)signatureString, (Object)newStats);
            if (this.mBeanExportOperations != null && cacheStatistics == newStats) {
                String nameString = "uPortal:section=Cache,RequestCache=RequestCache,name=" + EhcacheHibernateMbeanNames.mbeanSafe((String)signatureString);
                try {
                    ObjectName name = new ObjectName(nameString);
                    this.registerMbean((Object)cacheStatistics, name);
                }
                catch (MalformedObjectNameException e) {
                    this.logger.warn("Failed to create ObjectName {} the corresponding CacheStatistics will not be registered with JMX", (Object)nameString, (Object)e);
                }
                catch (NullPointerException e) {
                    this.logger.warn("Failed to create ObjectName {} the corresponding CacheStatistics will not be registered with JMX", (Object)nameString, (Object)e);
                }
                catch (InstanceAlreadyExistsException e) {
                    this.logger.warn("ObjectName {} is already registered, the corresponding CacheStatistics will not be registered with JMX", (Object)nameString, (Object)e);
                }
                catch (MBeanRegistrationException e) {
                    this.logger.warn("Failed to register ObjectName {} the corresponding CacheStatistics will not be registered with JMX", (Object)nameString, (Object)e);
                }
                catch (NotCompliantMBeanException e) {
                    this.logger.warn("Failed to register ObjectName {} the corresponding CacheStatistics will not be registered with JMX", (Object)nameString, (Object)e);
                }
            }
        }
        return cacheStatistics;
    }

    protected CacheKey createCacheKey(ProceedingJoinPoint pjp, RequestCache requestCache) {
        Object[] keyArgs;
        Signature signature = pjp.getSignature();
        Class declaringType = signature.getDeclaringType();
        String signatureLongString = signature.toLongString();
        boolean[] keyMask = requestCache.keyMask();
        Object[] args = pjp.getArgs();
        if (keyMask.length == 0) {
            keyArgs = args;
        } else {
            if (keyMask.length != args.length) {
                throw new AnnotationFormatError("RequestCache.keyMask has an invalid length on: " + signature.toLongString());
            }
            keyArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (!keyMask[i]) continue;
                keyArgs[i] = args[i];
            }
        }
        return CacheKey.build((String)signatureLongString, (Serializable[])new Serializable[]{declaringType, keyArgs});
    }
}

