/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.locking;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.jasig.portal.IPortalInfoProvider;
import org.jasig.portal.concurrency.locking.ClusterLockServiceImpl;
import org.jasig.portal.concurrency.locking.ClusterMutex;
import org.jasig.portal.concurrency.locking.IClusterLockDao;
import org.jasig.portal.concurrency.locking.IClusterLockService;
import org.jasig.portal.concurrency.locking.LockOptions;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ClusterLockServiceImpl
implements IClusterLockService {
    private static final LockOptions DEFAULT_LOCK_OPTIONS = new LockOptions();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<String, ReentrantLock> localLocks = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private IPortalInfoProvider portalInfoProvider;
    private ExecutorService lockMonitorExecutorService;
    private IClusterLockDao clusterLockDao;
    private ReadableDuration updateLockRate = Duration.standardSeconds((long)1L);
    private ReadableDuration maximumLockDuration = Duration.standardMinutes((long)60L);
    private ReadableDuration dbLockTimeout = Duration.standardSeconds((long)30L);

    @Autowired
    public void setPortalInfoProvider(IPortalInfoProvider portalInfoProvider) {
        this.portalInfoProvider = portalInfoProvider;
    }

    @Autowired
    public void setClusterLockDao(IClusterLockDao clusterLockDao) {
        this.clusterLockDao = clusterLockDao;
    }

    @Autowired
    public void setLockMonitorExecutorService(@Qualifier(value="uPortalLockExecutor") ExecutorService lockMonitorExecutorService) {
        this.lockMonitorExecutorService = lockMonitorExecutorService;
    }

    @Value(value="${org.jasig.portal.concurrency.locking.ClusterLockDao.updateLockRate:PT1S}")
    public void setUpdateLockRate(ReadableDuration updateLockRate) {
        this.updateLockRate = updateLockRate;
    }

    @Value(value="${org.jasig.portal.concurrency.locking.ClusterLockDao.maximumLockDuration:PT3600S}")
    public void setMaximumLockDuration(ReadableDuration maximumLockDuration) {
        this.maximumLockDuration = maximumLockDuration;
    }

    @Value(value="${org.jasig.portal.concurrency.locking.ClusterLockDao.dbLockAcquireTimeout:PT30S}")
    public void setDbLockTimeout(ReadableDuration dbLockTimeout) {
        this.dbLockTimeout = dbLockTimeout;
    }

    public ClusterMutex getClusterMutex(String mutexName) {
        return this.clusterLockDao.getClusterMutex(mutexName);
    }

    public <T> IClusterLockService.TryLockFunctionResult<T> doInTryLock(String mutexName, Function<ClusterMutex, T> lockFunction) throws InterruptedException {
        return this.doInTryLock(mutexName, DEFAULT_LOCK_OPTIONS, lockFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IClusterLockService.TryLockFunctionResult<T> doInTryLock(String mutexName, LockOptions lockOptions, Function<ClusterMutex, T> lockFunction) throws InterruptedException {
        this.logger.trace("doInLock({})", (Object)mutexName);
        CountDownLatch dbLockLatch = new CountDownLatch(1);
        CountDownLatch workCompleteLatch = new CountDownLatch(1);
        AtomicReference<Object> mutexRef = new AtomicReference<Object>(null);
        Future lockFuture = null;
        ReentrantLock lock = this.getLocalLock(mutexName);
        boolean lockedLocally = lock.tryLock();
        if (!lockedLocally) {
            this.logger.trace("local lock already held for {}", (Object)mutexName);
            return TryLockFunctionResultImpl.getSkippedInstance((IClusterLockService.LockStatus)IClusterLockService.LockStatus.SKIPPED_LOCKED);
        }
        try {
            this.logger.trace("acquired local lock for {}", (Object)mutexName);
            long lastRunDelay = lockOptions.getLastRunDelay();
            long serverBiasDelay = lockOptions.getServerBiasDelay();
            if (lastRunDelay > 0L || serverBiasDelay > 0L) {
                ClusterMutex clusterMutex = this.clusterLockDao.getClusterMutex(mutexName);
                if (lastRunDelay > 0L) {
                    long nextRunTime = System.currentTimeMillis() - lastRunDelay;
                    if (clusterMutex.getLockStart() > nextRunTime || clusterMutex.getLastUpdate() > nextRunTime || clusterMutex.getLockEnd() > nextRunTime) {
                        this.logger.trace("db lock last run less than {}ms ago for {}", (Object)lastRunDelay, (Object)mutexName);
                        IClusterLockService.TryLockFunctionResult tryLockFunctionResult = TryLockFunctionResultImpl.getSkippedInstance((IClusterLockService.LockStatus)IClusterLockService.LockStatus.SKIPPED_LAST_RUN);
                        return tryLockFunctionResult;
                    }
                }
                if (serverBiasDelay > 0L) {
                    String uniqueServerName = this.portalInfoProvider.getUniqueServerName();
                    String previousServerId = clusterMutex.getPreviousServerId();
                    long nextRunTime = System.currentTimeMillis() - serverBiasDelay;
                    if (!(uniqueServerName.equals(previousServerId) || clusterMutex.getLockStart() <= nextRunTime && clusterMutex.getLastUpdate() <= nextRunTime && clusterMutex.getLockEnd() <= nextRunTime)) {
                        this.logger.trace("db lock last run less than {}ms ago for {} on a server other than {}", new Object[]{lastRunDelay, mutexName, uniqueServerName});
                        IClusterLockService.TryLockFunctionResult tryLockFunctionResult = TryLockFunctionResultImpl.getSkippedInstance((IClusterLockService.LockStatus)IClusterLockService.LockStatus.SKIPPED_SERVER_BIAS);
                        return tryLockFunctionResult;
                    }
                }
            }
            Thread currentThread = Thread.currentThread();
            DatabaseLockWorker databaseLockWorker = new DatabaseLockWorker(this, currentThread, mutexRef, mutexName, dbLockLatch, workCompleteLatch, null);
            lockFuture = this.lockMonitorExecutorService.submit(databaseLockWorker);
            boolean dbLocked = dbLockLatch.await(this.dbLockTimeout.getMillis(), TimeUnit.MILLISECONDS);
            if (!dbLocked) {
                lockFuture.cancel(true);
                this.logger.trace("failed to aquire database lock due to DatabaseLockWorker not executing, returning notExecuted result for: {}", (Object)mutexName);
                IClusterLockService.TryLockFunctionResult nextRunTime = TryLockFunctionResultImpl.getSkippedInstance((IClusterLockService.LockStatus)IClusterLockService.LockStatus.SKIPPED_LOCKED);
                return nextRunTime;
            }
            ClusterMutex mutex = mutexRef.get();
            if (mutex == null) {
                this.logger.trace("failed to aquire database lock, returning notExecuted result for: {}", (Object)mutexName);
                IClusterLockService.TryLockFunctionResult e = TryLockFunctionResultImpl.getSkippedInstance((IClusterLockService.LockStatus)IClusterLockService.LockStatus.SKIPPED_LOCKED);
                return e;
            }
            Object result = lockFunction.apply((Object)mutex);
            TryLockFunctionResultImpl tryLockFunctionResultImpl = new TryLockFunctionResultImpl(result);
            return tryLockFunctionResultImpl;
        }
        finally {
            workCompleteLatch.countDown();
            if (lockFuture != null) {
                try {
                    lockFuture.get();
                }
                catch (ExecutionException e) {
                    this.logger.warn("Lock manager thread for " + mutexName + " failed with an exception. Everything is cleaned up but this could indicate a problem with cluster locking", e.getCause());
                }
            }
            lock.unlock();
            this.logger.trace("released local lock for: {}", (Object)mutexName);
        }
    }

    public boolean isLockOwner(String mutexName) {
        ReentrantLock lock = this.getLocalLock(mutexName);
        if (!lock.isHeldByCurrentThread()) {
            return false;
        }
        ClusterMutex clusterMutex = this.clusterLockDao.getClusterMutex(mutexName);
        String uniqueServerName = this.portalInfoProvider.getUniqueServerName();
        return uniqueServerName.equals(clusterMutex.getServerId());
    }

    public boolean isLocked(String mutexName) {
        ReentrantLock lock = this.getLocalLock(mutexName);
        if (lock.isLocked()) {
            return true;
        }
        ClusterMutex clusterMutex = this.clusterLockDao.getClusterMutex(mutexName);
        return clusterMutex.isLocked();
    }

    protected ReentrantLock getLocalLock(String mutexName) {
        return (ReentrantLock)this.localLocks.getUnchecked((Object)mutexName);
    }

    static /* synthetic */ ReadableDuration access$100(ClusterLockServiceImpl x0) {
        return x0.maximumLockDuration;
    }

    static /* synthetic */ IClusterLockDao access$200(ClusterLockServiceImpl x0) {
        return x0.clusterLockDao;
    }

    static /* synthetic */ Logger access$300(ClusterLockServiceImpl x0) {
        return x0.logger;
    }

    static /* synthetic */ ReadableDuration access$400(ClusterLockServiceImpl x0) {
        return x0.updateLockRate;
    }
}

