/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.locking;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.springframework.util.Assert;

@Entity
@Table(name="UP_MUTEX")
@SequenceGenerator(name="UP_MUTEX_GEN", sequenceName="UP_MUTEX_SEQ", allocationSize=1)
@TableGenerator(name="UP_MUTEX_GEN", pkColumnValue="UP_MUTEX_PROP", allocationSize=1)
@NaturalIdCache
public class ClusterMutex
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_MUTEX_GEN")
    @Column(name="MUTEX_ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="MUTEX_NAME", length=200, nullable=false)
    private final String name;
    @Column(name="LOCKED", nullable=false)
    private boolean locked = false;
    @Column(name="SERVER_ID", length=200)
    private String serverId;
    @Column(name="PREV_SERVER_ID", length=200)
    private String previousServerId;
    @Column(name="LOCK_START", nullable=false)
    private Date lockStart = new Date(0L);
    @Column(name="LOCK_UPDATE", nullable=false)
    private Date lastUpdate = new Date(0L);
    @Column(name="LOCK_END", nullable=false)
    private Date lockEnd = new Date(0L);

    private ClusterMutex() {
        this.id = -1L;
        this.entityVersion = -1L;
        this.name = null;
    }

    ClusterMutex(String name) {
        Validate.notNull((Object)name, (String)"name");
        this.id = -1L;
        this.entityVersion = 0L;
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getPreviousServerId() {
        return this.previousServerId;
    }

    public long getLockStart() {
        return this.lockStart.getTime();
    }

    public long getLastUpdate() {
        return this.lastUpdate.getTime();
    }

    public long getLockEnd() {
        return this.lockEnd.getTime();
    }

    void lock(String serverId) {
        Assert.notNull((Object)serverId);
        if (this.locked) {
            throw new IllegalStateException("Cannot lock already locked mutex: " + this);
        }
        this.locked = true;
        this.lastUpdate = this.lockStart = new Date();
        this.serverId = serverId;
    }

    void unlock() {
        if (!this.locked) {
            throw new IllegalStateException("Cannot unlock already unlocked mutex: " + this);
        }
        this.locked = false;
        this.lockEnd = new Date();
        this.previousServerId = this.serverId;
        this.serverId = null;
    }

    void updateLock() {
        this.lastUpdate = new Date();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterMutex other = (ClusterMutex)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "ClusterMutex [name=" + this.name + ", locked=" + this.locked + ", serverId=" + this.serverId + ", previousServerId=" + this.previousServerId + ", lockStart=" + this.lockStart + ", lastUpdate=" + this.lastUpdate + ", lockEnd=" + this.lockEnd + "]";
    }
}

