/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.dao.usertype;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import org.jadira.usertype.spi.shared.AbstractStringColumnMapper;
import org.jasig.portal.dao.usertype.JacksonColumnMapper;
import org.jasig.portal.spring.beans.factory.ObjectMapperFactoryBean;

public class JacksonColumnMapper
extends AbstractStringColumnMapper<Object> {
    private static final long serialVersionUID = 1L;
    private final LoadingCache<Class<?>, ObjectWriter> typedObjectWriters = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private final LoadingCache<Class<?>, ObjectReader> typedObjectReaders = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private final ObjectWriter objectWriter;
    private final ObjectReader objectReader;

    public JacksonColumnMapper() {
        ObjectMapper mapper;
        try {
            ObjectMapperFactoryBean omfb = new ObjectMapperFactoryBean();
            omfb.afterPropertiesSet();
            mapper = (ObjectMapper)omfb.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create ObjectMapper", e);
        }
        this.customizeObjectMapper(mapper);
        this.objectWriter = this.createObjectWriter(mapper).withType(JsonWrapper.class);
        this.objectReader = this.createObjectReader(mapper).withType(JsonWrapper.class);
    }

    protected void customizeObjectMapper(ObjectMapper mapper) {
    }

    protected ObjectWriter createObjectWriter(ObjectMapper mapper) {
        return mapper.writer();
    }

    protected ObjectReader createObjectReader(ObjectMapper mapper) {
        return mapper.reader();
    }

    public final Object fromNonNullValue(String s) {
        try {
            JsonWrapper jsonWrapper = (JsonWrapper)this.objectReader.readValue(s);
            ObjectReader typeReader = (ObjectReader)this.typedObjectReaders.getUnchecked((Object)jsonWrapper.getType());
            return typeReader.readValue(jsonWrapper.getValue());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not read from JSON: " + s, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read from JSON: " + s, e);
        }
    }

    public final String toNonNullValue(Object value) {
        try {
            Class<?> type = value.getClass();
            ObjectWriter typeWriter = (ObjectWriter)this.typedObjectWriters.getUnchecked(type);
            String valueAsString = typeWriter.writeValueAsString(value);
            return this.objectWriter.writeValueAsString((Object)new JsonWrapper(type, valueAsString));
        }
        catch (JsonGenerationException e) {
            throw new IllegalArgumentException("Could not write to JSON: " + value, e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException("Could not write to JSON: " + value, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not write to JSON: " + value, e);
        }
    }

    static /* synthetic */ ObjectWriter access$000(JacksonColumnMapper x0) {
        return x0.objectWriter;
    }

    static /* synthetic */ ObjectReader access$100(JacksonColumnMapper x0) {
        return x0.objectReader;
    }
}

