/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.PortletRequest;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.RequestScopedEventsTracker;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RequestScopedEventsTrackerImpl
implements ApplicationListener<PortalEvent>,
RequestScopedEventsTracker {
    private static final String REQUEST_EVENTS = RequestScopedEventsTrackerImpl.class.getName() + ".REQUEST_EVENTS";
    private IPortalRequestUtils portalRequestUtils;

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public void onApplicationEvent(PortalEvent event) {
        HttpServletRequest portalRequest = event.getPortalRequest();
        if (portalRequest != null) {
            ConcurrentMap renderEvents = PortalWebUtils.getMapRequestAttribute((ServletRequest)portalRequest, (String)REQUEST_EVENTS);
            renderEvents.put(event, true);
        }
    }

    public Set<PortalEvent> getRequestEvents(PortletRequest portletRequest) {
        HttpServletRequest portletHttpRequest = this.portalRequestUtils.getPortletHttpRequest(portletRequest);
        return this.getRequestEvents(portletHttpRequest);
    }

    public Set<PortalEvent> getRequestEvents(HttpServletRequest request) {
        ConcurrentMap renderEvents = PortalWebUtils.getMapRequestAttribute((ServletRequest)(request = this.portalRequestUtils.getOriginalPortalRequest(request)), (String)REQUEST_EVENTS, (boolean)false);
        if (renderEvents == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(renderEvents.keySet());
    }
}

