/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.NaturalId;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregation;
import org.jasig.portal.events.aggr.BaseAggregationKey;
import org.jasig.portal.events.aggr.BaseGroupedAggregationDiscriminator;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.dao.jpa.DateDimensionImpl;
import org.jasig.portal.events.aggr.dao.jpa.TimeDimensionImpl;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMappingImpl;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Access(value=AccessType.FIELD)
@MappedSuperclass
public abstract class BaseAggregationImpl<K extends BaseAggregationKey, D extends BaseGroupedAggregationDiscriminator>
implements BaseAggregation<K, D> {
    private static final long serialVersionUID = 1L;
    @Transient
    private Logger logger = null;
    @NaturalId
    @ManyToOne(targetEntity=TimeDimensionImpl.class)
    @JoinColumn(name="TIME_DIMENSION_ID", nullable=false)
    private final TimeDimension timeDimension;
    @NaturalId
    @ManyToOne(targetEntity=DateDimensionImpl.class)
    @JoinColumn(name="DATE_DIMENSION_ID", nullable=false)
    private final DateDimension dateDimension;
    @NaturalId
    @Enumerated(value=EnumType.STRING)
    @Column(name="AGGR_INTERVAL", nullable=false)
    private final AggregationInterval interval;
    @NaturalId
    @ManyToOne(targetEntity=AggregatedGroupMappingImpl.class)
    @JoinColumn(name="AGGR_GROUP_ID", nullable=false)
    private final AggregatedGroupMapping aggregatedGroup;
    @Column(name="DURATION", nullable=false)
    private int duration;
    @Transient
    private Boolean complete = null;
    @Transient
    private DateTime dateTime = null;

    protected BaseAggregationImpl() {
        this.timeDimension = null;
        this.dateDimension = null;
        this.interval = null;
        this.aggregatedGroup = null;
    }

    protected BaseAggregationImpl(TimeDimension timeDimension, DateDimension dateDimension, AggregationInterval interval, AggregatedGroupMapping aggregatedGroup) {
        Validate.notNull((Object)timeDimension);
        Validate.notNull((Object)dateDimension);
        Validate.notNull((Object)interval);
        Validate.notNull((Object)aggregatedGroup);
        this.timeDimension = timeDimension;
        this.dateDimension = dateDimension;
        this.interval = interval;
        this.aggregatedGroup = aggregatedGroup;
    }

    public abstract long getId();

    public DateTime getDateTime() {
        DateTime dt = this.dateTime;
        if (dt == null) {
            this.dateTime = dt = this.timeDimension.getTime().toDateTime((ReadableInstant)this.dateDimension.getDate());
        }
        return dt;
    }

    public final TimeDimension getTimeDimension() {
        return this.timeDimension;
    }

    public final DateDimension getDateDimension() {
        return this.dateDimension;
    }

    public final AggregationInterval getInterval() {
        return this.interval;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final AggregatedGroupMapping getAggregatedGroup() {
        return this.aggregatedGroup;
    }

    public final void setDuration(int duration) {
        if (this.isComplete()) {
            this.getLogger().warn("{} is already closed, the new duration of {} will be ignored on: {}", new Object[]{this.getClass().getSimpleName(), duration, this});
            return;
        }
        this.duration = duration;
    }

    public final void intervalComplete(int duration) {
        this.duration = duration;
        this.completeInterval();
        this.complete = Boolean.TRUE;
    }

    protected abstract boolean isComplete();

    protected abstract void completeInterval();

    protected final Logger getLogger() {
        Logger l = this.logger;
        if (l == null) {
            this.logger = l = LoggerFactory.getLogger(this.getClass());
        }
        return l;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateDimension == null ? 0 : this.dateDimension.hashCode());
        result = 31 * result + (this.aggregatedGroup == null ? 0 : this.aggregatedGroup.hashCode());
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        result = 31 * result + (this.timeDimension == null ? 0 : this.timeDimension.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseAggregationImpl)) {
            return false;
        }
        BaseAggregation other = (BaseAggregation)obj;
        if (this.dateDimension == null ? other.getDateDimension() != null : !this.dateDimension.equals(other.getDateDimension())) {
            return false;
        }
        if (this.aggregatedGroup == null ? other.getAggregatedGroup() != null : !this.aggregatedGroup.equals(other.getAggregatedGroup())) {
            return false;
        }
        if (this.interval != other.getInterval()) {
            return false;
        }
        return !(this.timeDimension == null ? other.getTimeDimension() != null : !this.timeDimension.equals(other.getTimeDimension()));
    }
}

