/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalHelper;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.BaseAggregationImpl;
import org.jasig.portal.events.aggr.BaseAggregationKey;
import org.jasig.portal.events.aggr.BaseAggregationPrivateDao;
import org.jasig.portal.events.aggr.EventAggregationContext;
import org.jasig.portal.events.aggr.IPortalEventAggregator;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.session.EventSession;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BasePortalEventAggregator<E extends PortalEvent, T extends BaseAggregationImpl<K, ?>, K extends BaseAggregationKey>
implements IPortalEventAggregator<E> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String aggregationsCacheKey = this.getClass().getName() + ".AGGREGATIONS_FOR_INTERVAL";
    private AggregationIntervalHelper aggregationIntervalHelper;

    @Autowired
    public void setAggregationIntervalHelper(AggregationIntervalHelper aggregationIntervalHelper) {
        this.aggregationIntervalHelper = aggregationIntervalHelper;
    }

    protected abstract BaseAggregationPrivateDao<T, K> getAggregationDao();

    protected abstract void updateAggregation(E var1, EventAggregationContext var2, AggregationIntervalInfo var3, T var4);

    protected abstract K createAggregationKey(E var1, EventAggregationContext var2, AggregationIntervalInfo var3, AggregatedGroupMapping var4);

    public boolean supports(PortalEvent event) {
        return this.supports(event.getClass());
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public final void aggregateEvent(E e, EventSession eventSession, EventAggregationContext eventAggregationContext, Map<AggregationInterval, AggregationIntervalInfo> currentIntervals) {
        BaseAggregationPrivateDao aggregationDao = this.getAggregationDao();
        for (Map.Entry<AggregationInterval, AggregationIntervalInfo> intervalInfoEntry : currentIntervals.entrySet()) {
            AggregationIntervalInfo intervalInfo = intervalInfoEntry.getValue();
            HashMap<BaseAggregationKey, BaseAggregationImpl> aggregationsCache = (HashMap<BaseAggregationKey, BaseAggregationImpl>)eventAggregationContext.getAttribute((Object)this.aggregationsCacheKey);
            if (aggregationsCache == null) {
                aggregationsCache = new HashMap<BaseAggregationKey, BaseAggregationImpl>();
                eventAggregationContext.setAttribute((Object)this.aggregationsCacheKey, aggregationsCache);
            }
            Set groupMappings = eventSession.getGroupMappings();
            for (AggregatedGroupMapping groupMapping : groupMappings) {
                BaseAggregationKey key = this.createAggregationKey(e, eventAggregationContext, intervalInfo, groupMapping);
                BaseAggregationImpl aggregation = (BaseAggregationImpl)aggregationsCache.get(key);
                if (aggregation == null) {
                    aggregation = (BaseAggregationImpl)aggregationDao.getAggregation(key);
                    if (aggregation == null) {
                        aggregation = aggregationDao.createAggregation(key);
                    }
                    aggregationsCache.put(key, aggregation);
                }
                this.updateAggregation(e, eventAggregationContext, intervalInfo, aggregation);
            }
        }
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public final void handleIntervalBoundary(AggregationInterval interval, EventAggregationContext eventAggregationContext, Map<AggregationInterval, AggregationIntervalInfo> intervals) {
        AggregationIntervalInfo intervalInfo = intervals.get(interval);
        BaseAggregationPrivateDao aggregationDao = this.getAggregationDao();
        Map aggregationsForInterval = (Map)eventAggregationContext.getAttribute((Object)this.aggregationsCacheKey);
        if (aggregationsForInterval == null) {
            return;
        }
        ArrayList<BaseAggregationImpl> updatedAggregations = new ArrayList<BaseAggregationImpl>(aggregationsForInterval.size() / intervals.size());
        Collection aggregations = aggregationsForInterval.values();
        Iterator aggregationItr = aggregations.iterator();
        while (aggregationItr.hasNext()) {
            BaseAggregationImpl aggregation = (BaseAggregationImpl)aggregationItr.next();
            if (aggregation.getInterval() != interval) continue;
            int duration = intervalInfo.getTotalDuration();
            aggregation.intervalComplete(duration);
            aggregationItr.remove();
            updatedAggregations.add(aggregation);
        }
        aggregationDao.updateAggregations(updatedAggregations, true);
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public int cleanUnclosedAggregations(DateTime start, DateTime end, AggregationInterval interval) {
        BaseAggregationPrivateDao aggregationDao = this.getAggregationDao();
        Collection unclosedAggregations = aggregationDao.getUnclosedAggregations(start, end, interval);
        for (BaseAggregationImpl aggregation : unclosedAggregations) {
            DateTime eventDate = aggregation.getDateTime();
            AggregationIntervalInfo unclosedIntervalInfo = this.aggregationIntervalHelper.getIntervalInfo(interval, eventDate);
            aggregation.intervalComplete(unclosedIntervalInfo.getTotalDuration());
        }
        aggregationDao.updateAggregations((Iterable)unclosedAggregations, true);
        return unclosedAggregations.size();
    }
}

