/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import org.jasig.portal.concurrency.locking.IClusterLockService;
import org.jasig.portal.events.aggr.EventProcessingResult;
import org.jasig.portal.events.aggr.IEventAggregatorStatus;
import org.jasig.portal.events.aggr.PortalEventSessionPurger;
import org.jasig.portal.events.aggr.dao.IEventAggregationManagementDao;
import org.jasig.portal.events.aggr.session.EventSessionDao;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PortalEventSessionPurgerImpl
implements PortalEventSessionPurger {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IEventAggregationManagementDao eventAggregationManagementDao;
    private EventSessionDao eventSessionDao;
    private IClusterLockService clusterLockService;
    private ReadablePeriod eventSessionDuration = Period.days((int)1);

    @Autowired
    public void setEventSessionDao(EventSessionDao eventSessionDao) {
        this.eventSessionDao = eventSessionDao;
    }

    @Autowired
    public void setClusterLockService(IClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    @Autowired
    public void setEventAggregationManagementDao(IEventAggregationManagementDao eventAggregationManagementDao) {
        this.eventAggregationManagementDao = eventAggregationManagementDao;
    }

    @Value(value="${org.jasig.portal.events.aggr.session.PortalEventSessionPurgerImpl.eventSessionDuration:P1D}")
    public void setEventSessionDuration(ReadablePeriod eventSessionDuration) {
        this.eventSessionDuration = eventSessionDuration;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public EventProcessingResult doPurgeEventSessions() {
        if (!this.clusterLockService.isLockOwner(PURGE_EVENT_SESSION_LOCK_NAME)) {
            throw new IllegalStateException("The cluster lock " + PURGE_EVENT_SESSION_LOCK_NAME + " must be owned by the current thread and server");
        }
        IEventAggregatorStatus eventAggregatorStatus = this.eventAggregationManagementDao.getEventAggregatorStatus(IEventAggregatorStatus.ProcessingType.AGGREGATION, false);
        if (eventAggregatorStatus == null || eventAggregatorStatus.getLastEventDate() == null) {
            return new EventProcessingResult(0, null, null, true);
        }
        DateTime lastEventDate = eventAggregatorStatus.getLastEventDate();
        DateTime sessionPurgeDate = lastEventDate.minus(this.eventSessionDuration);
        int purgeCount = this.eventSessionDao.purgeEventSessionsBefore(sessionPurgeDate);
        return new EventProcessingResult(purgeCount, null, sessionPurgeDate, true);
    }
}

