/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.PostLoad;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="UP_UNIQUE_STR_SEGMENT")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_UNIQUE_STR_SEGMENT_GEN", sequenceName="UP_UNIQUE_STR_SEGMENT_SEQ", allocationSize=1000)
@TableGenerator(name="UP_UNIQUE_STR_SEGMENT_GEN", pkColumnValue="UP_UNIQUE_STR_SEGMENT_PROP", allocationSize=1000)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public final class UniqueStringsSegment {
    @Id
    @GeneratedValue(generator="UP_UNIQUE_STR_SEGMENT_GEN")
    @Column(name="UNIQUE_STR_SEGMENT_ID")
    private final long id;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="UP_UNIQUE_STR_SEGMENT__UIDS", joinColumns={@JoinColumn(name="UNIQUE_STR_SEGMENT_ID")})
    @Column(name="UNIQUE_STR", nullable=false, updatable=false, length=255)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<String> uniqueStrings = new HashSet();
    @Transient
    private boolean closed = false;

    public UniqueStringsSegment() {
        this.id = -1L;
    }

    public UniqueStringsSegment(Collection<UniqueStringsSegment> uniqueStringsSegments) {
        this.id = -1L;
        for (UniqueStringsSegment uniqueStringsSegment : uniqueStringsSegments) {
            this.uniqueStrings.addAll(uniqueStringsSegment.uniqueStrings);
        }
    }

    @PostLoad
    @PreUpdate
    void closeSegment() {
        this.closed = true;
    }

    public int size() {
        return this.uniqueStrings.size();
    }

    public boolean contains(String o) {
        return this.uniqueStrings.contains(o);
    }

    public boolean add(String e) {
        if (this.closed) {
            throw new IllegalStateException("Segment is already closed");
        }
        return this.uniqueStrings.add(e);
    }

    public boolean addAll(UniqueStringsSegment s) {
        return this.uniqueStrings.addAll(s.uniqueStrings);
    }

    public boolean addAll(Collection<? extends String> c) {
        return this.uniqueStrings.addAll(c);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.id == -1L) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueStringsSegment other = (UniqueStringsSegment)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "UniqueStringsSegment [id=" + this.id + ", size=" + this.uniqueStrings.size() + ", closed=" + this.closed + "]";
    }
}

