/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.concuser;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Table;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationImpl;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.UniqueStrings;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregation;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationDiscriminator;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationKey;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationKeyImpl;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;

@Entity
@javax.persistence.Table(name="UP_CONCURRENT_USER_AGGR")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_CONCURRENT_USER_AGGR_GEN", sequenceName="UP_CONCURRENT_USER_AGGR_SEQ", allocationSize=1000)
@TableGenerator(name="UP_CONCURRENT_USER_AGGR_GEN", pkColumnValue="UP_CONCURRENT_USER_AGGR_PROP", allocationSize=1000)
@Table(appliesTo="UP_CONCURRENT_USER_AGGR", indexes={@Index(name="IDX_UP_CONC_USER_AGGR_DTI", columnNames={"DATE_DIMENSION_ID", "TIME_DIMENSION_ID", "AGGR_INTERVAL"}), @Index(name="IDX_UP_CONC_USER_INTRVL", columnNames={"AGGR_INTERVAL"}), @Index(name="IDX_UP_CONC_USER_GRP", columnNames={"AGGR_GROUP_ID"})})
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public final class ConcurrentUserAggregationImpl
extends BaseAggregationImpl<ConcurrentUserAggregationKey, ConcurrentUserAggregationDiscriminator>
implements ConcurrentUserAggregation,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_CONCURRENT_USER_AGGR_GEN")
    @Column(name="ID")
    private final long id;
    @Column(name="CONCURRENT_USERS", nullable=false)
    private int concurrentUsers;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="UNIQUE_STRINGS_ID")
    @Fetch(value=FetchMode.JOIN)
    private UniqueStrings uniqueStrings;
    @Transient
    private ConcurrentUserAggregationKey aggregationKey;
    @Transient
    private ConcurrentUserAggregationDiscriminator aggregationDiscriminator;

    private ConcurrentUserAggregationImpl() {
        this.id = -1L;
    }

    ConcurrentUserAggregationImpl(TimeDimension timeDimension, DateDimension dateDimension, AggregationInterval interval, AggregatedGroupMapping aggregatedGroup) {
        super(timeDimension, dateDimension, interval, aggregatedGroup);
        this.id = -1L;
    }

    public long getId() {
        return this.id;
    }

    public int getConcurrentUsers() {
        return this.concurrentUsers;
    }

    public ConcurrentUserAggregationKey getAggregationKey() {
        ConcurrentUserAggregationKey key = this.aggregationKey;
        if (key == null) {
            this.aggregationKey = key = new ConcurrentUserAggregationKeyImpl((ConcurrentUserAggregation)this);
        }
        return key;
    }

    public ConcurrentUserAggregationDiscriminator getAggregationDiscriminator() {
        ConcurrentUserAggregationDiscriminator discriminator = this.aggregationDiscriminator;
        if (discriminator == null) {
            this.aggregationDiscriminator = discriminator = new ConcurrentUserAggregationDiscriminatorImpl((ConcurrentUserAggregation)this);
        }
        return discriminator;
    }

    protected boolean isComplete() {
        return this.concurrentUsers > 0 && this.uniqueStrings == null;
    }

    protected void completeInterval() {
        this.uniqueStrings = null;
    }

    void countSession(String eventSessionId) {
        if (this.isComplete()) {
            this.getLogger().warn("{} is already closed, the event session {} will be ignored on: {}", new Object[]{this.getClass().getSimpleName(), eventSessionId, this});
            return;
        }
        if (this.uniqueStrings == null) {
            this.uniqueStrings = new UniqueStrings();
        }
        if (this.uniqueStrings.add(eventSessionId)) {
            ++this.concurrentUsers;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConcurrentUserAggregation)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "ConcurrentUserAggregationImpl [id=" + this.id + ", dateDimension=" + this.getDateDimension() + ", timeDimension=" + this.getTimeDimension() + ", interval=" + this.getInterval() + ", aggregatedGroup=" + this.getAggregatedGroup() + ", duration=" + this.getDuration() + ", concurrentUsers=" + this.concurrentUsers + "]";
    }
}

