/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.NaturalId;
import org.jasig.portal.events.aggr.AggregatedGroupConfig;
import org.jasig.portal.events.aggr.IPortalEventAggregator;
import org.jasig.portal.events.aggr.dao.jpa.BaseAggregatedDimensionConfigImpl;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMappingImpl;

@Entity
@Table(name="UP_EVENT_AGGR_CONF_GROUPS")
@SequenceGenerator(name="UP_EVENT_AGGR_CONF_GROUPS_GEN", sequenceName="UP_EVENT_AGGR_CONF_GROUPS_SEQ", allocationSize=1)
@TableGenerator(name="UP_EVENT_AGGR_CONF_GROUPS_GEN", pkColumnValue="UP_EVENT_AGGR_CONF_GROUPS", allocationSize=1)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class AggregatedGroupConfigImpl
extends BaseAggregatedDimensionConfigImpl<AggregatedGroupMapping>
implements AggregatedGroupConfig {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_EVENT_AGGR_CONF_GROUPS_GEN")
    @Column(name="ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion = -1L;
    @NaturalId
    @Column(name="AGGREGATOR_TYPE", nullable=false, updatable=false)
    private final Class<? extends IPortalEventAggregator> aggregatorType;
    @OneToMany(targetEntity=AggregatedGroupMappingImpl.class, fetch=FetchType.EAGER)
    @JoinTable(name="UP_EVENT_AGGR_CONF_GROUPS_INC", joinColumns={@JoinColumn(name="UP_EVENT_AGGR_CONF_GROUPS_ID")}, inverseJoinColumns={@JoinColumn(name="GROUP_ID")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Set<AggregatedGroupMapping> includedGroups;
    @OneToMany(targetEntity=AggregatedGroupMappingImpl.class, fetch=FetchType.EAGER)
    @JoinTable(name="UP_EVENT_AGGR_CONF_GROUPS_EXC", joinColumns={@JoinColumn(name="UP_EVENT_AGGR_CONF_GROUPS_ID")}, inverseJoinColumns={@JoinColumn(name="GROUP_ID")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Set<AggregatedGroupMapping> excludedGroups;

    private AggregatedGroupConfigImpl() {
        this.id = -1L;
        this.aggregatorType = null;
        this.includedGroups = null;
        this.excludedGroups = null;
    }

    AggregatedGroupConfigImpl(Class<? extends IPortalEventAggregator> aggregatorType) {
        Validate.notNull(aggregatorType);
        this.id = -1L;
        this.aggregatorType = aggregatorType;
        this.includedGroups = new LinkedHashSet();
        this.excludedGroups = new LinkedHashSet();
    }

    public Class<? extends IPortalEventAggregator> getAggregatorType() {
        return this.aggregatorType;
    }

    public long getVersion() {
        this.getClass();
        return -1L;
    }

    public Set<AggregatedGroupMapping> getIncluded() {
        return this.includedGroups;
    }

    public Set<AggregatedGroupMapping> getExcluded() {
        return this.excludedGroups;
    }

    public String toString() {
        return "AggregatedGroupConfigImpl [aggregatorType=" + this.aggregatorType + "]";
    }
}

