/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.NaturalId;
import org.jasig.portal.events.aggr.AggregatedIntervalConfig;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.IPortalEventAggregator;
import org.jasig.portal.events.aggr.dao.jpa.BaseAggregatedDimensionConfigImpl;

@Entity
@Table(name="UP_EVENT_AGGR_CONF_INTRVL")
@SequenceGenerator(name="UP_EVENT_AGGR_CONF_INTRVL_GEN", sequenceName="UP_EVENT_AGGR_CONF_INTRVL_SEQ", allocationSize=1)
@TableGenerator(name="UP_EVENT_AGGR_CONF_INTRVL_GEN", pkColumnValue="UP_EVENT_AGGR_CONF_INTRVL", allocationSize=1)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class AggregatedIntervalConfigImpl
extends BaseAggregatedDimensionConfigImpl<AggregationInterval>
implements AggregatedIntervalConfig {
    @Id
    @GeneratedValue(generator="UP_EVENT_AGGR_CONF_INTRVL_GEN")
    @Column(name="ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion = -1L;
    @NaturalId
    @Column(name="AGGREGATOR_TYPE", nullable=false, updatable=false)
    private final Class<? extends IPortalEventAggregator> aggregatorType;
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinTable(name="UP_EVENT_AGGR_CONF_INTRVL_INC", joinColumns={@JoinColumn(name="UP_EVENT_AGGR_CONF_INTRVL_ID")})
    @Fetch(value=FetchMode.JOIN)
    @Enumerated(value=EnumType.STRING)
    @Column(name="AGGR_INTERVAL")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<AggregationInterval> includedIntervals;
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinTable(name="UP_EVENT_AGGR_CONF_INTRVL_EXC", joinColumns={@JoinColumn(name="UP_EVENT_AGGR_CONF_INTRVL_ID")})
    @Fetch(value=FetchMode.JOIN)
    @Enumerated(value=EnumType.STRING)
    @Column(name="AGGR_INTERVAL")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<AggregationInterval> excludedIntervals;

    private AggregatedIntervalConfigImpl() {
        this.id = -1L;
        this.aggregatorType = null;
        this.includedIntervals = null;
        this.excludedIntervals = null;
    }

    AggregatedIntervalConfigImpl(Class<? extends IPortalEventAggregator> aggregatorType) {
        Validate.notNull(aggregatorType);
        this.id = -1L;
        this.aggregatorType = aggregatorType;
        this.includedIntervals = new LinkedHashSet();
        this.excludedIntervals = new LinkedHashSet();
    }

    public long getVersion() {
        this.getClass();
        return -1L;
    }

    public Class<? extends IPortalEventAggregator> getAggregatorType() {
        return this.aggregatorType;
    }

    public Set<AggregationInterval> getIncluded() {
        return this.includedIntervals;
    }

    public Set<AggregationInterval> getExcluded() {
        return this.excludedIntervals;
    }

    public String toString() {
        return "AggregatedIntervalConfigImpl [aggregatorType=" + this.aggregatorType + "]";
    }
}

