/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.dao.DateDimensionDao;
import org.jasig.portal.events.aggr.dao.jpa.DateDimensionImpl;
import org.jasig.portal.events.aggr.dao.jpa.DateDimensionImpl_;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.joda.time.DateMidnight;
import org.joda.time.LocalDate;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository
public class JpaDateDimensionDao
extends BaseAggrEventsJpaDao
implements DateDimensionDao {
    private CriteriaQuery<DateDimensionImpl> findAllDateDimensionsQuery;
    private CriteriaQuery<DateDimensionImpl> findAllDateDimensionsBetweenQuery;
    private CriteriaQuery<DateDimensionImpl> findAllDateDimensionsWithoutTermQuery;
    private CriteriaQuery<DateDimensionImpl> findNewestDateDimensionQuery;
    private CriteriaQuery<DateDimensionImpl> findOldestDateDimensionQuery;
    private ParameterExpression<LocalDate> dateTimeParameter;
    private ParameterExpression<LocalDate> endDateTimeParameter;

    public void afterPropertiesSet() throws Exception {
        this.dateTimeParameter = this.createParameterExpression(LocalDate.class, "dateTime");
        this.endDateTimeParameter = this.createParameterExpression(LocalDate.class, "endDateTime");
        this.findAllDateDimensionsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAllDateDimensionsBetweenQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAllDateDimensionsWithoutTermQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findNewestDateDimensionQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findOldestDateDimensionQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public DateDimension getNewestDateDimension() {
        TypedQuery query = this.createCachedQuery(this.findNewestDateDimensionQuery);
        List resultList = query.getResultList();
        return (DateDimension)DataAccessUtils.uniqueResult((Collection)resultList);
    }

    public DateDimension getOldestDateDimension() {
        TypedQuery query = this.createCachedQuery(this.findOldestDateDimensionQuery);
        List resultList = query.getResultList();
        return (DateDimension)DataAccessUtils.uniqueResult((Collection)resultList);
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public DateDimension createDateDimension(DateMidnight date, int quarter, String term) {
        DateDimensionImpl dateDimension = new DateDimensionImpl(date, quarter, term);
        this.getEntityManager().persist((Object)dateDimension);
        return dateDimension;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void updateDateDimension(DateDimension dateDimension) {
        this.getEntityManager().persist((Object)dateDimension);
    }

    public List<DateDimension> getDateDimensions() {
        TypedQuery query = this.createCachedQuery(this.findAllDateDimensionsQuery);
        query.setFlushMode(FlushModeType.COMMIT);
        List portletDefinitions = query.getResultList();
        return new ArrayList<DateDimension>(portletDefinitions);
    }

    public List<DateDimension> getDateDimensionsBetween(DateMidnight start, DateMidnight end) {
        TypedQuery query = this.createCachedQuery(this.findAllDateDimensionsBetweenQuery);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter((Parameter)this.dateTimeParameter, (Object)start.toLocalDate());
        query.setParameter((Parameter)this.endDateTimeParameter, (Object)end.toLocalDate());
        List portletDefinitions = query.getResultList();
        return new ArrayList<DateDimension>(portletDefinitions);
    }

    public List<DateDimension> getDateDimensionsWithoutTerm() {
        TypedQuery query = this.createQuery(this.findAllDateDimensionsWithoutTermQuery);
        query.setFlushMode(FlushModeType.COMMIT);
        List portletDefinitions = query.getResultList();
        return new ArrayList<DateDimension>(portletDefinitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateDimension getDateDimensionById(long key) {
        EntityManager entityManager = this.getEntityManager();
        FlushModeType flushMode = entityManager.getFlushMode();
        try {
            entityManager.setFlushMode(FlushModeType.COMMIT);
            DateDimension dateDimension = (DateDimension)entityManager.find(DateDimensionImpl.class, (Object)key);
            return dateDimension;
        }
        finally {
            entityManager.setFlushMode(flushMode);
        }
    }

    @OpenEntityManager(unitName="AggrEventsDb")
    public DateDimension getDateDimensionByDate(DateMidnight date) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(DateDimensionImpl.class);
        query.using((Attribute)DateDimensionImpl_.date, (Object)date.toLocalDate());
        return (DateDimension)query.load();
    }

    static /* synthetic */ ParameterExpression access$000(JpaDateDimensionDao x0) {
        return x0.dateTimeParameter;
    }

    static /* synthetic */ ParameterExpression access$100(JpaDateDimensionDao x0) {
        return x0.endDateTimeParameter;
    }
}

