/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.jasig.portal.events.aggr.EventDateTimeUtils;
import org.jasig.portal.events.aggr.QuarterDetail;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.MonthDay;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

@Entity
@Table(name="UP_QUARTER_DETAIL")
@SequenceGenerator(name="UP_QUARTER_DETAIL_GEN", sequenceName="UP_QUARTER_DETAIL_SEQ", allocationSize=1)
@TableGenerator(name="UP_QUARTER_DETAIL_GEN", pkColumnValue="UP_QUARTER_DETAIL_PROP", allocationSize=1)
@Immutable
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class QuarterDetailImpl
implements QuarterDetail,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_QUARTER_DETAIL_GEN")
    @Column(name="QUARTER_ID")
    private final long id;
    @NaturalId
    @Column(name="QUARTER_START", nullable=false)
    @Type(type="monthDay")
    private final MonthDay start;
    @NaturalId
    @Column(name="QUARTER_END", nullable=false)
    @Type(type="monthDay")
    private final MonthDay end;
    @NaturalId
    @Column(name="QUARTER_NUMBER", nullable=false)
    private final int quarterId;

    private QuarterDetailImpl() {
        this.id = -1L;
        this.start = null;
        this.end = null;
        this.quarterId = -1;
    }

    public QuarterDetailImpl(MonthDay start, MonthDay end, int quarterId) {
        Validate.notNull((Object)start);
        Validate.notNull((Object)end);
        if (start.isEqual((ReadablePartial)end)) {
            throw new IllegalArgumentException("start cannot equal end");
        }
        this.id = -1L;
        this.start = start;
        this.end = end;
        this.quarterId = quarterId;
    }

    public int getQuarterId() {
        return this.quarterId;
    }

    public MonthDay getStart() {
        return this.start;
    }

    public DateMidnight getStartDateMidnight(ReadableInstant instant) {
        MonthDay instantMonthDay = new MonthDay((Object)instant);
        if (this.end.isBefore((ReadablePartial)this.start) && instantMonthDay.isBefore((ReadablePartial)this.start) && this.end.isAfter((ReadablePartial)instantMonthDay)) {
            return this.start.toDateTime((ReadableInstant)new DateTime((Object)instant).minusYears(1)).toDateMidnight();
        }
        return this.start.toDateTime(instant).toDateMidnight();
    }

    public DateMidnight getEndDateMidnight(ReadableInstant instant) {
        MonthDay instantMonthDay = new MonthDay((Object)instant);
        if (this.end.isBefore((ReadablePartial)this.start) && !this.end.isAfter((ReadablePartial)instantMonthDay) && !instantMonthDay.isBefore((ReadablePartial)this.start)) {
            return this.end.toDateTime((ReadableInstant)new DateTime((Object)instant).plusYears(1)).toDateMidnight();
        }
        return this.end.toDateTime(instant).toDateMidnight();
    }

    public MonthDay getEnd() {
        return this.end;
    }

    public int compareTo(ReadableInstant instant) {
        DateMidnight startDateTime = this.getStartDateMidnight(instant);
        DateMidnight endDateTime = this.getEndDateMidnight(instant);
        return EventDateTimeUtils.compareTo((ReadableInstant)startDateTime, (ReadableInstant)endDateTime, (ReadableInstant)instant);
    }

    public int compareTo(QuarterDetail o) {
        return this.getQuarterId() - o.getQuarterId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + this.quarterId;
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuarterDetailImpl other = (QuarterDetailImpl)obj;
        if (this.end == null ? other.end != null : !this.end.equals((Object)other.end)) {
            return false;
        }
        if (this.quarterId != other.quarterId) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals((Object)other.start));
    }

    public String toString() {
        return "QuarterDetailImpl [quarterId=" + this.quarterId + ", start=" + this.start + ", end=" + this.end + "]";
    }
}

