/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.login;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Table;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationImpl;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.UniqueStrings;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.login.LoginAggregation;
import org.jasig.portal.events.aggr.login.LoginAggregationDiscriminator;
import org.jasig.portal.events.aggr.login.LoginAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.login.LoginAggregationKey;
import org.jasig.portal.events.aggr.login.LoginAggregationKeyImpl;

@Entity
@javax.persistence.Table(name="UP_LOGIN_EVENT_AGGR")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_LOGIN_EVENT_AGGR_GEN", sequenceName="UP_LOGIN_EVENT_AGGR_SEQ", allocationSize=1000)
@TableGenerator(name="UP_LOGIN_EVENT_AGGR_GEN", pkColumnValue="UP_LOGIN_EVENT_AGGR_PROP", allocationSize=1000)
@Table(appliesTo="UP_LOGIN_EVENT_AGGR", indexes={@Index(name="IDX_UP_LOGIN_EVENT_AGGR_DTI", columnNames={"DATE_DIMENSION_ID", "TIME_DIMENSION_ID", "AGGR_INTERVAL"}), @Index(name="IDX_UP_LOGIN_EVENT_INTRVL", columnNames={"AGGR_INTERVAL"}), @Index(name="IDX_UP_LOGIN_EVENT_GRP", columnNames={"AGGR_GROUP_ID"})})
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public final class LoginAggregationImpl
extends BaseAggregationImpl<LoginAggregationKey, LoginAggregationDiscriminator>
implements LoginAggregation,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_LOGIN_EVENT_AGGR_GEN")
    @Column(name="ID")
    private final long id;
    @Column(name="LOGIN_COUNT", nullable=false)
    private int loginCount;
    @Column(name="UNIQUE_LOGIN_COUNT", nullable=false)
    private int uniqueLoginCount;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="UNIQUE_STRINGS_ID")
    @Fetch(value=FetchMode.JOIN)
    private UniqueStrings uniqueStrings;
    @Transient
    private LoginAggregationKeyImpl aggregationKey;
    @Transient
    private LoginAggregationDiscriminator aggregationDiscriminator;

    private LoginAggregationImpl() {
        this.id = -1L;
    }

    LoginAggregationImpl(TimeDimension timeDimension, DateDimension dateDimension, AggregationInterval interval, AggregatedGroupMapping aggregatedGroup) {
        super(timeDimension, dateDimension, interval, aggregatedGroup);
        this.id = -1L;
    }

    public long getId() {
        return this.id;
    }

    public int getLoginCount() {
        return this.loginCount;
    }

    public int getUniqueLoginCount() {
        return this.uniqueLoginCount;
    }

    public LoginAggregationKey getAggregationKey() {
        LoginAggregationKeyImpl key = this.aggregationKey;
        if (key == null) {
            this.aggregationKey = key = new LoginAggregationKeyImpl((LoginAggregation)this);
        }
        return key;
    }

    public LoginAggregationDiscriminator getAggregationDiscriminator() {
        LoginAggregationDiscriminator discriminator = this.aggregationDiscriminator;
        if (discriminator == null) {
            this.aggregationDiscriminator = discriminator = new LoginAggregationDiscriminatorImpl((LoginAggregation)this);
        }
        return discriminator;
    }

    protected boolean isComplete() {
        return this.loginCount > 0 && this.uniqueStrings == null;
    }

    protected void completeInterval() {
        this.uniqueStrings = null;
    }

    void countUser(String userName) {
        if (this.isComplete()) {
            this.getLogger().warn("{} is already closed, the user name {} will be ignored on: {}", new Object[]{this.getClass().getSimpleName(), userName, this});
            return;
        }
        if (this.uniqueStrings == null) {
            this.uniqueStrings = new UniqueStrings();
        }
        if (this.uniqueStrings.add(userName)) {
            ++this.uniqueLoginCount;
        }
        ++this.loginCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LoginAggregation)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "LoginAggregationImpl [id=" + this.id + ", timeDimension=" + this.getTimeDimension() + ", dateDimension=" + this.getDateDimension() + ", interval=" + this.getInterval() + ", groupName=" + this.getAggregatedGroup() + ", duration=" + this.getDuration() + ", loginCount=" + this.loginCount + ", uniqueLoginCount=" + this.uniqueLoginCount + "]";
    }
}

