/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.login;

import org.jasig.portal.events.LoginEvent;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.BaseAggregationPrivateDao;
import org.jasig.portal.events.aggr.BasePortalEventAggregator;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.EventAggregationContext;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.login.LoginAggregationImpl;
import org.jasig.portal.events.aggr.login.LoginAggregationKey;
import org.jasig.portal.events.aggr.login.LoginAggregationKeyImpl;
import org.jasig.portal.events.aggr.login.LoginAggregationPrivateDao;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

public class LoginPortalEventAggregator
extends BasePortalEventAggregator<LoginEvent, LoginAggregationImpl, LoginAggregationKey> {
    private LoginAggregationPrivateDao loginAggregationDao;

    @Autowired
    public void setLoginAggregationDao(LoginAggregationPrivateDao loginAggregationDao) {
        this.loginAggregationDao = loginAggregationDao;
    }

    protected BaseAggregationPrivateDao<LoginAggregationImpl, LoginAggregationKey> getAggregationDao() {
        return this.loginAggregationDao;
    }

    protected LoginAggregationKey createAggregationKey(LoginEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, AggregatedGroupMapping aggregatedGroup) {
        TimeDimension timeDimension = intervalInfo.getTimeDimension();
        DateDimension dateDimension = intervalInfo.getDateDimension();
        AggregationInterval aggregationInterval = intervalInfo.getAggregationInterval();
        return new LoginAggregationKeyImpl(dateDimension, timeDimension, aggregationInterval, aggregatedGroup);
    }

    public boolean supports(Class<? extends PortalEvent> type) {
        return LoginEvent.class.isAssignableFrom(type);
    }

    protected void updateAggregation(LoginEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, LoginAggregationImpl aggregation) {
        String userName = e.getUserName();
        int duration = intervalInfo.getDurationTo((ReadableInstant)e.getTimestampAsDate());
        aggregation.setDuration(duration);
        aggregation.countUser(userName);
    }
}

