/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.portletexec;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Table;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseTimedAggregationStatsImpl;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregation;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationDiscriminator;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationKey;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationKeyImpl;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMappingImpl;

@Entity
@javax.persistence.Table(name="UP_PORTLET_EXEC_AGGR")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_PORTLET_EXEC_AGGR_GEN", sequenceName="UP_PORTLET_EXEC_AGGR_SEQ", allocationSize=10000)
@TableGenerator(name="UP_PORTLET_EXEC_AGGR_GEN", pkColumnValue="UP_PORTLET_EXEC_AGGR_PROP", allocationSize=10000)
@Table(appliesTo="UP_PORTLET_EXEC_AGGR", indexes={@Index(name="IDX_UP_PLT_EXEC_AGGR_DTI", columnNames={"DATE_DIMENSION_ID", "TIME_DIMENSION_ID", "AGGR_INTERVAL"}), @Index(name="IDX_UP_PLT_EXEC_AGGR_DTIC", columnNames={"DATE_DIMENSION_ID", "TIME_DIMENSION_ID", "AGGR_INTERVAL", "STATS_COMPLETE"}), @Index(name="IDX_UP_PLT_EXEC_INTRVL", columnNames={"AGGR_INTERVAL"}), @Index(name="IDX_UP_PLT_EXEC_GRP", columnNames={"AGGR_GROUP_ID"})})
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public final class PortletExecutionAggregationImpl
extends BaseTimedAggregationStatsImpl<PortletExecutionAggregationKey, PortletExecutionAggregationDiscriminator>
implements PortletExecutionAggregation,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_PORTLET_EXEC_AGGR_GEN")
    @Column(name="ID")
    private final long id;
    @NaturalId
    @ManyToOne(targetEntity=AggregatedPortletMappingImpl.class)
    @JoinColumn(name="AGGR_PORTLET_ID", nullable=false)
    private final AggregatedPortletMapping aggregatedPortlet;
    @NaturalId
    @Column(name="EXECUTION_TYPE", nullable=false, length=50)
    @Enumerated(value=EnumType.STRING)
    private final PortletExecutionAggregationKey.ExecutionType executionType;
    @Transient
    private PortletExecutionAggregationKey aggregationKey;
    @Transient
    private PortletExecutionAggregationDiscriminator aggregationDiscriminator;

    private PortletExecutionAggregationImpl() {
        this.id = -1L;
        this.aggregatedPortlet = null;
        this.executionType = null;
    }

    PortletExecutionAggregationImpl(TimeDimension timeDimension, DateDimension dateDimension, AggregationInterval interval, AggregatedGroupMapping aggregatedGroup, AggregatedPortletMapping aggregatedPortlet, PortletExecutionAggregationKey.ExecutionType executionType) {
        super(timeDimension, dateDimension, interval, aggregatedGroup);
        Validate.notNull((Object)aggregatedPortlet);
        Validate.notNull((Object)executionType);
        this.id = -1L;
        this.aggregatedPortlet = aggregatedPortlet;
        this.executionType = executionType;
    }

    public long getId() {
        return this.id;
    }

    public AggregatedPortletMapping getPortletMapping() {
        return this.aggregatedPortlet;
    }

    public int getExecutionCount() {
        return (int)this.getN();
    }

    public PortletExecutionAggregationKey.ExecutionType getExecutionType() {
        return this.executionType;
    }

    public PortletExecutionAggregationKey getAggregationKey() {
        PortletExecutionAggregationKey key = this.aggregationKey;
        if (key == null) {
            this.aggregationKey = key = new PortletExecutionAggregationKeyImpl((PortletExecutionAggregation)this);
        }
        return key;
    }

    public PortletExecutionAggregationDiscriminator getAggregationDiscriminator() {
        PortletExecutionAggregationDiscriminator discriminator = this.aggregationDiscriminator;
        if (discriminator == null) {
            this.aggregationDiscriminator = discriminator = new PortletExecutionAggregationDiscriminatorImpl((PortletExecutionAggregation)this);
        }
        return discriminator;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aggregatedPortlet == null ? 0 : this.aggregatedPortlet.hashCode());
        result = 31 * result + (this.executionType == null ? 0 : this.executionType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PortletExecutionAggregation)) {
            return false;
        }
        PortletExecutionAggregation other = (PortletExecutionAggregation)obj;
        if (this.aggregatedPortlet == null ? other.getPortletMapping() != null : !this.aggregatedPortlet.equals(other.getPortletMapping())) {
            return false;
        }
        return this.executionType == other.getExecutionType();
    }

    public String toString() {
        return "PortletExecutionAggregationImpl [aggregatedPortlet=" + this.aggregatedPortlet + ", executionType=" + this.executionType + ", timeDimension=" + this.getTimeDimension() + ", dateDimension=" + this.getDateDimension() + ", interval=" + this.getInterval() + ", aggregatedGroup=" + this.getAggregatedGroup() + "]";
    }
}

