/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.portletexec;

import java.util.HashMap;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.PortletExecutionEvent;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.BaseAggregationPrivateDao;
import org.jasig.portal.events.aggr.BasePortalEventAggregator;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.EventAggregationContext;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationImpl;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationKey;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationKeyImpl;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationPrivateDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletLookupDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

public class PortletExecutionAggregator
extends BasePortalEventAggregator<PortletExecutionEvent, PortletExecutionAggregationImpl, PortletExecutionAggregationKey> {
    private static final String MAPPED_PORTLETS_CACHE_KEY = PortletExecutionAggregator.class.getName() + "_MAPPED_PORTLETS";
    private PortletExecutionAggregationPrivateDao portletExecutionAggregationDao;
    private AggregatedPortletLookupDao aggregatedPortletLookupDao;
    private PortletExecutionAggregationKey.ExecutionType executionType = PortletExecutionAggregationKey.ExecutionType.ALL;

    @Autowired
    public void setPortletExecutionAggregationDao(PortletExecutionAggregationPrivateDao portletExecutionAggregationDao) {
        this.portletExecutionAggregationDao = portletExecutionAggregationDao;
    }

    @Autowired
    public void setAggregatedPortletLookupDao(AggregatedPortletLookupDao aggregatedPortletLookupDao) {
        this.aggregatedPortletLookupDao = aggregatedPortletLookupDao;
    }

    public void setExecutionType(PortletExecutionAggregationKey.ExecutionType executionType) {
        this.executionType = executionType;
    }

    public boolean supports(Class<? extends PortalEvent> type) {
        return this.executionType.supports(type);
    }

    public boolean supports(PortalEvent event) {
        return super.supports(event);
    }

    protected BaseAggregationPrivateDao<PortletExecutionAggregationImpl, PortletExecutionAggregationKey> getAggregationDao() {
        return this.portletExecutionAggregationDao;
    }

    protected void updateAggregation(PortletExecutionEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, PortletExecutionAggregationImpl aggregation) {
        long executionTime = e.getExecutionTimeNano();
        int duration = intervalInfo.getDurationTo((ReadableInstant)e.getTimestampAsDate());
        aggregation.setDuration(duration);
        aggregation.addValue((double)executionTime);
    }

    protected PortletExecutionAggregationKey createAggregationKey(PortletExecutionEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, AggregatedGroupMapping aggregatedGroup) {
        String fname;
        AggregatedPortletMapping mappedPortlet;
        TimeDimension timeDimension = intervalInfo.getTimeDimension();
        DateDimension dateDimension = intervalInfo.getDateDimension();
        AggregationInterval aggregationInterval = intervalInfo.getAggregationInterval();
        HashMap<String, AggregatedPortletMapping> mappedPortlets = (HashMap<String, AggregatedPortletMapping>)eventAggregationContext.getAttribute((Object)MAPPED_PORTLETS_CACHE_KEY);
        if (mappedPortlets == null) {
            mappedPortlets = new HashMap<String, AggregatedPortletMapping>();
            eventAggregationContext.setAttribute((Object)MAPPED_PORTLETS_CACHE_KEY, mappedPortlets);
        }
        if ((mappedPortlet = (AggregatedPortletMapping)mappedPortlets.get(fname = e.getFname())) == null) {
            mappedPortlet = this.aggregatedPortletLookupDao.getMappedPortletForFname(fname);
            mappedPortlets.put(fname, mappedPortlet);
        }
        return new PortletExecutionAggregationKeyImpl(dateDimension, timeDimension, aggregationInterval, aggregatedGroup, mappedPortlet, this.executionType);
    }
}

