/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.portletlayout;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Table;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationImpl;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregation;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationDiscriminator;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationKey;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationKeyImpl;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMappingImpl;

@Entity
@javax.persistence.Table(name="UP_PORTLET_LAYOUT_AGGR")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_PORTLET_LAYOUT_LAYOUT_GEN", sequenceName="UP_PORTLET_LAYOUT_AGGR_SEQ", allocationSize=1000)
@TableGenerator(name="UP_PORTLET_LAYOUT_AGGR_GEN", pkColumnValue="UP_PORTLET_LAYOUT_AGGR_PROP", allocationSize=1000)
@Table(appliesTo="UP_PORTLET_LAYOUT_AGGR", indexes={@Index(name="IDX_UP_PORTLET_LAYOUT_AGGR_DTI", columnNames={"DATE_DIMENSION_ID", "TIME_DIMENSION_ID", "AGGR_INTERVAL"}), @Index(name="IDX_UP_PORTLET_LAYOUT_INTRVL", columnNames={"AGGR_INTERVAL"}), @Index(name="IDX_UP_PORTLET_LAYOUT_GRP", columnNames={"AGGR_GROUP_ID"})})
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public final class PortletLayoutAggregationImpl
extends BaseAggregationImpl<PortletLayoutAggregationKey, PortletLayoutAggregationDiscriminator>
implements PortletLayoutAggregation,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_PORTLET_LAYOUT_AGGR_GEN")
    @Column(name="ID")
    private final long id;
    @Column(name="ADD_COUNT", nullable=false)
    private int addCount;
    @Column(name="DEL_COUNT", nullable=false)
    private int delCount;
    @Column(name="MOVE_COUNT", nullable=false)
    private int moveCount;
    @NaturalId
    @ManyToOne(targetEntity=AggregatedPortletMappingImpl.class)
    @JoinColumn(name="AGGR_PORTLET_ID", nullable=false)
    private final AggregatedPortletMapping aggregatedPortlet;
    @Column(name="STATS_COMPLETE", nullable=false)
    private boolean complete = false;
    @Transient
    private PortletLayoutAggregationKey aggregationKey;
    @Transient
    private PortletLayoutAggregationDiscriminator aggregationDiscriminator;

    private PortletLayoutAggregationImpl() {
        this.id = -1L;
        this.aggregatedPortlet = null;
    }

    PortletLayoutAggregationImpl(TimeDimension timeDimension, DateDimension dateDimension, AggregationInterval interval, AggregatedGroupMapping aggregatedGroup, AggregatedPortletMapping aggregatedPortlet) {
        super(timeDimension, dateDimension, interval, aggregatedGroup);
        Validate.notNull((Object)aggregatedPortlet);
        this.id = -1L;
        this.aggregatedPortlet = aggregatedPortlet;
    }

    public long getId() {
        return this.id;
    }

    public int getAddCount() {
        return this.addCount;
    }

    public int getDeleteCount() {
        return this.delCount;
    }

    public int getMoveCount() {
        return this.moveCount;
    }

    public AggregatedPortletMapping getPortletMapping() {
        return this.aggregatedPortlet;
    }

    public PortletLayoutAggregationKey getAggregationKey() {
        PortletLayoutAggregationKey key = this.aggregationKey;
        if (key == null) {
            this.aggregationKey = key = new PortletLayoutAggregationKeyImpl((PortletLayoutAggregation)this);
        }
        return key;
    }

    public PortletLayoutAggregationDiscriminator getAggregationDiscriminator() {
        PortletLayoutAggregationDiscriminator discriminator = this.aggregationDiscriminator;
        if (discriminator == null) {
            this.aggregationDiscriminator = discriminator = new PortletLayoutAggregationDiscriminatorImpl((PortletLayoutAggregation)this);
        }
        return discriminator;
    }

    protected boolean isComplete() {
        return this.complete && (this.addCount > 0 || this.delCount > 0 || this.moveCount > 0);
    }

    protected void completeInterval() {
        this.complete = true;
    }

    void countPortletAdd() {
        ++this.addCount;
    }

    void countPortletDelete() {
        ++this.delCount;
    }

    void countPortletMove() {
        ++this.moveCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aggregatedPortlet == null ? 0 : this.aggregatedPortlet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PortletLayoutAggregation)) {
            return false;
        }
        PortletLayoutAggregation other = (PortletLayoutAggregation)obj;
        return !(this.aggregatedPortlet == null ? other.getPortletMapping() != null : !this.aggregatedPortlet.equals(other.getPortletMapping()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[aggregatedPortlet=" + this.aggregatedPortlet + ", timeDimension=" + this.getTimeDimension() + ", dateDimension=" + this.getDateDimension() + ", interval=" + this.getInterval() + ", aggregatedGroup=" + this.getAggregatedGroup() + "]";
    }
}

