/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.portlets;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletLookupDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMappingImpl;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMappingImpl_;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.jpa.cache.EntityManagerCache;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.utils.cache.CacheKey;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.support.TransactionCallback;

@Repository
public class JpaAggregatedPortletLookupDao
extends BaseAggrEventsJpaDao
implements AggregatedPortletLookupDao {
    private CriteriaQuery<AggregatedPortletMappingImpl> findAllPortletMappingsQuery;
    private EntityManagerCache entityManagerCache;
    private IPortletDefinitionDao portletDefinitionDao;

    @Autowired
    public void setPortletDefinitionDao(IPortletDefinitionDao portletDefinitionDao) {
        this.portletDefinitionDao = portletDefinitionDao;
    }

    @Autowired
    public void setEntityManagerCache(EntityManagerCache entityManagerCache) {
        this.entityManagerCache = entityManagerCache;
    }

    public void afterPropertiesSet() throws Exception {
        this.findAllPortletMappingsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @OpenEntityManager(unitName="AggrEventsDb")
    public AggregatedPortletMapping getMappedPortletForFname(String fname) {
        CacheKey key = CacheKey.build((String)this.getClass().getName(), (Serializable[])new Serializable[]{fname});
        AggregatedPortletMapping portletMapping = (AggregatedPortletMapping)this.entityManagerCache.get("AggrEventsDb", (Serializable)key);
        if (portletMapping != null) {
            return portletMapping;
        }
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(AggregatedPortletMappingImpl.class);
        query.using((Attribute)AggregatedPortletMappingImpl_.fname, (Object)fname);
        portletMapping = (AggregatedPortletMapping)query.load();
        if (portletMapping != null) {
            this.entityManagerCache.put("AggrEventsDb", (Serializable)key, (Object)portletMapping);
            return portletMapping;
        }
        return (AggregatedPortletMapping)this.getTransactionOperations().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Set<AggregatedPortletMapping> getPortletMappings() {
        TypedQuery cachedQuery = this.createCachedQuery(this.findAllPortletMappingsQuery);
        cachedQuery.setFlushMode(FlushModeType.COMMIT);
        return new LinkedHashSet<AggregatedPortletMapping>(cachedQuery.getResultList());
    }

    static /* synthetic */ IPortletDefinitionDao access$000(JpaAggregatedPortletLookupDao x0) {
        return x0.portletDefinitionDao;
    }

    static /* synthetic */ EntityManager access$100(JpaAggregatedPortletLookupDao x0) {
        return x0.getEntityManager();
    }

    static /* synthetic */ Logger access$200(JpaAggregatedPortletLookupDao x0) {
        return x0.logger;
    }

    static /* synthetic */ EntityManagerCache access$300(JpaAggregatedPortletLookupDao x0) {
        return x0.entityManagerCache;
    }
}

