/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.tabrender;

import java.util.HashMap;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.PortalRenderEvent;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.BaseAggregationPrivateDao;
import org.jasig.portal.events.aggr.BasePortalEventAggregator;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.EventAggregationContext;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationImpl;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationKey;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationKeyImpl;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationPrivateDao;
import org.jasig.portal.events.aggr.tabs.AggregatedTabLookupDao;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMapping;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

public class TabRenderAggregator
extends BasePortalEventAggregator<PortalRenderEvent, TabRenderAggregationImpl, TabRenderAggregationKey> {
    private static final String MAPPED_TABS_CACHE_KEY = TabRenderAggregator.class.getName() + "_MAPPED_TABS";
    private TabRenderAggregationPrivateDao tabRenderAggregationDao;
    private AggregatedTabLookupDao aggregatedTabLookupDao;

    @Autowired
    public void setAggregatedTabLookupDao(AggregatedTabLookupDao aggregatedTabLookupDao) {
        this.aggregatedTabLookupDao = aggregatedTabLookupDao;
    }

    @Autowired
    public void setTabRenderAggregationDao(TabRenderAggregationPrivateDao tabRenderAggregationDao) {
        this.tabRenderAggregationDao = tabRenderAggregationDao;
    }

    public boolean supports(Class<? extends PortalEvent> type) {
        return PortalRenderEvent.class.isAssignableFrom(type);
    }

    protected BaseAggregationPrivateDao<TabRenderAggregationImpl, TabRenderAggregationKey> getAggregationDao() {
        return this.tabRenderAggregationDao;
    }

    protected void updateAggregation(PortalRenderEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, TabRenderAggregationImpl aggregation) {
        long executionTime = e.getExecutionTimeNano();
        int duration = intervalInfo.getDurationTo((ReadableInstant)e.getTimestampAsDate());
        aggregation.setDuration(duration);
        aggregation.addValue((double)executionTime);
    }

    protected TabRenderAggregationKey createAggregationKey(PortalRenderEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, AggregatedGroupMapping aggregatedGroup) {
        String targetedLayoutNodeId;
        AggregatedTabMapping mappedTab;
        TimeDimension timeDimension = intervalInfo.getTimeDimension();
        DateDimension dateDimension = intervalInfo.getDateDimension();
        AggregationInterval aggregationInterval = intervalInfo.getAggregationInterval();
        HashMap<String, AggregatedTabMapping> mappedTabs = (HashMap<String, AggregatedTabMapping>)eventAggregationContext.getAttribute((Object)MAPPED_TABS_CACHE_KEY);
        if (mappedTabs == null) {
            mappedTabs = new HashMap<String, AggregatedTabMapping>();
            eventAggregationContext.setAttribute((Object)MAPPED_TABS_CACHE_KEY, mappedTabs);
        }
        if ((mappedTab = (AggregatedTabMapping)mappedTabs.get(targetedLayoutNodeId = e.getTargetedLayoutNodeId())) == null) {
            mappedTab = this.aggregatedTabLookupDao.getMappedTabForLayoutId(targetedLayoutNodeId);
            mappedTabs.put(targetedLayoutNodeId, mappedTab);
        }
        return new TabRenderAggregationKeyImpl(dateDimension, timeDimension, aggregationInterval, aggregatedGroup, mappedTab);
    }
}

