/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.tabs;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMapping;

@Entity
@Table(name="UP_AGGR_TAB_MAPPING")
@SequenceGenerator(name="UP_AGGR_TAB_MAPPING_GEN", sequenceName="UP_AGGR_TAB_MAPPING_SEQ", allocationSize=10)
@TableGenerator(name="UP_AGGR_TAB_MAPPING_GEN", pkColumnValue="UP_AGGR_TAB_MAPPING_PROP", allocationSize=10)
@Immutable
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public final class AggregatedTabMappingImpl
implements AggregatedTabMapping,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_AGGR_TAB_MAPPING_GEN")
    @Column(name="ID")
    private final long id;
    @NaturalId
    @Column(name="FRAGMENT_NAME", length=200, nullable=false)
    private final String fragmentName;
    @NaturalId
    @Column(name="TAB_NAME", length=200, nullable=false)
    private final String tabName;
    @Transient
    private int hashCode = 0;

    private AggregatedTabMappingImpl() {
        this.id = -1L;
        this.fragmentName = null;
        this.tabName = null;
    }

    AggregatedTabMappingImpl(String fragmentName, String tabName) {
        this.id = -1L;
        this.fragmentName = fragmentName;
        this.tabName = tabName;
    }

    public long getId() {
        return this.id;
    }

    public String getFragmentName() {
        return this.fragmentName;
    }

    public String getTabName() {
        return this.tabName;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            int prime = 31;
            h = 1;
            h = 31 * h + (this.fragmentName == null ? 0 : this.fragmentName.hashCode());
            this.hashCode = h = 31 * h + (this.tabName == null ? 0 : this.tabName.hashCode());
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        AggregatedTabMappingImpl other = (AggregatedTabMappingImpl)obj;
        if (this.fragmentName == null ? other.fragmentName != null : !this.fragmentName.equals(other.fragmentName)) {
            return false;
        }
        return !(this.tabName == null ? other.tabName != null : !this.tabName.equals(other.tabName));
    }

    public String toString() {
        return "AggregatedTabMappingImpl [id=" + this.id + ", fragmentName=" + this.fragmentName + ", tabName=" + this.tabName + "]";
    }

    public String getDisplayString() {
        return this.getTabName() + " (" + this.getFragmentName() + ")";
    }
}

