/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jasig.portal.spring.context.FilteringApplicationListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEvent;

public abstract class QueueingEventHandler<E extends ApplicationEvent>
extends FilteringApplicationListener<E>
implements DisposableBean {
    private final Queue<E> eventQueue = new ConcurrentLinkedQueue();
    private final Lock flushLock = new ReentrantLock();
    private int batchSize = 25;
    private List<E> eventBuffer = new ArrayList(this.batchSize);

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        this.eventBuffer = new ArrayList(this.batchSize);
    }

    public final void destroy() throws Exception {
        this.flush();
    }

    protected final void onFilteredApplicationEvent(E event) {
        this.eventQueue.offer(event);
    }

    protected abstract void onApplicationEvents(Iterable<E> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        if (this.eventQueue.isEmpty()) {
            this.logger.trace("No events to flush, returning.");
            return;
        }
        if (!this.flushLock.tryLock()) {
            this.logger.trace("FlushLock already held, returning.");
            return;
        }
        try {
            while (!this.eventQueue.isEmpty()) {
                this.eventBuffer.clear();
                while (!this.eventQueue.isEmpty() && this.eventBuffer.size() < this.batchSize) {
                    ApplicationEvent event = (ApplicationEvent)this.eventQueue.poll();
                    this.eventBuffer.add(event);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Flushing " + this.eventBuffer.size() + " events");
                }
                try {
                    this.onApplicationEvents((Iterable)this.eventBuffer);
                }
                catch (Throwable t) {
                    this.logger.error("An exception was thrown while trying to flush " + this.eventBuffer.size() + " events", t);
                    StringBuilder failedEvents = new StringBuilder();
                    failedEvents.append("The following events that were being flushed, some may have been persisted correctly");
                    for (ApplicationEvent portalEvent : this.eventBuffer) {
                        failedEvents.append("\n\t");
                        try {
                            failedEvents.append(portalEvent.toString());
                        }
                        catch (Exception e) {
                            failedEvents.append("toString failed on a PortalEvent of type '").append(portalEvent.getClass()).append("': ").append(e);
                        }
                    }
                    this.logger.error(failedEvents.toString(), t);
                }
            }
        }
        finally {
            this.eventBuffer.clear();
            this.flushLock.unlock();
        }
    }
}

