/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.spring.context.ApplicationEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserFilteringPortalEventHandler<E extends PortalEvent>
implements ApplicationEventFilter<E> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean supportGuest = true;
    private Set<String> supportedUserNames;
    private Set<String> ignoredUserNames;
    private Set<Pattern> ignoredUserNamePatterns;

    public void setSupportedUserNames(Collection<String> supportedUserNames) {
        this.supportedUserNames = supportedUserNames == null ? null : ImmutableSet.copyOf(supportedUserNames);
    }

    public void setIgnoredUserNames(Collection<String> ignoredUserNames) {
        this.ignoredUserNames = ignoredUserNames == null ? null : ImmutableSet.copyOf(ignoredUserNames);
    }

    public void setIgnoredUserNamePatterns(Collection<Pattern> ignoredUserNamePatterns) {
        this.ignoredUserNamePatterns = ignoredUserNamePatterns == null ? null : ImmutableSet.copyOf(ignoredUserNamePatterns);
    }

    public void setSupportGuest(boolean supportGuest) {
        this.supportGuest = supportGuest;
    }

    public boolean supports(E event) {
        if (!(event instanceof PortalEvent)) {
            return false;
        }
        IPerson person = event.getPerson();
        if (person != null && !this.supportGuest && person.isGuest()) {
            return false;
        }
        String userName = event.getUserName();
        if (this.supportedUserNames != null && this.supportedUserNames.contains(userName)) {
            return true;
        }
        if (this.ignoredUserNames != null && this.ignoredUserNames.contains(userName)) {
            return false;
        }
        if (this.ignoredUserNamePatterns != null) {
            for (Pattern ignoredUserNamePattern : this.ignoredUserNamePatterns) {
                if (!ignoredUserNamePattern.matcher(userName).matches()) continue;
                return false;
            }
        }
        return this.supportedUserNames == null || this.supportedUserNames.isEmpty();
    }
}

