/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.utils.ResourceLoader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class GroupServiceConfiguration {
    private static final Log log = LogFactory.getLog(GroupServiceConfiguration.class);
    private static String SERVICES_XML = "/properties/groups/compositeGroupServices.xml";
    private static GroupServiceConfiguration configuration;
    private GroupConfigurationHandler serviceHandler;
    private List serviceDescriptors = new ArrayList();
    private Map attributes = new HashMap();

    public GroupServiceConfiguration() {
        this.serviceHandler = new GroupConfigurationHandler(this);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public static synchronized GroupServiceConfiguration getConfiguration() throws Exception {
        if (configuration == null) {
            configuration = new GroupServiceConfiguration();
            configuration.parseXml();
        }
        return configuration;
    }

    public String getDefaultService() {
        return (String)this.getAttributes().get("defaultService");
    }

    public String getNodeSeparator() {
        Object nodeSeparator = this.getAttributes().get("nodeSeparator");
        return nodeSeparator == null ? "." : (String)nodeSeparator;
    }

    public List getServiceDescriptors() {
        return this.serviceDescriptors;
    }

    protected void parseAttributes(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getQName(i);
            String value = atts.getValue(i);
            this.getAttributes().put(name, value);
        }
    }

    protected void parseXml() throws Exception {
        InputSource xmlSource = new InputSource(ResourceLoader.getResourceAsStream(GroupServiceConfiguration.class, (String)SERVICES_XML));
        if (xmlSource != null) {
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setContentHandler((ContentHandler)this.serviceHandler);
            reader.parse(xmlSource);
        }
    }

    public static synchronized void reset() {
        configuration = null;
    }

    static /* synthetic */ Log access$000() {
        return log;
    }

    static /* synthetic */ List access$100(GroupServiceConfiguration x0) {
        return x0.serviceDescriptors;
    }
}

