/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.grouper;

import edu.internet2.middleware.grouperClient.api.GcAddMember;
import edu.internet2.middleware.grouperClient.api.GcFindGroups;
import edu.internet2.middleware.grouperClient.api.GcGetGroups;
import edu.internet2.middleware.grouperClient.api.GcGetMembers;
import edu.internet2.middleware.grouperClient.api.GcGetSubjects;
import edu.internet2.middleware.grouperClient.api.GcGroupDelete;
import edu.internet2.middleware.grouperClient.api.GcGroupSave;
import edu.internet2.middleware.grouperClient.api.GcHasMember;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.StemScope;
import edu.internet2.middleware.grouperClient.ws.beans.WsFindGroupsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetSubjectsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupToSave;
import edu.internet2.middleware.grouperClient.ws.beans.WsHasMemberResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsHasMemberResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsQueryFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubject;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.EntityImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntitySearcher;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.grouper.GrouperEntityGroupStoreFactory;
import org.jasig.portal.security.IPerson;

/*
 * Exception performing whole class analysis ignored.
 */
public class GrouperEntityGroupStore
implements IEntityGroupStore,
IEntityStore,
IEntitySearcher {
    private static final String STEM_PREFIX = "uportal.stem";
    protected static final Log LOGGER = LogFactory.getLog(GrouperEntityGroupStoreFactory.class);

    GrouperEntityGroupStore() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + " created"));
        }
    }

    public boolean contains(IEntityGroup group, IGroupMember member) throws GroupsException {
        String groupContainerName = group.getLocalKey();
        String groupMemberName = member.getKey();
        if (!GrouperEntityGroupStore.validKey((String)groupContainerName) || !GrouperEntityGroupStore.validKey((String)groupMemberName)) {
            return false;
        }
        GcHasMember gcHasMember = new GcHasMember();
        gcHasMember.assignGroupName(groupContainerName);
        gcHasMember.addSubjectLookup(new WsSubjectLookup(null, "g:gsa", groupMemberName));
        WsHasMemberResults wsHasMemberResults = gcHasMember.execute();
        if (GrouperClientUtils.length((Object)wsHasMemberResults.getResults()) == 1) {
            WsHasMemberResult wsHasMemberResult = wsHasMemberResults.getResults()[0];
            return StringUtils.equals((String)"IS_MEMBER", (String)wsHasMemberResult.getResultMetadata().getResultCode());
        }
        return false;
    }

    public IEntityGroup find(String key) throws GroupsException {
        try {
            WsGroup wsGroup;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Searching Grouper for a direct match for key: " + key));
            }
            if ((wsGroup = this.findGroupFromKey(key)) == null) {
                return null;
            }
            IEntityGroup group = this.createUportalGroupFromGrouperGroup(wsGroup);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Retrieved group from the Grouper server matching key " + key + ": " + group.toString()));
            }
            return group;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception while attempting to retrieve group with key " + key + " from Grouper web services: " + e.getMessage()));
            return null;
        }
    }

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        LinkedList<IEntityGroup> parents = new LinkedList<IEntityGroup>();
        GcGetGroups getGroups = new GcGetGroups();
        String uportalStem = GrouperEntityGroupStore.getStemPrefix();
        if (!StringUtils.isBlank((String)uportalStem)) {
            getGroups.assignStemScope(StemScope.ALL_IN_SUBTREE);
            getGroups.assignWsStemLookup(new WsStemLookup(uportalStem, null));
        }
        String key = null;
        String subjectSourceId = null;
        if (gm.isGroup()) {
            key = ((IEntityGroup)gm).getLocalKey();
            if (!GrouperEntityGroupStore.validKey((String)key)) {
                return parents.iterator();
            }
            subjectSourceId = "g:gsa";
        } else {
            key = gm.getKey();
        }
        getGroups.addSubjectLookup(new WsSubjectLookup(null, subjectSourceId, key));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Searching Grouper for parent groups of the entity with key: " + key));
        }
        try {
            WsGetGroupsResults results = getGroups.execute();
            if (results == null || results.getResults() == null || results.getResults().length != 1) {
                LOGGER.debug((Object)("Grouper service returned no matches for key " + key));
                return parents.iterator();
            }
            WsGetGroupsResult wsg = results.getResults()[0];
            if (wsg.getWsGroups() != null) {
                for (WsGroup g : wsg.getWsGroups()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.trace((Object)("Retrieved group: " + g.getName()));
                    }
                    IEntityGroup parent = this.createUportalGroupFromGrouperGroup(g);
                    parents.add(parent);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Retrieved " + parents.size() + " parent groups of entity with key " + key));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception while attempting to retrieve parents for entity with key " + key + " from Grouper web services: " + e.getMessage()));
            return Collections.emptyList().iterator();
        }
        return parents.iterator();
    }

    public Iterator findEntitiesForGroup(IEntityGroup group) throws GroupsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Searching Grouper for members of the group with key: " + group.getKey()));
        }
        try {
            GcGetMembers getGroupsMembers = new GcGetMembers();
            getGroupsMembers.addGroupName(group.getLocalKey());
            getGroupsMembers.assignIncludeSubjectDetail(Boolean.valueOf(true));
            WsGetMembersResults results = getGroupsMembers.execute();
            if (results == null || results.getResults() == null || results.getResults().length == 0 || results.getResults()[0].getWsSubjects() == null) {
                LOGGER.debug((Object)("No members found for Grouper group with key " + group.getLocalKey()));
                return Collections.emptyList().iterator();
            }
            WsSubject[] gInfos = results.getResults()[0].getWsSubjects();
            ArrayList<EntityImpl> members = new ArrayList<EntityImpl>(gInfos.length);
            for (WsSubject gInfo : gInfos) {
                if (StringUtils.equals((String)gInfo.getSourceId(), (String)"g:gsa")) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("creating leaf member:" + gInfo.getId() + " and name: " + gInfo.getName() + " from group: " + group.getLocalKey()));
                }
                EntityImpl member = new EntityImpl(gInfo.getName(), IPerson.class);
                members.add(member);
            }
            return members.iterator();
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception while attempting to retrieve member entities of group with key " + group.getKey() + " from Grouper web services: " + e.getMessage()));
            return Collections.emptyList().iterator();
        }
    }

    public String[] findMemberGroupKeys(IEntityGroup group) throws GroupsException {
        Iterator it = this.findMemberGroups(group);
        ArrayList<String> keys = new ArrayList<String>();
        while (it.hasNext()) {
            IEntityGroup eg = (IEntityGroup)it.next();
            keys.add(eg.getKey());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public Iterator findMemberGroups(IEntityGroup group) throws GroupsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Searching for group-type members of group with key: " + group.getKey()));
        }
        try {
            WsSubject[] subjects;
            if (!GrouperEntityGroupStore.validKey((String)group.getLocalKey())) {
                return Collections.emptyList().iterator();
            }
            GcGetMembers gcGetMembers = new GcGetMembers();
            gcGetMembers.addGroupName(group.getLocalKey());
            gcGetMembers.assignIncludeSubjectDetail(Boolean.valueOf(true));
            gcGetMembers.addSourceId("g:gsa");
            WsGetMembersResults results = gcGetMembers.execute();
            if (results == null || results.getResults() == null || results.getResults().length == 0 || results.getResults()[0].getWsSubjects() == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("No group-type members found for group with key " + group.getKey()));
                }
                return Collections.emptyList().iterator();
            }
            ArrayList<IEntityGroup> members = new ArrayList<IEntityGroup>();
            for (WsSubject wsSubject : subjects = results.getResults()[0].getWsSubjects()) {
                WsGroup wsGroup;
                if (!GrouperEntityGroupStore.validKey((String)wsSubject.getName()) || (wsGroup = this.findGroupFromKey(wsSubject.getName())) == null) continue;
                IEntityGroup member = this.createUportalGroupFromGrouperGroup(wsGroup);
                members.add(member);
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace((Object)("found IEntityGroup member: " + member));
            }
            return members.iterator();
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception while attempting to retrieve member groups of group with key " + group.getKey() + " from Grouper web services: " + e.getMessage()));
            return Collections.emptyList().iterator();
        }
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) {
        if (leaftype != IPerson.class) {
            return new EntityIdentifier[0];
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Searching Grouper for groups matching query: " + query));
        }
        ArrayList<EntityIdentifier> groups = new ArrayList<EntityIdentifier>();
        try {
            GcFindGroups groupSearch = new GcFindGroups();
            WsQueryFilter filter = new WsQueryFilter();
            if (method == 1) {
                filter.setQueryFilterType("FIND_BY_GROUP_NAME_EXACT");
            } else {
                filter.setQueryFilterType("FIND_BY_GROUP_NAME_APPROXIMATE");
            }
            filter.setGroupName(query);
            groupSearch.assignQueryFilter(filter);
            WsFindGroupsResults results = groupSearch.execute();
            if (results != null && results.getGroupResults() != null) {
                for (WsGroup g : results.getGroupResults()) {
                    if (!GrouperEntityGroupStore.validKey((String)g.getName())) continue;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Retrieved group: " + g.getName()));
                    }
                    groups.add(new EntityIdentifier(g.getName(), IEntityGroup.class));
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Returning " + groups.size() + " results for query " + query));
            }
            return groups.toArray(new EntityIdentifier[groups.size()]);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception while attempting to retrieve search results for query " + query + " and entity type " + leaftype.getCanonicalName() + " : " + e.getMessage()));
            return new EntityIdentifier[0];
        }
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        if (type != IPerson.class) {
            return new EntityIdentifier[0];
        }
        ArrayList<EntityIdentifier> entityIdentifiers = new ArrayList<EntityIdentifier>();
        try {
            GcGetSubjects subjects = new GcGetSubjects();
            subjects.assignIncludeSubjectDetail(Boolean.valueOf(true));
            WsGetSubjectsResults results = subjects.assignSearchString(query).execute();
            if (results != null && results.getWsSubjects() != null) {
                for (WsSubject wsSubject : results.getWsSubjects()) {
                    entityIdentifiers.add(new EntityIdentifier(wsSubject.getName(), EntityTypes.LEAF_ENTITY_TYPE));
                }
            }
            return entityIdentifiers.toArray(new EntityIdentifier[entityIdentifiers.size()]);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception while attempting to retrieve search results for query " + query + " and entity type " + type.getCanonicalName() + " : " + e.getMessage()));
            return new EntityIdentifier[0];
        }
    }

    public IEntity newInstance(String key) throws GroupsException {
        return new EntityImpl(key, null);
    }

    public IEntity newInstance(String key, Class type) throws GroupsException {
        if (EntityTypes.getEntityTypeID((Class)type) == null) {
            throw new GroupsException("Invalid group type: " + type);
        }
        return new EntityImpl(key, type);
    }

    protected boolean groupMatches(WsGroup group, String query, int method) {
        if (group == null || group.getName() == null) {
            return false;
        }
        switch (method) {
            case 1: {
                return group.getName().equals(query);
            }
            case 2: {
                return group.getName().startsWith(query);
            }
            case 3: {
                return group.getName().endsWith(query);
            }
            case 4: {
                return group.getName().contains(query);
            }
        }
        return false;
    }

    protected IEntityGroup createUportalGroupFromGrouperGroup(WsGroup wsGroup) {
        EntityGroupImpl iEntityGroup = new EntityGroupImpl(wsGroup.getName(), IPerson.class);
        iEntityGroup.setName(wsGroup.getDisplayName());
        iEntityGroup.setDescription(wsGroup.getDescription());
        return iEntityGroup;
    }

    protected WsGroup findGroupFromKey(String key) {
        WsGroup wsGroup = null;
        if (key != null) {
            GcFindGroups gcFindGroups = new GcFindGroups();
            gcFindGroups.addGroupName(key);
            WsFindGroupsResults results = gcFindGroups.execute();
            if (results != null && results.getGroupResults() != null && results.getGroupResults().length > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("found group from key " + key + ": " + results.getGroupResults()[0]));
                }
                wsGroup = results.getGroupResults()[0];
            }
        }
        return wsGroup;
    }

    protected static String getStemPrefix() {
        String uportalStem = GrouperClientUtils.propertiesValue((String)"uportal.stem", (boolean)false);
        if (!StringUtils.isBlank((String)uportalStem) && uportalStem.endsWith(":")) {
            uportalStem = uportalStem.substring(0, uportalStem.length() - 1);
        }
        return uportalStem;
    }

    protected static boolean validKey(String key) {
        String uportalStem = GrouperEntityGroupStore.getStemPrefix();
        return StringUtils.isBlank((String)uportalStem) || !StringUtils.isBlank((String)key) && key.startsWith(uportalStem.concat(":"));
    }

    public void update(IEntityGroup group) throws GroupsException {
        String groupName = group.getLocalKey();
        String description = group.getDescription();
        String displayExtension = group.getName();
        WsGroupToSave wsGroupToSave = new WsGroupToSave();
        wsGroupToSave.setCreateParentStemsIfNotExist("T");
        wsGroupToSave.setWsGroupLookup(new WsGroupLookup(groupName, null));
        WsGroup wsGroup = new WsGroup();
        wsGroup.setName(groupName);
        wsGroup.setDisplayExtension(displayExtension);
        wsGroup.setDescription(description);
        wsGroupToSave.setWsGroup(wsGroup);
        new GcGroupSave().addGroupToSave(wsGroupToSave).execute();
        this.updateMembers(group);
    }

    public void updateMembers(IEntityGroup group) throws GroupsException {
        String groupName = group.getLocalKey();
        GcAddMember gcAddMember = new GcAddMember().assignGroupName(groupName);
        Iterator membersIterator = group.getMembers();
        while (membersIterator != null && membersIterator.hasNext()) {
            IGroupMember iGroupMember = (IGroupMember)membersIterator.next();
            EntityIdentifier entityIdentifier = iGroupMember.getEntityIdentifier();
            String identifier = entityIdentifier.getKey();
            gcAddMember.addSubjectIdentifier(identifier);
        }
        gcAddMember.execute();
    }

    public void delete(IEntityGroup group) throws GroupsException {
        String groupName = group.getLocalKey();
        new GcGroupDelete().addGroupLookup(new WsGroupLookup(groupName, null)).execute();
    }

    public ILockableEntityGroup findLockable(String key) throws GroupsException {
        throw new UnsupportedOperationException("Group locking is not supported by the Grouper groups service");
    }

    public IEntityGroup newInstance(Class entityType) throws GroupsException {
        throw new UnsupportedOperationException("Group updates are not supported by the Grouper groups service");
    }
}

