/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.pags;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jasig.portal.groups.pags.IPersonAttributesConfiguration;
import org.jasig.portal.groups.pags.IPersonTester;
import org.jasig.portal.groups.pags.PersonAttributesGroupStore;
import org.jasig.portal.utils.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLPersonAttributesConfiguration
implements IPersonAttributesConfiguration {
    public Map getConfig() {
        Document config = null;
        try {
            config = ResourceLoader.getResourceAsDocument(this.getClass(), (String)"/properties/groups/PAGSGroupStoreConfig.xml", (boolean)true);
        }
        catch (Exception rme) {
            throw new RuntimeException("PersonAttributesGroupStore: Unable to read configuration document");
        }
        HashMap<String, PersonAttributesGroupStore.GroupDefinition> groupDefinitions = new HashMap<String, PersonAttributesGroupStore.GroupDefinition>();
        config.normalize();
        Element groupStoreElement = config.getDocumentElement();
        NodeList groupElements = groupStoreElement.getChildNodes();
        for (int i = 0; i < groupElements.getLength(); ++i) {
            if (!(groupElements.item(i) instanceof Element)) continue;
            PersonAttributesGroupStore.GroupDefinition groupDef = this.initGroupDef((Element)groupElements.item(i));
            groupDefinitions.put(groupDef.getKey(), groupDef);
        }
        return groupDefinitions;
    }

    private PersonAttributesGroupStore.GroupDefinition initGroupDef(Element groupElement) {
        PersonAttributesGroupStore.GroupDefinition groupDef = new PersonAttributesGroupStore.GroupDefinition();
        NodeList children = groupElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element element = (Element)children.item(i);
            String tagName = element.getTagName();
            element.normalize();
            String text = null;
            if (element.getFirstChild() instanceof Text) {
                text = ((Text)element.getFirstChild()).getData().trim();
            }
            if (tagName.equals("group-key")) {
                groupDef.setKey(text);
                continue;
            }
            if (tagName.equals("group-name")) {
                groupDef.setName(text);
                continue;
            }
            if (tagName.equals("group-description")) {
                groupDef.setDescription(text);
                continue;
            }
            if (tagName.equals("selection-test")) {
                NodeList testGroups = element.getChildNodes();
                for (int j = 0; j < testGroups.getLength(); ++j) {
                    Node testGroup = testGroups.item(j);
                    if (!(testGroup instanceof Element) || !((Element)testGroup).getTagName().equals("test-group")) continue;
                    PersonAttributesGroupStore.TestGroup tg = new PersonAttributesGroupStore.TestGroup();
                    NodeList tests = testGroup.getChildNodes();
                    for (int k = 0; k < tests.getLength(); ++k) {
                        Node test = tests.item(k);
                        if (!(test instanceof Element) || !((Element)test).getTagName().equals("test")) continue;
                        String attribute = null;
                        String tester = null;
                        String value = null;
                        NodeList parameters = test.getChildNodes();
                        for (int l = 0; l < parameters.getLength(); ++l) {
                            Node parameter = parameters.item(l);
                            text = null;
                            String nodeName = parameter.getNodeName();
                            if (parameter.getFirstChild() != null && parameter.getFirstChild() instanceof Text) {
                                text = ((Text)parameter.getFirstChild()).getData().trim();
                            }
                            if (nodeName.equals("attribute-name")) {
                                attribute = text;
                                continue;
                            }
                            if (nodeName.equals("tester-class")) {
                                tester = text;
                                continue;
                            }
                            if (!nodeName.equals("test-value")) continue;
                            value = text;
                        }
                        IPersonTester testerInst = this.initializeTester(tester, attribute, value);
                        tg.addTest(testerInst);
                    }
                    groupDef.addTestGroup(tg);
                }
                continue;
            }
            if (!tagName.equals("members")) continue;
            this.addMemberKeys(groupDef, element);
        }
        return groupDef;
    }

    private void addMemberKeys(PersonAttributesGroupStore.GroupDefinition groupDef, Element members) {
        NodeList children = members.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("member-key")) continue;
            Element member = (Element)node;
            member.normalize();
            if (!(member.getFirstChild() instanceof Text)) continue;
            groupDef.addMember(((Text)member.getFirstChild()).getData().trim());
        }
    }

    private IPersonTester initializeTester(String tester, String attribute, String value) {
        try {
            Class<?> testerClass = Class.forName(tester);
            Constructor<?> c = testerClass.getConstructor(String.class, String.class);
            Object o = c.newInstance(attribute, value);
            return (IPersonTester)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

