/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.smartldap;

import java.util.Collections;
import java.util.List;
import org.jasig.portal.groups.IEntityGroup;

public final class LdapRecord {
    private final IEntityGroup group;
    private final List<String> keysOfChildren;

    public LdapRecord(IEntityGroup group, List<String> keysOfChildren) {
        if (group == null) {
            String msg = "Argument 'group' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (keysOfChildren == null) {
            String msg = "Argument 'keysOfChildren' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        this.group = group;
        this.keysOfChildren = Collections.unmodifiableList(keysOfChildren);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof LdapRecord)) {
            return false;
        }
        LdapRecord lr = (LdapRecord)o;
        return lr.getGroup().getKey().equals(this.getGroup().getKey());
    }

    public IEntityGroup getGroup() {
        return this.group;
    }

    public List<String> getKeysOfChildren() {
        return this.keysOfChildren;
    }

    public int hashCode() {
        return this.getGroup().getKey().hashCode();
    }
}

