/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

@Service(value="portletEntityPreferenceHandler")
public class PortletEntityPreferenceHandler {
    private IPortletDefinitionDao portletDefinitionDao;
    private IPortletEntityDao portletEntityDao;

    @Autowired
    public void setPortletDefinitionDao(IPortletDefinitionDao portletDefinitionDao) {
        this.portletDefinitionDao = portletDefinitionDao;
    }

    @Autowired
    public void setPortletEntityDao(@Qualifier(value="transient") IPortletEntityDao portletEntityDao) {
        this.portletEntityDao = portletEntityDao;
    }

    public Set<IPortletEntity> getEntityPreferences(Integer userId) {
        Set portletEntities = this.portletEntityDao.getPortletEntitiesForUser(userId.intValue());
        Iterator entityItr = portletEntities.iterator();
        while (entityItr.hasNext()) {
            IPortletEntity portletEntity = (IPortletEntity)entityItr.next();
            List preferencesList = portletEntity.getPortletPreferences();
            if (preferencesList.size() > 0) continue;
            entityItr.remove();
        }
        return portletEntities;
    }

    public void setEntityPreference(String fName, String channelSubscribeId, Integer userId, LinkedHashMap<String, List<String>> preferencesMap) {
        IPortletEntity portletEntity = this.getPortletEntity(fName, channelSubscribeId, userId.intValue());
        ArrayList<PortletPreferenceImpl> portletPreferencesList = new ArrayList<PortletPreferenceImpl>(preferencesMap.size());
        for (Map.Entry<String, List<String>> prefEntry : preferencesMap.entrySet()) {
            String prefName = prefEntry.getKey();
            List<String> prefValues = prefEntry.getValue();
            PortletPreferenceImpl portletPreference = new PortletPreferenceImpl(prefName, false, prefValues.toArray(new String[prefValues.size()]));
            portletPreferencesList.add(portletPreference);
        }
        portletEntity.setPortletPreferences(portletPreferencesList);
        this.portletEntityDao.updatePortletEntity(portletEntity);
    }

    protected IPortletEntity getPortletEntity(String fName, String layoutNodeId, int userId) {
        IPortletDefinition portletDefinition;
        try {
            portletDefinition = this.portletDefinitionDao.getPortletDefinitionByFname(fName);
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("Failed to retrieve ChannelDefinition for fName='" + fName + "'", (Throwable)e);
        }
        if (portletDefinition == null) {
            throw new EmptyResultDataAccessException("No ChannelDefinition exists for fName='" + fName + "'", 1);
        }
        IPortletEntity portletEntity = this.portletEntityDao.getPortletEntity(layoutNodeId, userId);
        if (portletEntity != null) {
            return portletEntity;
        }
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        return this.portletEntityDao.createPortletEntity(portletDefinitionId, layoutNodeId, userId);
    }
}

