/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tools.ant.DirectoryScanner;
import org.jasig.portal.io.xml.IDataDeleter;
import org.jasig.portal.io.xml.IDataExporter;
import org.jasig.portal.io.xml.IDataImporter;
import org.jasig.portal.io.xml.IDataUpgrader;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataHandlerService;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.JaxbPortalDataHandlerService;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.PortalDataKeyFileProcessor;
import org.jasig.portal.utils.AntPatternFileFilter;
import org.jasig.portal.utils.ConcurrentDirectoryScanner;
import org.jasig.portal.utils.PeriodicFlushingBufferedWriter;
import org.jasig.portal.utils.ResourceUtils;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.jasig.portal.xml.StaxUtils;
import org.jasig.portal.xml.XmlUtilities;
import org.jasig.portal.xml.XmlUtilitiesImpl;
import org.jasig.portal.xml.stream.BufferedXMLEventReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;

@Service(value="portalDataHandlerService")
public class JaxbPortalDataHandlerService
implements IPortalDataHandlerService,
ResourceLoaderAware {
    private static final ThreadLocal<String> IMPORT_BASE_DIR = new ThreadLocal();
    private static final String REPORT_FORMAT = "%s,%s,%.2fms\n";
    private static final MediaType MT_JAVA_ARCHIVE = MediaType.application((String)"java-archive");
    private static final MediaType MT_CPIO = MediaType.application((String)"x-cpio");
    private static final MediaType MT_AR = MediaType.application((String)"x-archive");
    private static final MediaType MT_TAR = MediaType.application((String)"x-tar");
    private static final MediaType MT_BZIP2 = MediaType.application((String)"x-bzip2");
    private static final MediaType MT_GZIP = MediaType.application((String)"x-gzip");
    private static final MediaType MT_PACK200 = MediaType.application((String)"x-java-pack200");
    private static final MediaType MT_XZ = MediaType.application((String)"x-xz");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<PortalDataKey> dataKeyImportOrder = Collections.emptyList();
    private Map<PortalDataKey, IPortalDataType> dataKeyTypes = Collections.emptyMap();
    private Set<String> dataFileIncludes = Collections.emptySet();
    private Set<String> dataFileExcludes = ImmutableSet.copyOf((Object[])DirectoryScanner.getDefaultExcludes());
    private Map<PortalDataKey, IDataUpgrader> portalDataUpgraders = Collections.emptyMap();
    private Map<PortalDataKey, IDataImporter<Object>> portalDataImporters = Collections.emptyMap();
    private Set<IPortalDataType> exportAllPortalDataTypes = null;
    private Set<IPortalDataType> exportPortalDataTypes = Collections.emptySet();
    private Map<String, IDataExporter<Object>> portalDataExporters = Collections.emptyMap();
    private Set<IPortalDataType> deletePortalDataTypes = Collections.emptySet();
    private Map<String, IDataDeleter<Object>> portalDataDeleters = Collections.emptyMap();
    private org.jasig.portal.utils.DirectoryScanner directoryScanner;
    private ExecutorService importExportThreadPool;
    private XmlUtilities xmlUtilities;
    private ResourceLoader resourceLoader;
    private long maxWait = -1L;
    private TimeUnit maxWaitTimeUnit = TimeUnit.MILLISECONDS;

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    @Autowired
    public void setImportExportThreadPool(@Qualifier(value="importExportThreadPool") ExecutorService importExportThreadPool) {
        this.importExportThreadPool = importExportThreadPool;
        this.directoryScanner = new ConcurrentDirectoryScanner(this.importExportThreadPool);
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public void setMaxWaitTimeUnit(TimeUnit maxWaitTimeUnit) {
        this.maxWaitTimeUnit = maxWaitTimeUnit;
    }

    @Resource(name="dataTypeImportOrder")
    public void setDataTypeImportOrder(List<IPortalDataType> dataTypeImportOrder) {
        ArrayList<PortalDataKey> dataKeyImportOrder = new ArrayList<PortalDataKey>(dataTypeImportOrder.size() * 2);
        LinkedHashMap<PortalDataKey, IPortalDataType> dataKeyTypes = new LinkedHashMap<PortalDataKey, IPortalDataType>(dataTypeImportOrder.size() * 2);
        for (IPortalDataType portalDataType : dataTypeImportOrder) {
            List supportedDataKeys = portalDataType.getDataKeyImportOrder();
            for (PortalDataKey portalDataKey : supportedDataKeys) {
                dataKeyImportOrder.add(portalDataKey);
                dataKeyTypes.put(portalDataKey, portalDataType);
            }
        }
        dataKeyImportOrder.trimToSize();
        this.dataKeyImportOrder = Collections.unmodifiableList(dataKeyImportOrder);
        this.dataKeyTypes = Collections.unmodifiableMap(dataKeyTypes);
    }

    @Resource(name="dataFileIncludes")
    public void setDataFileIncludes(Set<String> dataFileIncludes) {
        this.dataFileIncludes = dataFileIncludes;
    }

    public void setDataFileExcludes(Set<String> dataFileExcludes) {
        this.dataFileExcludes = dataFileExcludes;
    }

    @Autowired(required=false)
    public void setDataImporters(Collection<IDataImporter<? extends Object>> dataImporters) {
        LinkedHashMap<PortalDataKey, IDataImporter<? extends Object>> dataImportersMap = new LinkedHashMap<PortalDataKey, IDataImporter<? extends Object>>();
        for (IDataImporter<? extends Object> dataImporter : dataImporters) {
            Set importDataKeys = dataImporter.getImportDataKeys();
            for (PortalDataKey importDataKey : importDataKeys) {
                this.logger.debug("Registering IDataImporter for '{}' - {}", new Object[]{importDataKey, dataImporter});
                IDataImporter<? extends Object> existing = dataImportersMap.put(importDataKey, dataImporter);
                if (existing == null) continue;
                this.logger.warn("Duplicate IDataImporter PortalDataKey for {} Replacing {} with {}", new Object[]{importDataKey, existing, dataImporter});
            }
        }
        this.portalDataImporters = Collections.unmodifiableMap(dataImportersMap);
    }

    @Autowired(required=false)
    public void setDataExporters(Collection<IDataExporter<? extends Object>> dataExporters) {
        LinkedHashMap<String, IDataExporter<? extends Object>> dataExportersMap = new LinkedHashMap<String, IDataExporter<? extends Object>>();
        LinkedHashSet<IPortalDataType> portalDataTypes = new LinkedHashSet<IPortalDataType>();
        for (IDataExporter<? extends Object> dataImporter : dataExporters) {
            IPortalDataType portalDataType = dataImporter.getPortalDataType();
            String typeId = portalDataType.getTypeId();
            this.logger.debug("Registering IDataExporter for '{}' - {}", new Object[]{typeId, dataImporter});
            IDataExporter<? extends Object> existing = dataExportersMap.put(typeId, dataImporter);
            if (existing != null) {
                this.logger.warn("Duplicate IDataExporter typeId for {} Replacing {} with {}", new Object[]{typeId, existing, dataImporter});
            }
            portalDataTypes.add(portalDataType);
        }
        this.portalDataExporters = Collections.unmodifiableMap(dataExportersMap);
        this.exportPortalDataTypes = Collections.unmodifiableSet(portalDataTypes);
    }

    @Resource(name="exportAllPortalDataTypes")
    public void setExportAllPortalDataTypes(Set<IPortalDataType> exportAllPortalDataTypes) {
        this.exportAllPortalDataTypes = ImmutableSet.copyOf(exportAllPortalDataTypes);
    }

    @Autowired(required=false)
    public void setDataDeleters(Collection<IDataDeleter<? extends Object>> dataDeleters) {
        LinkedHashMap<String, IDataDeleter<? extends Object>> dataDeletersMap = new LinkedHashMap<String, IDataDeleter<? extends Object>>();
        LinkedHashSet<IPortalDataType> portalDataTypes = new LinkedHashSet<IPortalDataType>();
        for (IDataDeleter<? extends Object> dataImporter : dataDeleters) {
            IPortalDataType portalDataType = dataImporter.getPortalDataType();
            String typeId = portalDataType.getTypeId();
            this.logger.debug("Registering IDataDeleter for '{}' - {}", new Object[]{typeId, dataImporter});
            IDataDeleter<? extends Object> existing = dataDeletersMap.put(typeId, dataImporter);
            if (existing != null) {
                this.logger.warn("Duplicate IDataDeleter typeId for {} Replacing {} with {}", new Object[]{typeId, existing, dataImporter});
            }
            portalDataTypes.add(portalDataType);
        }
        this.portalDataDeleters = Collections.unmodifiableMap(dataDeletersMap);
        this.deletePortalDataTypes = Collections.unmodifiableSet(portalDataTypes);
    }

    @Autowired(required=false)
    public void setDataUpgraders(Collection<IDataUpgrader> dataUpgraders) {
        LinkedHashMap<PortalDataKey, IDataUpgrader> dataUpgraderMap = new LinkedHashMap<PortalDataKey, IDataUpgrader>();
        for (IDataUpgrader dataUpgrader : dataUpgraders) {
            Set upgradeDataKeys = dataUpgrader.getSourceDataTypes();
            for (PortalDataKey upgradeDataKey : upgradeDataKeys) {
                this.logger.debug("Registering IDataUpgrader for '{}' - {}", (Object)upgradeDataKey, (Object)dataUpgrader);
                IDataUpgrader existing = dataUpgraderMap.put(upgradeDataKey, dataUpgrader);
                if (existing == null) continue;
                this.logger.warn("Duplicate IDataUpgrader PortalDataKey for {} Replacing {} with {}", new Object[]{upgradeDataKey, existing, dataUpgrader});
            }
        }
        this.portalDataUpgraders = Collections.unmodifiableMap(dataUpgraderMap);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void importDataArchive(org.springframework.core.io.Resource archive, IPortalDataHandlerService.BatchImportOptions options) {
        try {
            this.importDataArchive(archive, archive.getInputStream(), options);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load InputStream for resource: " + archive, e);
        }
    }

    protected void importDataArchive(org.springframework.core.io.Resource archive, InputStream resourceStream, IPortalDataHandlerService.BatchImportOptions options) {
        BufferedInputStream bufferedResourceStream;
        block13: {
            bufferedResourceStream = null;
            try {
                bufferedResourceStream = resourceStream instanceof BufferedInputStream ? (BufferedInputStream)resourceStream : new BufferedInputStream(resourceStream);
                bufferedResourceStream.mark(0x6400000);
                MediaType type = this.getMediaType(bufferedResourceStream, archive.getFilename());
                if (MT_JAVA_ARCHIVE.equals((Object)type)) {
                    JarArchiveInputStream archiveStream = new JarArchiveInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (ArchiveInputStream)archiveStream, options);
                    break block13;
                }
                if (MediaType.APPLICATION_ZIP.equals((Object)type)) {
                    ZipArchiveInputStream archiveStream = new ZipArchiveInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (ArchiveInputStream)archiveStream, options);
                    break block13;
                }
                if (MT_CPIO.equals((Object)type)) {
                    CpioArchiveInputStream archiveStream = new CpioArchiveInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (ArchiveInputStream)archiveStream, options);
                    break block13;
                }
                if (MT_AR.equals((Object)type)) {
                    ArArchiveInputStream archiveStream = new ArArchiveInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (ArchiveInputStream)archiveStream, options);
                    break block13;
                }
                if (MT_TAR.equals((Object)type)) {
                    TarArchiveInputStream archiveStream = new TarArchiveInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (ArchiveInputStream)archiveStream, options);
                    break block13;
                }
                if (MT_BZIP2.equals((Object)type)) {
                    BZip2CompressorInputStream compressedStream = new BZip2CompressorInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (InputStream)compressedStream, options);
                    break block13;
                }
                if (MT_GZIP.equals((Object)type)) {
                    GzipCompressorInputStream compressedStream = new GzipCompressorInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (InputStream)compressedStream, options);
                    break block13;
                }
                if (MT_PACK200.equals((Object)type)) {
                    Pack200CompressorInputStream compressedStream = new Pack200CompressorInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (InputStream)compressedStream, options);
                    break block13;
                }
                if (MT_XZ.equals((Object)type)) {
                    XZCompressorInputStream compressedStream = new XZCompressorInputStream((InputStream)bufferedResourceStream);
                    this.importDataArchive(archive, (InputStream)compressedStream, options);
                    break block13;
                }
                throw new RuntimeException("Unrecognized archive media type: " + type);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Could not load InputStream for resource: " + archive, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedResourceStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)bufferedResourceStream);
    }

    protected void importDataArchive(org.springframework.core.io.Resource resource, ArchiveInputStream resourceStream, IPortalDataHandlerService.BatchImportOptions options) {
        File tempDir = Files.createTempDir();
        try {
            ArchiveEntry archiveEntry;
            while ((archiveEntry = resourceStream.getNextEntry()) != null) {
                File entryFile = new File(tempDir, archiveEntry.getName());
                if (archiveEntry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                entryFile.getParentFile().mkdirs();
                Files.copy((InputSupplier)new /* Unavailable Anonymous Inner Class!! */, (File)entryFile);
            }
            this.importData(tempDir, null, options);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract data from '" + resource + "' to '" + tempDir + "' for batch import.", e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importXmlData(org.springframework.core.io.Resource resource, BufferedInputStream resourceStream, PortalDataKey portalDataKey) {
        try {
            String resourceUri = ResourceUtils.getResourceUri((org.springframework.core.io.Resource)resource);
            this.importData((Source)new StreamSource(resourceStream, resourceUri), portalDataKey);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaType getMediaType(BufferedInputStream inputStream, String fileName) throws IOException {
        TikaInputStream tikaInputStreamStream = TikaInputStream.get((InputStream)new CloseShieldInputStream((InputStream)inputStream));
        try {
            DefaultDetector detector = new DefaultDetector();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", fileName);
            MediaType type = detector.detect((InputStream)tikaInputStreamStream, metadata);
            this.logger.debug("Determined '{}' for '{}'", (Object)type, (Object)fileName);
            MediaType mediaType = type;
            return mediaType;
        }
        catch (IOException e) {
            this.logger.warn("Failed to determine media type for '" + fileName + "' assuming XML", (Throwable)e);
            MediaType mediaType = null;
            return mediaType;
        }
        finally {
            IOUtils.closeQuietly((InputStream)tikaInputStreamStream);
            inputStream.reset();
        }
    }

    public void importData(File directory, String pattern, IPortalDataHandlerService.BatchImportOptions options) {
        PrintWriter reportWriter;
        if (!directory.exists()) {
            throw new IllegalArgumentException("The specified directory '" + directory + "' does not exist");
        }
        AntPatternFileFilter fileFilter = pattern != null ? new AntPatternFileFilter(true, false, pattern, (Collection)this.dataFileExcludes) : new AntPatternFileFilter(true, false, (Collection)this.dataFileIncludes, (Collection)this.dataFileExcludes);
        File logDirectory = this.determineLogDirectory((IPortalDataHandlerService.BatchOptions)options, "import");
        File importReport = new File(logDirectory, "data-import.txt");
        try {
            reportWriter = new PrintWriter((Writer)new PeriodicFlushingBufferedWriter(500L, (Writer)new FileWriter(importReport)));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create FileWriter for: " + importReport, e);
        }
        URI directoryUri = directory.toURI();
        String directoryUriStr = directoryUri.toString();
        IMPORT_BASE_DIR.set(directoryUriStr);
        try {
            this.logger.info("Scanning for files to Import from: {}", (Object)directory);
            PortalDataKeyFileProcessor fileProcessor = new PortalDataKeyFileProcessor(this.dataKeyTypes, options);
            this.directoryScanner.scanDirectoryNoResults(directory, (FileFilter)fileFilter, (Function)fileProcessor);
            long resourceCount = fileProcessor.getResourceCount();
            this.logger.info("Found {} files to Import from: {}", (Object)resourceCount, (Object)directory);
            boolean failOnError = options != null ? options.isFailOnError() : true;
            ConcurrentMap dataToImport = fileProcessor.getDataToImport();
            for (PortalDataKey portalDataKey : this.dataKeyImportOrder) {
                Queue files = (Queue)dataToImport.remove(portalDataKey);
                if (files == null) continue;
                LinkedList<ImportFuture> importFutures = new LinkedList<ImportFuture>();
                LinkedList failedFutures = new LinkedList();
                int fileCount = files.size();
                this.logger.info("Importing {} files of type {}", (Object)fileCount, (Object)portalDataKey);
                reportWriter.println(portalDataKey + "," + fileCount);
                while (!files.isEmpty()) {
                    org.springframework.core.io.Resource file = (org.springframework.core.io.Resource)files.poll();
                    List newFailed = this.waitForFutures(importFutures, reportWriter, logDirectory, false);
                    failedFutures.addAll(newFailed);
                    AtomicLong importTime = new AtomicLong(-1L);
                    2 task = new /* Unavailable Anonymous Inner Class!! */;
                    Future importFuture = this.importExportThreadPool.submit(task);
                    importFutures.offer(new ImportFuture(importFuture, file, portalDataKey, importTime));
                }
                List newFailed = this.waitForFutures(importFutures, reportWriter, logDirectory, true);
                failedFutures.addAll(newFailed);
                if (failOnError && !failedFutures.isEmpty()) {
                    throw new RuntimeException(failedFutures.size() + " " + portalDataKey + " entities failed to import.\n\n" + "\tPer entity exception logs and a full report can be found in " + logDirectory + "\n");
                }
                reportWriter.flush();
            }
            if (!dataToImport.isEmpty()) {
                throw new IllegalStateException("The following PortalDataKeys are not listed in the dataTypeImportOrder List: " + dataToImport.keySet());
            }
            this.logger.info("For a detailed report on the data import see " + importReport);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for entities to import", e);
        }
        finally {
            IOUtils.closeQuietly((Writer)reportWriter);
            IMPORT_BASE_DIR.remove();
        }
    }

    private File determineLogDirectory(IPortalDataHandlerService.BatchOptions options, String operation) {
        File logDirectoryParent;
        File file = logDirectoryParent = options != null ? options.getLogDirectoryParent() : null;
        if (logDirectoryParent == null) {
            logDirectoryParent = Files.createTempDir();
        }
        File logDirectory = new File(logDirectoryParent, "data-" + operation + "-reports");
        try {
            logDirectory = logDirectory.getCanonicalFile();
            FileUtils.deleteDirectory((File)logDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean data-" + operation + " log directory: " + logDirectory, e);
        }
        logDirectory.mkdirs();
        return logDirectory;
    }

    public void importData(String resourceLocation) {
        org.springframework.core.io.Resource resource = this.resourceLoader.getResource(resourceLocation);
        this.importData(resource);
    }

    public void importData(org.springframework.core.io.Resource resource) {
        this.importData(resource, null);
    }

    public void importData(Source source) {
        this.importData(source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void importData(org.springframework.core.io.Resource resource, PortalDataKey portalDataKey) {
        InputStream resourceStream;
        try {
            resourceStream = resource.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load InputStream for resource: " + resource, e);
        }
        try {
            String resourceUri = ResourceUtils.getResourceUri((org.springframework.core.io.Resource)resource);
            this.importData((Source)new StreamSource(resourceStream, resourceUri), portalDataKey);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }

    protected final void importData(Source source, PortalDataKey portalDataKey) {
        BufferedXMLEventReader bufferedXmlEventReader = this.createSourceXmlEventReader(source);
        if (portalDataKey == null) {
            StartElement rootElement = StaxUtils.getRootElement((XMLEventReader)bufferedXmlEventReader);
            portalDataKey = new PortalDataKey(rootElement);
            bufferedXmlEventReader.reset();
        }
        String systemId = source.getSystemId();
        IPortalDataType portalDataType = (IPortalDataType)this.dataKeyTypes.get(portalDataKey);
        if (portalDataType == null) {
            throw new RuntimeException("No IPortalDataType configured for " + portalDataKey + ", the resource will be ignored: " + this.getPartialSystemId(systemId));
        }
        Set postProcessedPortalDataKeys = portalDataType.postProcessPortalDataKey(systemId, portalDataKey, (XMLEventReader)bufferedXmlEventReader);
        bufferedXmlEventReader.reset();
        if (postProcessedPortalDataKeys.size() == 1) {
            this.importOrUpgradeData(systemId, (PortalDataKey)DataAccessUtils.singleResult((Collection)postProcessedPortalDataKeys), (XMLEventReader)bufferedXmlEventReader);
        } else {
            for (PortalDataKey orderedPortalDataKey : this.dataKeyImportOrder) {
                if (!postProcessedPortalDataKeys.contains(orderedPortalDataKey)) continue;
                bufferedXmlEventReader.reset();
                this.importOrUpgradeData(systemId, orderedPortalDataKey, (XMLEventReader)bufferedXmlEventReader);
            }
        }
    }

    protected String getPartialSystemId(String systemId) {
        String directoryUriStr = (String)IMPORT_BASE_DIR.get();
        if (directoryUriStr == null) {
            return systemId;
        }
        if (systemId.startsWith(directoryUriStr)) {
            return systemId.substring(directoryUriStr.length());
        }
        return systemId;
    }

    protected final void importOrUpgradeData(String systemId, PortalDataKey portalDataKey, XMLEventReader xmlEventReader) {
        IDataImporter dataImporterExporter = (IDataImporter)this.portalDataImporters.get(portalDataKey);
        if (dataImporterExporter != null) {
            this.logger.debug("Importing: {}", (Object)this.getPartialSystemId(systemId));
            Object data = this.unmarshallData(xmlEventReader, dataImporterExporter);
            dataImporterExporter.importData(data);
            this.logger.info("Imported : {}", (Object)this.getPartialSystemId(systemId));
            return;
        }
        IDataUpgrader dataUpgrader = (IDataUpgrader)this.portalDataUpgraders.get(portalDataKey);
        if (dataUpgrader != null) {
            Node sourceNode;
            this.logger.debug("Upgrading: {}", (Object)this.getPartialSystemId(systemId));
            try {
                sourceNode = this.xmlUtilities.convertToDom(xmlEventReader);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Failed to create StAXSource from original XML reader", e);
            }
            DOMSource source = new DOMSource(sourceNode);
            DOMResult result = new DOMResult();
            boolean doImport = dataUpgrader.upgradeData((Source)source, (Result)result);
            if (doImport) {
                Node node = result.getNode();
                PortalDataKey upgradedPortalDataKey = new PortalDataKey(node);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Upgraded: " + this.getPartialSystemId(systemId) + " to " + upgradedPortalDataKey + "\n\nSource XML: \n" + XmlUtilitiesImpl.toString((Node)source.getNode()) + "\n\nResult XML: \n" + XmlUtilitiesImpl.toString((Node)node));
                } else {
                    this.logger.info("Upgraded: {} to {}", (Object)this.getPartialSystemId(systemId), (Object)upgradedPortalDataKey);
                }
                DOMSource upgradedSource = new DOMSource(node, systemId);
                this.importData((Source)upgradedSource, upgradedPortalDataKey);
            } else {
                this.logger.info("Upgraded and Imported: {}", (Object)this.getPartialSystemId(systemId));
            }
            return;
        }
        throw new IllegalArgumentException("Provided data " + portalDataKey + " has no registered importer or upgrader support: " + systemId);
    }

    protected Object unmarshallData(XMLEventReader bufferedXmlEventReader, IDataImporter<Object> dataImporterExporter) {
        Unmarshaller unmarshaller = dataImporterExporter.getUnmarshaller();
        try {
            StAXSource source = new StAXSource(bufferedXmlEventReader);
            return unmarshaller.unmarshal((Source)source);
        }
        catch (XmlMappingException e) {
            throw new RuntimeException("Failed to map provided XML to portal data", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read the provided XML data", e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create StAX Source to read XML data", e);
        }
    }

    protected BufferedXMLEventReader createSourceXmlEventReader(Source source) {
        StAXSource staxSource;
        XMLEventReader xmlEventReader;
        if (source instanceof StAXSource && (xmlEventReader = (staxSource = (StAXSource)source).getXMLEventReader()) != null) {
            if (xmlEventReader instanceof BufferedXMLEventReader) {
                BufferedXMLEventReader bufferedXMLEventReader = (BufferedXMLEventReader)xmlEventReader;
                bufferedXMLEventReader.reset();
                bufferedXMLEventReader.mark(-1);
                return bufferedXMLEventReader;
            }
            return new BufferedXMLEventReader(xmlEventReader, -1);
        }
        XMLInputFactory xmlInputFactory = this.xmlUtilities.getXmlInputFactory();
        try {
            xmlEventReader = xmlInputFactory.createXMLEventReader(source);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create XML Event Reader for data Source", e);
        }
        return new BufferedXMLEventReader(xmlEventReader, -1);
    }

    public Iterable<IPortalDataType> getExportPortalDataTypes() {
        return this.exportPortalDataTypes;
    }

    public Iterable<IPortalDataType> getDeletePortalDataTypes() {
        return this.deletePortalDataTypes;
    }

    public Iterable<? extends IPortalData> getPortalData(String typeId) {
        IDataExporter dataImporterExporter = this.getPortalDataExporter(typeId);
        return dataImporterExporter.getPortalData();
    }

    public String exportData(String typeId, String dataId, Result result) {
        IDataExporter portalDataExporter = this.getPortalDataExporter(typeId);
        Object data = portalDataExporter.exportData(dataId);
        if (data == null) {
            return null;
        }
        Marshaller marshaller = portalDataExporter.getMarshaller();
        try {
            marshaller.marshal(data, result);
            return portalDataExporter.getFileName(data);
        }
        catch (XmlMappingException e) {
            throw new RuntimeException("Failed to map provided portal data to XML", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write the provided XML data", e);
        }
    }

    public boolean exportData(String typeId, String dataId, File directory) {
        File exportTempFile;
        directory.mkdirs();
        try {
            exportTempFile = File.createTempFile(SafeFilenameUtils.makeSafeFilename((String)(StringUtils.rightPad((String)dataId, (int)2, (char)'-') + "-")), SafeFilenameUtils.makeSafeFilename((String)("." + typeId)), directory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temp file to export " + typeId + " " + dataId, e);
        }
        try {
            String fileName = this.exportData(typeId, dataId, (Result)new StreamResult(exportTempFile));
            if (fileName == null) {
                this.logger.info("Skipped: type={} id={}", (Object)typeId, (Object)dataId);
                boolean bl = false;
                return bl;
            }
            File destFile = new File(directory, fileName + "." + typeId + ".xml");
            if (destFile.exists()) {
                this.logger.warn("Exporting " + typeId + " " + dataId + " but destination file already exists, it will be overwritten: " + destFile);
                destFile.delete();
            }
            FileUtils.moveFile((File)exportTempFile, (File)destFile);
            this.logger.info("Exported: {}", (Object)destFile);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to export " + typeId + " " + dataId, e);
        }
        finally {
            FileUtils.deleteQuietly((File)exportTempFile);
        }
    }

    public void exportAllDataOfType(Set<String> typeIds, File directory, IPortalDataHandlerService.BatchExportOptions options) {
        PrintWriter reportWriter;
        ConcurrentLinkedQueue<ExportFuture> exportFutures = new ConcurrentLinkedQueue<ExportFuture>();
        boolean failOnError = options != null ? options.isFailOnError() : true;
        File logDirectory = this.determineLogDirectory((IPortalDataHandlerService.BatchOptions)options, "export");
        File exportReport = new File(logDirectory, "data-export.txt");
        try {
            reportWriter = new PrintWriter(new BufferedWriter(new FileWriter(exportReport)));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create FileWriter for: " + exportReport, e);
        }
        try {
            for (String typeId : typeIds) {
                LinkedList failedFutures = new LinkedList();
                File typeDir = new File(directory, typeId);
                this.logger.info("Adding all data of type {} to export queue: {}", (Object)typeId, (Object)typeDir);
                reportWriter.println(typeId + "," + typeDir);
                Iterable dataForType = this.getPortalData(typeId);
                for (IPortalData data : dataForType) {
                    String dataId = data.getDataId();
                    List newFailed = this.waitForFutures(exportFutures, reportWriter, logDirectory, false);
                    failedFutures.addAll(newFailed);
                    AtomicLong exportTime = new AtomicLong(-1L);
                    3 task = new /* Unavailable Anonymous Inner Class!! */;
                    Future exportFuture = this.importExportThreadPool.submit(task);
                    ExportFuture futureHolder = new ExportFuture(exportFuture, typeId, dataId, exportTime);
                    exportFutures.offer(futureHolder);
                }
                List newFailed = this.waitForFutures(exportFutures, reportWriter, logDirectory, true);
                failedFutures.addAll(newFailed);
                reportWriter.flush();
                if (!failOnError || failedFutures.isEmpty()) continue;
                throw new RuntimeException(failedFutures.size() + " " + typeId + " entities failed to export.\n" + "\tPer entity exception logs and a full report can be found in " + logDirectory);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for entities to export", e);
        }
        finally {
            IOUtils.closeQuietly((Writer)reportWriter);
        }
    }

    public void exportAllData(File directory, IPortalDataHandlerService.BatchExportOptions options) {
        Set portalDataTypes = this.exportAllPortalDataTypes != null ? this.exportAllPortalDataTypes : this.exportPortalDataTypes;
        LinkedHashSet<String> typeIds = new LinkedHashSet<String>();
        for (IPortalDataType portalDataType : portalDataTypes) {
            typeIds.add(portalDataType.getTypeId());
        }
        this.exportAllDataOfType(typeIds, directory, options);
    }

    protected IDataExporter<Object> getPortalDataExporter(String typeId) {
        IDataExporter dataExporter = (IDataExporter)this.portalDataExporters.get(typeId);
        if (dataExporter == null) {
            throw new IllegalArgumentException("No IDataExporter exists for: " + typeId);
        }
        return dataExporter;
    }

    public void deleteData(String typeId, String dataId) {
        IDataDeleter dataDeleter = (IDataDeleter)this.portalDataDeleters.get(typeId);
        if (dataDeleter == null) {
            throw new IllegalArgumentException("No IDataDeleter exists for: " + typeId);
        }
        Object data = dataDeleter.deleteData(dataId);
        if (data != null) {
            this.logger.info("Deleted data " + dataId + " of type " + typeId);
        } else {
            this.logger.info("No data " + dataId + " of type " + typeId + " exists to delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FutureHolder<?>> waitForFutures(Queue<? extends FutureHolder<?>> futures, PrintWriter reportWriter, File reportDirectory, boolean wait) throws InterruptedException {
        LinkedList failedFutures = new LinkedList();
        Iterator futuresItr = futures.iterator();
        while (futuresItr.hasNext()) {
            FutureHolder futureHolder = (FutureHolder)futuresItr.next();
            Future future = futureHolder.getFuture();
            if (!wait && (wait || !future.isDone())) continue;
            futuresItr.remove();
            try {
                if (future.isCancelled()) continue;
                if (this.maxWait > 0L) {
                    future.get(this.maxWait, this.maxWaitTimeUnit);
                } else {
                    future.get();
                }
                reportWriter.printf(REPORT_FORMAT, "SUCCESS", futureHolder.getDescription(), futureHolder.getExecutionTimeMillis());
            }
            catch (CancellationException e) {
            }
            catch (ExecutionException e) {
                this.logger.error("Failed: " + futureHolder);
                futureHolder.setError((Exception)e);
                failedFutures.add(futureHolder);
                reportWriter.printf(REPORT_FORMAT, "FAIL", futureHolder.getDescription(), futureHolder.getExecutionTimeMillis());
                try {
                    String dataReportName = SafeFilenameUtils.makeSafeFilename((String)(futureHolder.getDataType() + "_" + futureHolder.getDataName() + ".txt"));
                    File dataReportFile = new File(reportDirectory, dataReportName);
                    PrintWriter dataReportWriter = new PrintWriter(new BufferedWriter(new FileWriter(dataReportFile)));
                    try {
                        dataReportWriter.println("FAIL: " + futureHolder.getDataType() + " - " + futureHolder.getDataName());
                        dataReportWriter.println("--------------------------------------------------------------------------------");
                        e.getCause().printStackTrace(dataReportWriter);
                    }
                    finally {
                        IOUtils.closeQuietly((Writer)dataReportWriter);
                    }
                }
                catch (Exception re) {
                    this.logger.warn("Failed to write error report for failed " + futureHolder + ", logging root failure here", e.getCause());
                }
            }
            catch (TimeoutException e) {
                this.logger.warn("Failed: " + futureHolder);
                futureHolder.setError((Exception)e);
                failedFutures.add(futureHolder);
                future.cancel(true);
                reportWriter.printf(REPORT_FORMAT, "TIMEOUT", futureHolder.getDescription(), futureHolder.getExecutionTimeMillis());
            }
        }
        return failedFutures;
    }

    static /* synthetic */ ThreadLocal access$000() {
        return IMPORT_BASE_DIR;
    }
}

