/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml;

import java.util.EnumSet;
import java.util.Formatter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataHandlerService;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataHandlerServiceUtils;
import org.jasig.portal.logging.AppendableLogger;
import org.jasig.portal.logging.LogLevel;
import org.jasig.portal.utils.TableFormatter;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PortalDataHandlerServiceUtils {
    private PortalDataHandlerServiceUtils() {
    }

    public static void format(IPortalDataHandlerService dataHandlerService, Logger l) {
        Formatter f = new Formatter((Appendable)new AppendableLogger(l, LogLevel.INFO));
        TreeMap portalDataTypes = new TreeMap();
        Iterable exportPortalDataTypes = dataHandlerService.getExportPortalDataTypes();
        PortalDataHandlerServiceUtils.addDataTypes(portalDataTypes, (Iterable)exportPortalDataTypes, (Operations)Operations.EXPORT);
        Iterable deletePortalDataTypes = dataHandlerService.getDeletePortalDataTypes();
        PortalDataHandlerServiceUtils.addDataTypes(portalDataTypes, (Iterable)deletePortalDataTypes, (Operations)Operations.DELETE);
        TableFormatter tableFormatter = new TableFormatter(new TableFormatter.TableEntry((Object)"Data Type", "-", "s"), new TableFormatter.TableEntry[]{new TableFormatter.TableEntry((Object)"Export", "-", "s"), new TableFormatter.TableEntry((Object)"Delete", "-", "s")});
        for (Map.Entry portalDataTypeEntry : portalDataTypes.entrySet()) {
            String typeId = (String)portalDataTypeEntry.getKey();
            Set ops = (Set)portalDataTypeEntry.getValue();
            tableFormatter.addRow(new TableFormatter.TableEntry((Object)typeId, "-", "s"), new TableFormatter.TableEntry[]{new TableFormatter.TableEntry((Object)ops.contains(Operations.EXPORT), "-", "b"), new TableFormatter.TableEntry((Object)ops.contains(Operations.DELETE), "-", "b")});
        }
        tableFormatter.format(f);
    }

    public static void format(Iterable<? extends IPortalData> data, Logger l) {
        Formatter f = new Formatter((Appendable)new AppendableLogger(l, LogLevel.INFO));
        TableFormatter tableFormatter = new TableFormatter(new TableFormatter.TableEntry((Object)"sysid", "-", "s"), new TableFormatter.TableEntry[]{new TableFormatter.TableEntry((Object)"Description", "-", "s")});
        for (IPortalData iPortalData : data) {
            String dataId = iPortalData.getDataId();
            String dataTitle = iPortalData.getDataTitle();
            if (dataTitle == null || dataTitle.equals(dataId)) {
                dataTitle = "";
            }
            tableFormatter.addRow(new TableFormatter.TableEntry((Object)dataId, "-", "s"), new TableFormatter.TableEntry[]{new TableFormatter.TableEntry((Object)dataTitle, "-", "s")});
        }
        tableFormatter.format(f);
    }

    private static void addDataTypes(Map<String, Set<Operations>> portalDataTypes, Iterable<IPortalDataType> exportPortalDataTypes, Operations operation) {
        for (IPortalDataType portalDataType : exportPortalDataTypes) {
            String typeId = portalDataType.getTypeId();
            Set<Operations> supports = portalDataTypes.get(typeId);
            if (supports == null) {
                supports = EnumSet.of(operation);
                portalDataTypes.put(typeId, supports);
                continue;
            }
            supports.add(operation);
        }
    }
}

