/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PortalDataKey {
    public static final QName SCRIPT_ATTRIBUTE_NAME = new QName("script");
    public static final QName VERSION_ATTRIBUTE_NAME = new QName("version");
    private int hash = 0;
    private final QName name;
    private final String script;
    private final String version;

    public PortalDataKey(Node rootElement) {
        if (rootElement.getNodeType() == 9) {
            rootElement = ((Document)rootElement).getDocumentElement();
        }
        String nodeName = rootElement.getNodeName();
        String namespaceURI = rootElement.getNamespaceURI();
        this.name = namespaceURI != null ? new QName(namespaceURI, nodeName) : new QName(nodeName);
        NamedNodeMap attributes = rootElement.getAttributes();
        if (attributes != null) {
            Node scriptAttr = attributes.getNamedItem(SCRIPT_ATTRIBUTE_NAME.getLocalPart());
            this.script = scriptAttr != null ? scriptAttr.getTextContent() : null;
            Node versionAttr = attributes.getNamedItem(VERSION_ATTRIBUTE_NAME.getLocalPart());
            this.version = versionAttr != null ? versionAttr.getTextContent() : null;
        } else {
            this.script = null;
            this.version = null;
        }
    }

    public PortalDataKey(StartElement startElement) {
        this.name = startElement.getName();
        this.script = this.getAttributeValue(startElement, SCRIPT_ATTRIBUTE_NAME);
        this.version = this.getAttributeValue(startElement, VERSION_ATTRIBUTE_NAME);
    }

    public PortalDataKey(QName name, String script, String version) {
        Validate.notNull((Object)name);
        this.name = name;
        this.script = script;
        this.version = version;
    }

    protected String getAttributeValue(StartElement startElement, QName name) {
        Attribute versionAttr = startElement.getAttributeByName(name);
        if (versionAttr != null) {
            return versionAttr.getValue();
        }
        return null;
    }

    public QName getName() {
        return this.name;
    }

    public String getScript() {
        return this.script;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int lHash = this.hash;
        if (lHash == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
            this.hash = result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }
        return lHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortalDataKey other = (PortalDataKey)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.script == null ? other.script != null : !this.script.equals(other.script)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.name);
        if (this.script != null) {
            builder.append(" script=\"").append(this.script).append("\"");
        }
        if (this.version != null) {
            builder.append(" version=\"").append(this.version).append("\"");
        }
        builder.append(">");
        return builder.toString();
    }
}

