/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.crn;

import com.google.common.base.Function;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;
import org.jasig.portal.io.xml.IDataExporter;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.xml.XmlUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.XmlMappingException;

public abstract class AbstractDom4jExporter
implements IDataExporter<Tuple<String, Element>>,
Marshaller {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private XmlUtilities xmlUtilities;
    private IPortalDataType portalDataType;
    private Function<IPortalDataType, Iterable<? extends IPortalData>> portalDataRetriever;

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    @Required
    public void setPortalDataType(IPortalDataType portalDataType) {
        this.portalDataType = portalDataType;
    }

    @Required
    public void setPortalDataRetriever(Function<IPortalDataType, Iterable<? extends IPortalData>> portalDataRetriever) {
        this.portalDataRetriever = portalDataRetriever;
    }

    public IPortalDataType getPortalDataType() {
        return this.portalDataType;
    }

    public Iterable<? extends IPortalData> getPortalData() {
        return (Iterable)this.portalDataRetriever.apply((Object)this.portalDataType);
    }

    public Tuple<String, Element> exportData(String id) {
        Element node = this.exportDataElement(id);
        if (node == null) {
            return null;
        }
        return new Tuple((Object)id, (Object)node);
    }

    protected abstract Element exportDataElement(String var1);

    public String getFileName(Tuple<String, Element> data) {
        return SafeFilenameUtils.makeSafeFilename((String)((String)data.first));
    }

    public Marshaller getMarshaller() {
        return this;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public void marshal(Object graph, Result result) throws IOException, XmlMappingException {
        Transformer transformer;
        Tuple data = (Tuple)graph;
        try {
            transformer = this.xmlUtilities.getIdentityTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to load identity Transformer", e);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        try {
            transformer.transform((Source)new DocumentSource((Node)data.second), result);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Failed to write Element to Result for: " + (String)data.first, e);
        }
    }
}

