/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.ssd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jasig.portal.io.xml.AbstractJaxbDataHandler;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.ssd.ExternalLayoutAttributeDescriptor;
import org.jasig.portal.io.xml.ssd.ExternalOutputPropertyDescriptor;
import org.jasig.portal.io.xml.ssd.ExternalStylesheetData;
import org.jasig.portal.io.xml.ssd.ExternalStylesheetDataNameComparator;
import org.jasig.portal.io.xml.ssd.ExternalStylesheetDataScope;
import org.jasig.portal.io.xml.ssd.ExternalStylesheetDescriptor;
import org.jasig.portal.io.xml.ssd.ExternalStylesheetParameterDescriptor;
import org.jasig.portal.io.xml.ssd.StylesheetDescriptorPortalDataType;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.dao.jpa.LayoutAttributeDescriptorImpl;
import org.jasig.portal.layout.dao.jpa.OutputPropertyDescriptorImpl;
import org.jasig.portal.layout.dao.jpa.StylesheetParameterDescriptorImpl;
import org.jasig.portal.layout.om.ILayoutAttributeDescriptor;
import org.jasig.portal.layout.om.IOutputPropertyDescriptor;
import org.jasig.portal.layout.om.IStylesheetData;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetParameterDescriptor;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class StylesheetDescriptorImporterExporter
extends AbstractJaxbDataHandler<ExternalStylesheetDescriptor> {
    private StylesheetDescriptorPortalDataType stylesheetDescriptorPortalDataType;
    private IStylesheetDescriptorDao stylesheetDescriptorDao;

    @Autowired
    public void setStylesheetDescriptorPortalDataType(StylesheetDescriptorPortalDataType stylesheetDescriptorPortalDataType) {
        this.stylesheetDescriptorPortalDataType = stylesheetDescriptorPortalDataType;
    }

    @Autowired
    public void setStylesheetDescriptorDao(IStylesheetDescriptorDao stylesheetDescriptorDao) {
        this.stylesheetDescriptorDao = stylesheetDescriptorDao;
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return Collections.singleton(StylesheetDescriptorPortalDataType.IMPORT_40_DATA_KEY);
    }

    public IPortalDataType getPortalDataType() {
        return this.stylesheetDescriptorPortalDataType;
    }

    public Iterable<? extends IPortalData> getPortalData() {
        return this.stylesheetDescriptorDao.getStylesheetDescriptors();
    }

    @Transactional
    public void importData(ExternalStylesheetDescriptor data) {
        String stylesheetName = data.getName();
        String uri = data.getUri();
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptorByName(stylesheetName);
        if (stylesheetDescriptor == null) {
            stylesheetDescriptor = this.stylesheetDescriptorDao.createStylesheetDescriptor(stylesheetName, uri);
        } else {
            stylesheetDescriptor.setStylesheetResource(uri);
        }
        stylesheetDescriptor.setUrlNodeSyntaxHelperName(data.getUrlSyntaxHelper());
        stylesheetDescriptor.setDescription(data.getDescription());
        List extOutputProperties = data.getOutputProperties();
        ArrayList<OutputPropertyDescriptorImpl> outputPropertyDescriptors = new ArrayList<OutputPropertyDescriptorImpl>(extOutputProperties.size());
        for (ExternalOutputPropertyDescriptor extOutputProperty : extOutputProperties) {
            String name = extOutputProperty.getName();
            IStylesheetData.Scope scope = IStylesheetData.Scope.valueOf((String)extOutputProperty.getScope().name());
            OutputPropertyDescriptorImpl outputPropertyDescriptor = new OutputPropertyDescriptorImpl(name, scope);
            outputPropertyDescriptor.setDefaultValue(extOutputProperty.getDefaultValue());
            outputPropertyDescriptor.setDescription(extOutputProperty.getDescription());
            outputPropertyDescriptors.add(outputPropertyDescriptor);
        }
        stylesheetDescriptor.setOutputPropertyDescriptors(outputPropertyDescriptors);
        List extStylesheetParameters = data.getStylesheetParameters();
        ArrayList<StylesheetParameterDescriptorImpl> stylesheetParameterDescriptors = new ArrayList<StylesheetParameterDescriptorImpl>(extOutputProperties.size());
        for (ExternalStylesheetParameterDescriptor extStylesheetParameter : extStylesheetParameters) {
            String name = extStylesheetParameter.getName();
            IStylesheetData.Scope scope = IStylesheetData.Scope.valueOf((String)extStylesheetParameter.getScope().name());
            StylesheetParameterDescriptorImpl stylesheetParameterDescriptor = new StylesheetParameterDescriptorImpl(name, scope);
            stylesheetParameterDescriptor.setDefaultValue(extStylesheetParameter.getDefaultValue());
            stylesheetParameterDescriptor.setDescription(extStylesheetParameter.getDescription());
            stylesheetParameterDescriptors.add(stylesheetParameterDescriptor);
        }
        stylesheetDescriptor.setStylesheetParameterDescriptors(stylesheetParameterDescriptors);
        List extLayoutAttributes = data.getLayoutAttributes();
        ArrayList<LayoutAttributeDescriptorImpl> layoutAttributeDescriptors = new ArrayList<LayoutAttributeDescriptorImpl>(extOutputProperties.size());
        for (ExternalLayoutAttributeDescriptor extLayoutAttribute : extLayoutAttributes) {
            String name = extLayoutAttribute.getName();
            IStylesheetData.Scope scope = IStylesheetData.Scope.valueOf((String)extLayoutAttribute.getScope().name());
            LayoutAttributeDescriptorImpl layoutAttributeDescriptor = new LayoutAttributeDescriptorImpl(name, scope);
            layoutAttributeDescriptor.setDefaultValue(extLayoutAttribute.getDefaultValue());
            layoutAttributeDescriptor.setDescription(extLayoutAttribute.getDescription());
            layoutAttributeDescriptor.setTargetElementNames(new LinkedHashSet(extLayoutAttribute.getTargetElements()));
            layoutAttributeDescriptors.add(layoutAttributeDescriptor);
        }
        stylesheetDescriptor.setLayoutAttributeDescriptors(layoutAttributeDescriptors);
        this.stylesheetDescriptorDao.updateStylesheetDescriptor(stylesheetDescriptor);
    }

    public ExternalStylesheetDescriptor exportData(String name) {
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptorByName(name);
        if (stylesheetDescriptor == null) {
            return null;
        }
        return this.convert(stylesheetDescriptor);
    }

    public String getFileName(ExternalStylesheetDescriptor data) {
        return SafeFilenameUtils.makeSafeFilename((String)data.getName());
    }

    public ExternalStylesheetDescriptor deleteData(String name) {
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptorByName(name);
        if (stylesheetDescriptor == null) {
            return null;
        }
        ExternalStylesheetDescriptor result = this.convert(stylesheetDescriptor);
        this.stylesheetDescriptorDao.deleteStylesheetDescriptor(stylesheetDescriptor);
        return result;
    }

    protected void copyProperties(IStylesheetData source, ExternalStylesheetData dest) {
        dest.setName(source.getName());
        dest.setDefaultValue(source.getDefaultValue());
        dest.setDescription(source.getDescription());
        dest.setScope(ExternalStylesheetDataScope.valueOf((String)source.getScope().name()));
    }

    protected ExternalStylesheetDescriptor convert(IStylesheetDescriptor stylesheetDescriptor) {
        ExternalStylesheetDescriptor externalStylesheetDescriptor = new ExternalStylesheetDescriptor();
        externalStylesheetDescriptor.setName(stylesheetDescriptor.getName());
        externalStylesheetDescriptor.setUrlSyntaxHelper(stylesheetDescriptor.getUrlNodeSyntaxHelperName());
        externalStylesheetDescriptor.setDescription(stylesheetDescriptor.getDescription());
        externalStylesheetDescriptor.setUri(stylesheetDescriptor.getStylesheetResource());
        Collection outputPropertyDescriptors = stylesheetDescriptor.getOutputPropertyDescriptors();
        List extOutputPropertyDescriptors = externalStylesheetDescriptor.getOutputProperties();
        for (IOutputPropertyDescriptor outputPropertyDescriptor : outputPropertyDescriptors) {
            ExternalOutputPropertyDescriptor extOutputPropertyDescriptor = new ExternalOutputPropertyDescriptor();
            this.copyProperties((IStylesheetData)outputPropertyDescriptor, (ExternalStylesheetData)extOutputPropertyDescriptor);
            extOutputPropertyDescriptors.add(extOutputPropertyDescriptor);
        }
        Collections.sort(extOutputPropertyDescriptors, ExternalStylesheetDataNameComparator.INSTANCE);
        Collection stylesheetParameterDescriptors = stylesheetDescriptor.getStylesheetParameterDescriptors();
        List extStylesheetParameterDescriptors = externalStylesheetDescriptor.getStylesheetParameters();
        for (IStylesheetParameterDescriptor stylesheetParameterDescriptor : stylesheetParameterDescriptors) {
            ExternalStylesheetParameterDescriptor extStylesheetParameterDescriptor = new ExternalStylesheetParameterDescriptor();
            this.copyProperties((IStylesheetData)stylesheetParameterDescriptor, (ExternalStylesheetData)extStylesheetParameterDescriptor);
            extStylesheetParameterDescriptors.add(extStylesheetParameterDescriptor);
        }
        Collections.sort(extStylesheetParameterDescriptors, ExternalStylesheetDataNameComparator.INSTANCE);
        Collection layoutAttributeDescriptors = stylesheetDescriptor.getLayoutAttributeDescriptors();
        List extLayoutAttributeDescriptors = externalStylesheetDescriptor.getLayoutAttributes();
        for (ILayoutAttributeDescriptor layoutAttributeDescriptor : layoutAttributeDescriptors) {
            ExternalLayoutAttributeDescriptor extLayoutAttributeDescriptor = new ExternalLayoutAttributeDescriptor();
            this.copyProperties((IStylesheetData)layoutAttributeDescriptor, (ExternalStylesheetData)extLayoutAttributeDescriptor);
            extLayoutAttributeDescriptor.getTargetElements().addAll(layoutAttributeDescriptor.getTargetElementNames());
            extLayoutAttributeDescriptors.add(extLayoutAttributeDescriptor);
        }
        Collections.sort(extLayoutAttributeDescriptors, ExternalStylesheetDataNameComparator.INSTANCE);
        return externalStylesheetDescriptor;
    }
}

