/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.user;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.io.xml.AbstractJaxbDataHandler;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.user.Attribute;
import org.jasig.portal.io.xml.user.AttributeComparator;
import org.jasig.portal.io.xml.user.ExternalTemplateUser;
import org.jasig.portal.io.xml.user.ExternalUser;
import org.jasig.portal.io.xml.user.TemplateUserPortalDataType;
import org.jasig.portal.io.xml.user.UserPortalDataType;
import org.jasig.portal.io.xml.user.UserType;
import org.jasig.portal.persondir.ILocalAccountDao;
import org.jasig.portal.persondir.ILocalAccountPerson;
import org.jasig.portal.utils.ICounterStore;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.jasig.portal.utils.Tuple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

public class UserImporterExporter
extends AbstractJaxbDataHandler<UserType> {
    private static final ImmutableSet<PortalDataKey> IMPORT_DATA_KEYS = ImmutableSet.of((Object)UserPortalDataType.IMPORT_40_DATA_KEY, (Object)TemplateUserPortalDataType.IMPORT_40_DATA_KEY);
    private JdbcOperations jdbcOperations;
    private UserPortalDataType userPortalDataType;
    private boolean forceDefaultUserName = false;
    private String defaultUserName;
    private DataSource dataSource;
    private ILocalAccountDao localAccountDao;
    private ICounterStore counterStore;
    private IUserIdentityStore userIdentityStore;

    public void setForceDefaultUserName(boolean forceDefaultUserName) {
        this.forceDefaultUserName = forceDefaultUserName;
    }

    public void setDefaultUserName(String defaultUserName) {
        this.defaultUserName = defaultUserName;
    }

    @Autowired
    public void setUserIdentityStore(IUserIdentityStore userIdentityStore) {
        this.userIdentityStore = userIdentityStore;
    }

    @Autowired
    public void setUserPortalDataType(UserPortalDataType userPortalDataType) {
        this.userPortalDataType = userPortalDataType;
    }

    @Autowired
    public void setCounterStore(ICounterStore counterStore) {
        this.counterStore = counterStore;
    }

    @Resource(name="PortalDb")
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Autowired
    public void setLocalAccountDao(ILocalAccountDao localAccountDao) {
        this.localAccountDao = localAccountDao;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.jdbcOperations = new JdbcTemplate(this.dataSource);
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return IMPORT_DATA_KEYS;
    }

    public IPortalDataType getPortalDataType() {
        return this.userPortalDataType;
    }

    public Iterable<? extends IPortalData> getPortalData() {
        List userList = this.jdbcOperations.queryForList("SELECT USER_NAME FROM UP_USER", String.class);
        return Lists.transform((List)userList, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void importData(UserType userType) {
        Long nextStructId;
        String username = userType.getUsername();
        String defaultUsername = this.getDefaultUsername(userType);
        Tuple defaultUserInfo = this.getDefaultUserInfo(defaultUsername);
        Integer defaultUserId = defaultUserInfo != null ? (Integer)defaultUserInfo.first : null;
        int rowsUpdated = this.jdbcOperations.update("UPDATE UP_USER \nSET USER_DFLT_USR_ID = ?, USER_DFLT_LAY_ID=1, NEXT_STRUCT_ID=? \nWHERE USER_NAME = ?", new Object[]{defaultUserId, nextStructId = this.getNextStructId(username, defaultUserInfo), username});
        if (rowsUpdated != 1) {
            int userId = this.counterStore.getNextId("UP_USER");
            this.jdbcOperations.update("INSERT INTO UP_USER(USER_ID, USER_DFLT_USR_ID, USER_DFLT_LAY_ID, NEXT_STRUCT_ID, USER_NAME) \nVALUES(?, ?, 1, ?, ?)", new Object[]{userId, defaultUserId, nextStructId, username});
        }
        ILocalAccountPerson account = this.localAccountDao.getPerson(username);
        String password = userType.getPassword();
        List attributes = userType.getAttributes();
        if (password == null && attributes.isEmpty()) {
            if (account != null) {
                this.localAccountDao.deleteAccount(account);
            }
        } else {
            if (account == null) {
                account = this.localAccountDao.createPerson(username);
            }
            account.setPassword(password);
            Calendar lastPasswordChange = userType.getLastPasswordChange();
            if (lastPasswordChange != null) {
                account.setLastPasswordChange(lastPasswordChange.getTime());
            }
            account.removeAttribute(username);
            for (Attribute attribute : attributes) {
                account.setAttribute(attribute.getName(), attribute.getValues());
            }
            this.localAccountDao.updateAccount(account);
        }
    }

    protected Long getNextStructId(String username, Tuple<Integer, Long> defaultUserInfo) {
        List maxStructIdResults = this.jdbcOperations.queryForList("SELECT MAX(UPLS.STRUCT_ID) AS MAX_STRUCT_ID FROM UP_USER UPU     LEFT JOIN UP_LAYOUT_STRUCT UPLS ON UPU.USER_ID = UPLS.USER_ID WHERE UPU.USER_NAME = ?", Long.class, new Object[]{username});
        Long maxStructId = (Long)DataAccessUtils.singleResult((Collection)maxStructIdResults);
        if (maxStructId != null) {
            return maxStructId + 1L;
        }
        if (defaultUserInfo != null) {
            return (Long)defaultUserInfo.second;
        }
        return null;
    }

    protected Tuple<Integer, Long> getDefaultUserInfo(String defaultUsername) {
        if (defaultUsername == null) {
            return null;
        }
        List defaultUserInfoResults = this.jdbcOperations.query("SELECT USER_ID, NEXT_STRUCT_ID FROM UP_USER WHERE USER_NAME = ?", (RowMapper)new /* Unavailable Anonymous Inner Class!! */, new Object[]{defaultUsername});
        try {
            return (Tuple)DataAccessUtils.requiredSingleResult((Collection)defaultUserInfoResults);
        }
        catch (EmptyResultDataAccessException e) {
            throw new RuntimeException("No user data found for default-user: " + defaultUsername, e);
        }
    }

    protected String getDefaultUsername(UserType data) {
        String defaultUser = data.getDefaultUser();
        if (defaultUser == null || this.forceDefaultUserName) {
            return this.defaultUserName;
        }
        return defaultUser;
    }

    public UserType exportData(String userName) {
        String defaultUserName = this.getDefaultUserName(userName);
        boolean isDefaultUser = this.userIdentityStore.isDefaultUser(userName);
        Object userType = isDefaultUser ? new ExternalTemplateUser() : new ExternalUser();
        userType.setUsername(userName);
        userType.setDefaultUser(defaultUserName);
        ILocalAccountPerson localAccountPerson = this.localAccountDao.getPerson(userName);
        if (localAccountPerson != null) {
            userType.setPassword(localAccountPerson.getPassword());
            Date lastPasswordChange = localAccountPerson.getLastPasswordChange();
            if (lastPasswordChange != null) {
                Calendar lastPasswordChangeCal = Calendar.getInstance();
                lastPasswordChangeCal.setTime(lastPasswordChange);
                userType.setLastPasswordChange(lastPasswordChangeCal);
            }
            List externalAttributes = userType.getAttributes();
            for (Map.Entry attributeEntry : localAccountPerson.getAttributes().entrySet()) {
                String name = (String)attributeEntry.getKey();
                List values = (List)attributeEntry.getValue();
                Attribute externalAttribute = new Attribute();
                externalAttribute.setName(name);
                List externalValues = externalAttribute.getValues();
                for (Object value : values) {
                    if (value != null) {
                        externalValues.add(value.toString());
                        continue;
                    }
                    externalValues.add(null);
                }
                externalAttributes.add(externalAttribute);
            }
            Collections.sort(externalAttributes, AttributeComparator.INSTANCE);
        }
        return userType;
    }

    protected String getDefaultUserName(String userName) {
        List defaultUserIdResults = this.jdbcOperations.queryForList("SELECT user_dflt_usr_id FROM up_user WHERE user_name = ?", Integer.class, new Object[]{userName});
        Integer defaultUserId = (Integer)DataAccessUtils.singleResult((Collection)defaultUserIdResults);
        if (defaultUserId != null) {
            List defaultUserNameResults = this.jdbcOperations.queryForList("SELECT user_name FROM up_user WHERE user_id = ?", String.class, new Object[]{defaultUserId});
            return (String)DataAccessUtils.singleResult((Collection)defaultUserNameResults);
        }
        return null;
    }

    public String getFileName(UserType data) {
        return SafeFilenameUtils.makeSafeFilename((String)data.getUsername());
    }

    @Transactional
    public ExternalUser deleteData(String id) {
        return null;
    }
}

