/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jmx;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.jmx.JavaManagementServerBean;

public class JavaManagementServerListener
implements ServletContextListener {
    public static final String JMX_RMI_HOST = "org.jasig.portal.servlet.JavaManagementServerListener.host";
    public static final String JMX_RMI_PORT_1 = "org.jasig.portal.servlet.JavaManagementServerListener.portOne";
    public static final String JMX_RMI_PORT_2 = "org.jasig.portal.servlet.JavaManagementServerListener.portTwo";
    public static final String FAIL_ON_EXCEPTION = "org.jasig.portal.servlet.JavaManagementServerListener.failOnException";
    private static final String LOGGER_NAME = JavaManagementServerListener.class.getName();
    private JavaManagementServerBean javaManagementServerBean;
    private Log logger;

    protected Log getLogger() {
        Log l = this.logger;
        if (l == null) {
            this.logger = l = LogFactory.getLog((String)LOGGER_NAME);
        }
        return l;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        this.javaManagementServerBean = new JavaManagementServerBean();
        String failOnExceptionStr = servletContext.getInitParameter(FAIL_ON_EXCEPTION);
        boolean failOnException = Boolean.parseBoolean(failOnExceptionStr);
        this.javaManagementServerBean.setFailOnException(failOnException);
        String host = servletContext.getInitParameter(JMX_RMI_HOST);
        this.javaManagementServerBean.setHost(host);
        String portOneStr = servletContext.getInitParameter(JMX_RMI_PORT_1);
        try {
            int portOne = Integer.parseInt(portOneStr);
            this.javaManagementServerBean.setPortOne(portOne);
        }
        catch (NumberFormatException nfe) {
            this.getLogger().warn((Object)("init-parameter 'org.jasig.portal.servlet.JavaManagementServerListener.portOne' is required and must contain a number. '" + portOneStr + "' is not a valid number."), (Throwable)nfe);
        }
        String portTwoStr = servletContext.getInitParameter(JMX_RMI_PORT_2);
        try {
            int portTwo = Integer.parseInt(portTwoStr);
            this.javaManagementServerBean.setPortTwo(portTwo);
        }
        catch (NumberFormatException nfe) {
            this.getLogger().debug((Object)("Failed to convert init-parameter 'org.jasig.portal.servlet.JavaManagementServerListener.portTwo' with value '" + portTwoStr + "' to a number, defaulting portTwo to portOne + 1"), (Throwable)nfe);
        }
        this.javaManagementServerBean.startServer();
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.javaManagementServerBean.stopServer();
        this.javaManagementServerBean = null;
    }
}

