/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jpa;

import com.google.common.base.Function;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Session;
import org.jasig.portal.jpa.BaseJpaDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public abstract class BaseJpaDao
implements InitializingBean,
ApplicationContextAware {
    private static final String QUERY_SUFFIX = ".Query";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;

    protected abstract EntityManager getEntityManager();

    protected abstract TransactionOperations getTransactionOperations();

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected final <T> ParameterExpression<T> createParameterExpression(Class<T> paramClass) {
        EntityManager entityManager = this.getEntityManager();
        EntityManagerFactory entityManagerFactory = entityManager.getEntityManagerFactory();
        CriteriaBuilder criteriaBuilder = entityManagerFactory.getCriteriaBuilder();
        return criteriaBuilder.parameter(paramClass);
    }

    protected final <T> ParameterExpression<T> createParameterExpression(Class<T> paramClass, String name) {
        EntityManager entityManager = this.getEntityManager();
        EntityManagerFactory entityManagerFactory = entityManager.getEntityManagerFactory();
        CriteriaBuilder criteriaBuilder = entityManagerFactory.getCriteriaBuilder();
        return criteriaBuilder.parameter(paramClass, name);
    }

    protected final <T> CriteriaQuery<T> createCriteriaQuery(Function<CriteriaBuilder, CriteriaQuery<T>> builder) {
        EntityManager entityManager = this.getEntityManager();
        EntityManagerFactory entityManagerFactory = entityManager.getEntityManagerFactory();
        CriteriaBuilder criteriaBuilder = entityManagerFactory.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = (CriteriaQuery)builder.apply((Object)criteriaBuilder);
        TransactionOperations transactionOperations = this.getTransactionOperations();
        transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        return criteriaQuery;
    }

    protected final <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.getEntityManager().createQuery(criteriaQuery);
    }

    protected final <T> TypedQuery<T> createCachedQuery(CriteriaQuery<T> criteriaQuery) {
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        String cacheRegion = this.getCacheRegionName(criteriaQuery);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)cacheRegion);
        return query;
    }

    protected final <T> NaturalIdQuery<T> createNaturalIdQuery(Class<T> entityType) {
        Session session;
        EntityManager entityManager = this.getEntityManager();
        try {
            session = (Session)entityManager.unwrap(Session.class);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("The DAO Method that calls createNaturalIdQuery must be annotated with @OpenEntityManager or @Transactional", e);
        }
        NaturalIdLoadAccess naturalIdLoadAccess = session.byNaturalId(entityType);
        return new NaturalIdQuery(entityType, naturalIdLoadAccess);
    }

    protected final <T> String getCacheRegionName(CriteriaQuery<T> criteriaQuery) {
        Set roots = criteriaQuery.getRoots();
        Class cacheRegionType = ((Root)roots.iterator().next()).getJavaType();
        String cacheRegion = cacheRegionType.getName() + QUERY_SUFFIX;
        if (roots.size() > 1) {
            this.logger.warn("Query " + criteriaQuery + " in " + this.getClass() + " has " + roots.size() + " roots. The first will be used to generated the cache region name: " + cacheRegion);
        }
        return cacheRegion;
    }
}

