/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jpa;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.jpa.IVersionedDatabaseUpdateHelper;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.jpa.VersionedDataUpdater;
import org.jasig.portal.jpa.VersionedDataUpdaterImpl;
import org.jasig.portal.version.VersionUtils;
import org.jasig.portal.version.dao.VersionDao;
import org.jasig.portal.version.om.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="versionedDataUpdater")
public class VersionedDataUpdaterImpl
implements VersionedDataUpdater {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Version> requiredProductVersions = Collections.emptyMap();
    private VersionDao versionDao;
    private Map<String, SortedSet<IVersionedDatabaseUpdateHelper>> databaseUpdateHelpers = Collections.emptyMap();

    @Resource(name="productVersions")
    public void setRequiredProductVersions(Map<String, Version> requiredProductVersions) {
        this.requiredProductVersions = ImmutableMap.copyOf(requiredProductVersions);
    }

    @Autowired
    public void setVersionedDatabaseUpdateHelpers(Collection<IVersionedDatabaseUpdateHelper> helpers) {
        this.databaseUpdateHelpers = new HashMap();
        for (IVersionedDatabaseUpdateHelper helper : helpers) {
            String databaseName = helper.getDatabaseName();
            TreeSet<IVersionedDatabaseUpdateHelper> updaters = (TreeSet<IVersionedDatabaseUpdateHelper>)this.databaseUpdateHelpers.get(databaseName);
            if (updaters == null) {
                updaters = new TreeSet<IVersionedDatabaseUpdateHelper>((Comparator<IVersionedDatabaseUpdateHelper>)VersionedDatabaseUpdateHelperComparator.INSTANCE);
                this.databaseUpdateHelpers.put(databaseName, updaters);
            }
            updaters.add(helper);
        }
    }

    @Autowired
    public void setVersionDao(VersionDao versionDao) {
        this.versionDao = versionDao;
    }

    @BasePortalJpaDao.PortalTransactional
    public void postInitDatabase(String product) {
        Version version = (Version)this.requiredProductVersions.get(product);
        if (version == null) {
            throw new IllegalArgumentException("No Version is configured for: " + product);
        }
        this.logger.info("PostInit - Set {} version to {}", (Object)product, (Object)version);
        this.versionDao.setVersion(product, version);
    }

    @OpenEntityManager(unitName="PortalDb")
    public void preUpdateDatabase(String product) {
        Version dbVersion = this.getAndVerifyDatabaseVersionForUpdate(product);
        SortedSet updateHelpers = (SortedSet)this.databaseUpdateHelpers.get(product);
        if (updateHelpers == null || updateHelpers.isEmpty()) {
            this.logger.info("No IVersionedDatabaseUpdateHelpers configured for database {}, nothing will be done in preUpdate", (Object)product);
        } else {
            for (IVersionedDatabaseUpdateHelper updateHelper : updateHelpers) {
                Version updateVersion = updateHelper.getVersion();
                if (!dbVersion.equals(updateVersion) && !dbVersion.isBefore(updateVersion)) continue;
                this.logger.info("PreUpdate {} from {} to {}", new Object[]{product, dbVersion, updateVersion});
                updateHelper.preUpdate();
                this.logger.info("PreUpdate {} from {} to {} complete", new Object[]{product, dbVersion, updateVersion});
            }
        }
    }

    @BasePortalJpaDao.PortalTransactional
    public void postUpdateDatabase(String product) {
        Version dbVersion = this.getAndVerifyDatabaseVersionForUpdate(product);
        SortedSet updateHelpers = (SortedSet)this.databaseUpdateHelpers.get(product);
        if (updateHelpers == null || updateHelpers.isEmpty()) {
            this.logger.info("No IVersionedDatabaseUpdateHelpers configured for database {}, nothing will be done in postUpdate", (Object)product);
        } else {
            for (IVersionedDatabaseUpdateHelper updateHelper : updateHelpers) {
                Version updateVersion = updateHelper.getVersion();
                if (!dbVersion.equals(updateVersion) && !dbVersion.isBefore(updateVersion)) continue;
                this.logger.info("PostUpdate {} from {} to {}", new Object[]{product, dbVersion, updateVersion});
                updateHelper.postUpdate();
                this.logger.info("PostUpdate {} from {} to {} complete", new Object[]{product, dbVersion, updateVersion});
            }
        }
        Version codeVersion = (Version)this.requiredProductVersions.get(product);
        this.logger.info("PostUpdate - Set {} version to {}", (Object)product, (Object)codeVersion);
        this.versionDao.setVersion(product, codeVersion);
    }

    protected Version getAndVerifyDatabaseVersionForUpdate(String product) {
        Version codeVersion = (Version)this.requiredProductVersions.get(product);
        if (codeVersion == null) {
            throw new IllegalStateException("No code version configured for " + product);
        }
        Version dbVersion = this.versionDao.getVersion(product);
        if (dbVersion == null) {
            dbVersion = VersionUtils.parseVersion((String)"4.0.0");
        }
        if (!VersionUtils.canUpdate((Version)dbVersion, (Version)codeVersion)) {
            throw new IllegalStateException("Cannot update " + product + " db from " + dbVersion + " to " + codeVersion);
        }
        if (codeVersion.equals(dbVersion)) {
            this.logger.info("{} code version matches database version. No update needed.", (Object)product);
        }
        return dbVersion;
    }
}

