/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.FragmentActivator;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.UserView;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.utils.Tuple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class FragmentActivator {
    private static final String NEWLY_CREATED_ATTR = "newlyCreated";
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log LOG = LogFactory.getLog(FragmentActivator.class);
    private final LoadingCache<String, List<Locale>> fragmentOwnerLocales = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private Ehcache userViews;
    private Ehcache userViewErrors;
    private IUserIdentityStore identityStore;
    private IUserLayoutStore userLayoutStore;
    private ConfigurationLoader configurationLoader;
    private static final String PROPERTY_ALLOW_EXPANDED_CONTENT = "org.jasig.portal.layout.dlm.allowExpandedContent";
    private static final Pattern STANDARD_PATTERN = Pattern.compile("\\A[Rr][Ee][Gg][Uu][Ll][Aa][Rr]\\z");
    private static final Pattern EXPANDED_PATTERN = Pattern.compile(".*");

    @Autowired
    public void setUserViewErrors(@Qualifier(value="org.jasig.portal.layout.dlm.FragmentActivator.userViewErrors") Ehcache userViewErrors) {
        this.userViewErrors = userViewErrors;
    }

    @Autowired
    public void setUserViews(@Qualifier(value="org.jasig.portal.layout.dlm.FragmentActivator.userViews") Ehcache userViews) {
        this.userViews = new SelfPopulatingCache(userViews, (CacheEntryFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Autowired
    public void setConfigurationLoader(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    @Autowired
    public void setIdentityStore(IUserIdentityStore identityStore) {
        this.identityStore = identityStore;
    }

    @Autowired
    public void setUserLayoutStore(IUserLayoutStore userLayoutStore) {
        this.userLayoutStore = userLayoutStore;
    }

    private UserView activateFragment(UserViewKey userViewKey) {
        String ownerId = userViewKey.getOwnerId();
        FragmentDefinition fd = this.configurationLoader.getFragmentByOwnerId(ownerId);
        Locale locale = userViewKey.getLocale();
        ((List)this.fragmentOwnerLocales.getUnchecked((Object)ownerId)).add(locale);
        if (fd.isNoAudienceIncluded()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping activation of FragmentDefinition " + fd.getName() + ", no evaluators found. " + fd));
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activating FragmentDefinition " + fd.getName() + " with locale " + locale));
        }
        IPerson owner = this.bindToOwner(fd);
        UserView view = new UserView(owner.getID());
        this.loadLayout(view, fd, owner, locale);
        if (owner.getAttribute(NEWLY_CREATED_ATTR) != null) {
            owner.setAttribute("RDBMDistributedLayoutStore.PLF", (Object)view.layout);
            try {
                this.saveLayout(view, owner);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save layout for newly created fragment owner " + owner.getUserName(), e);
            }
        }
        this.loadPreferences(view, fd);
        this.fragmentizeLayout(view, fd);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Activated FragmentDefinition " + fd.getName() + " with locale " + locale));
        }
        return view;
    }

    public UserView getUserView(FragmentDefinition fd, Locale locale) {
        UserViewKey userViewKey = new UserViewKey(fd.getOwnerId(), locale);
        Element userViewElement = this.userViews.get((Serializable)userViewKey);
        return (UserView)userViewElement.getObjectValue();
    }

    public boolean hasUserView(FragmentDefinition fd, Locale locale) {
        if (fd == null) {
            String msg = "Argument 'fd' [FragmentDefinition] cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.getUserView(fd.getOwnerId(), locale) != null;
    }

    private void saveLayout(UserView view, IPerson owner) throws Exception {
        UserProfile profile = new UserProfile();
        profile.setProfileId(view.profileId);
        this.userLayoutStore.setUserLayout(owner, (IUserProfile)profile, view.layout, true, false);
    }

    private IPerson bindToOwner(FragmentDefinition fragment) {
        PersonImpl owner = new PersonImpl();
        owner.setAttribute("username", (Object)fragment.getOwnerId());
        int userID = -1;
        try {
            userID = this.identityStore.getPortalUID((IPerson)owner, false);
        }
        catch (AuthorizationException ae) {
            // empty catch block
        }
        if (userID == -1) {
            userID = this.createOwner((IPerson)owner, fragment);
            owner.setAttribute(NEWLY_CREATED_ATTR, (Object)("" + (userID != -1)));
        }
        owner.setID(userID);
        return owner;
    }

    private int createOwner(IPerson owner, FragmentDefinition fragment) {
        String defaultUser = null;
        int userID = -1;
        if (fragment.defaultLayoutOwnerID != null) {
            defaultUser = fragment.defaultLayoutOwnerID;
        } else {
            String defaultLayoutOwner = PropertiesManager.getProperty((String)"org.jasig.portal.layout.dlm.defaultLayoutOwner");
            if (defaultLayoutOwner != null) {
                defaultUser = defaultLayoutOwner;
            } else {
                try {
                    defaultUser = PropertiesManager.getProperty((String)"org.jasig.portal.services.Authentication.defaultTemplateUserName");
                }
                catch (RuntimeException re) {
                    throw new RuntimeException("\n\n WARNING: defaultLayoutOwner is not specified in dlm.xml and no default user is configured for the system. Owner '" + fragment.getOwnerId() + "' for " + "fragment '" + fragment.getName() + "' can not be " + "created. The fragment will not be available for " + "inclusion into user layouts.\n", re);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\n\nOwner '" + fragment.getOwnerId() + "' of fragment '" + fragment.getName() + "' not found. Creating as copy of '" + defaultUser + "'\n"));
        }
        if (defaultUser != null) {
            owner.setAttribute("uPortalTemplateUserName", (Object)defaultUser);
        }
        try {
            userID = this.identityStore.getPortalUID(owner, true);
        }
        catch (AuthorizationException ae) {
            throw new RuntimeException("\n\nWARNING: Anomaly occurred while creating owner '" + fragment.getOwnerId() + "' of fragment '" + fragment.getName() + "'. The fragment will not be " + "available for inclusion into user layouts.", ae);
        }
        return userID;
    }

    private void loadLayout(UserView view, FragmentDefinition fragment, IPerson owner, Locale locale) {
        if (view.getUserId() == -1) {
            return;
        }
        Document layout = null;
        try {
            IUserProfile profile = this.userLayoutStore.getUserProfileByFname(owner, "default");
            profile.setLocaleManager(new LocaleManager(owner, new Locale[]{locale}));
            if (profile.getStructureStylesheetId() == 0 || profile.getThemeStylesheetId() == 0) {
                profile = this.userLayoutStore.getSystemProfileByFname(profile.getProfileFname());
            }
            view.profileId = profile.getProfileId();
            view.profileFname = profile.getProfileFname();
            view.layoutId = profile.getLayoutId();
            layout = this.userLayoutStore.getFragmentLayout(owner, profile);
            org.w3c.dom.Element root = layout.getDocumentElement();
            root.setAttribute("ID", "u" + view.getUserId() + "l" + view.layoutId);
            view.layout = layout;
        }
        catch (Exception e) {
            throw new RuntimeException("Anomaly occurred while loading layout for fragment '" + fragment.getName() + "'. The fragment will not be " + "available for inclusion into user layouts.", e);
        }
    }

    private void loadPreferences(UserView view, FragmentDefinition fragment) {
        if (view.getUserId() == -1) {
            return;
        }
        PersonImpl p = new PersonImpl();
        p.setID(view.getUserId());
        p.setAttribute("username", (Object)fragment.getOwnerId());
    }

    private void fragmentizeLayout(UserView view, FragmentDefinition fragment) {
        if (view.getUserId() == -1 || view.layout == null) {
            return;
        }
        Pattern contentPattern = STANDARD_PATTERN;
        boolean allowExpandedContent = Boolean.parseBoolean(PropertiesManager.getProperty((String)PROPERTY_ALLOW_EXPANDED_CONTENT));
        if (allowExpandedContent) {
            contentPattern = EXPANDED_PATTERN;
        }
        org.w3c.dom.Element layout = view.layout.getDocumentElement();
        org.w3c.dom.Element root = (org.w3c.dom.Element)layout.getFirstChild();
        NodeList children = root.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            org.w3c.dom.Element folder;
            boolean isApplicable;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("folder") || (isApplicable = contentPattern.matcher((folder = (org.w3c.dom.Element)node).getAttribute("type")).matches()) && !folder.getAttribute("hidden").equals("true")) continue;
            try {
                root.removeChild(folder);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Anomaly occurred while stripping out  portions of layout for fragment '" + fragment.getName() + "'. The fragment will not be available for " + "inclusion into user layouts.", e);
            }
        }
        this.setIdsAndAttribs(layout, layout.getAttribute("ID"), "" + fragment.getIndex(), "" + fragment.getPrecedence());
    }

    private void setIdsAndAttribs(org.w3c.dom.Element parent, String labelBase, String index, String precedence) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Element child;
            String id;
            if (children.item(i).getNodeType() != 1 || (id = (child = (org.w3c.dom.Element)children.item(i)).getAttribute("ID")).equals("")) continue;
            String newId = labelBase + id;
            child.setAttribute("ID", newId);
            child.setIdAttribute("ID", true);
            child.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:fragment", index);
            child.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:precedence", precedence);
            this.setIdsAndAttribs(child, labelBase, index, precedence);
        }
    }

    private Element getUserView(String ownerId, Locale locale) {
        return this.userViews.get((Serializable)new Tuple((Object)ownerId, (Object)locale.toString()));
    }

    public void clearChacheForOwner(String ownerId) {
        List locales = (List)this.fragmentOwnerLocales.getIfPresent((Object)ownerId);
        if (locales == null) {
            return;
        }
        for (Locale locale : locales) {
            UserViewKey userViewKey = new UserViewKey(ownerId, locale);
            this.userViews.remove((Serializable)userViewKey);
        }
    }

    static /* synthetic */ Ehcache access$000(FragmentActivator x0) {
        return x0.userViewErrors;
    }

    static /* synthetic */ UserView access$100(FragmentActivator x0, UserViewKey x1) {
        return x0.activateFragment(x1);
    }
}

