/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.layout.dlm.DistributedUserLayout;
import org.jasig.portal.layout.dlm.ILayoutCachingService;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.cache.CacheEntryTag;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.utils.cache.UsernameTaggedCacheEntryPurger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="layoutCachingService")
public class LayoutCachingService
implements ILayoutCachingService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Ehcache layoutCache;

    @Autowired
    public void setLayoutCache(@Qualifier(value="org.jasig.portal.layout.dlm.LAYOUT_CACHE") Ehcache layoutCache) {
        this.layoutCache = layoutCache;
    }

    public void cacheLayout(IPerson owner, IUserProfile profile, DistributedUserLayout layout) {
        CacheKey cacheKey = this.getCacheKey(owner, profile);
        this.layoutCache.put(new Element((Object)cacheKey, (Object)layout));
    }

    public DistributedUserLayout getCachedLayout(IPerson owner, IUserProfile profile) {
        CacheKey cacheKey = this.getCacheKey(owner, profile);
        Element element = this.layoutCache.get((Serializable)cacheKey);
        if (element != null) {
            return (DistributedUserLayout)element.getObjectValue();
        }
        return null;
    }

    public void removeCachedLayout(IPerson owner, IUserProfile profile) {
        CacheKey cacheKey = this.getCacheKey(owner, profile);
        this.layoutCache.remove((Serializable)cacheKey);
    }

    protected CacheKey getCacheKey(IPerson owner, IUserProfile profile) {
        return CacheKey.buildTagged((String)LayoutCachingService.class.getName(), (CacheEntryTag)UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)owner.getUserName()), (Serializable[])new Serializable[]{owner.getUserName(), Integer.valueOf(profile.getProfileId())});
    }
}

