/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.FragmentComparator;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;
import org.jasig.portal.xml.XmlUtilitiesImpl;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LegacyConfigurationLoader
implements ConfigurationLoader {
    private Resource configurationFile;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SingletonDoubleCheckedCreator<Boolean> loadedFlag = new /* Unavailable Anonymous Inner Class!! */;
    private List<FragmentDefinition> fragments = null;
    private Map<String, FragmentDefinition> fragmentsByName = null;
    private Map<String, FragmentDefinition> fragmentsByOwnerId = null;

    public void setConfigurationFile(Resource configurationFile) {
        this.configurationFile = configurationFile;
    }

    protected void loadFragmentInfo() {
        Document doc;
        String configUrl;
        InputStream inputStream;
        try {
            inputStream = this.configurationFile.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not open InputStream to dlm configuration resource " + this.configurationFile, e);
        }
        try {
            configUrl = this.configurationFile.getURL().toExternalForm();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not convert dlm configuration resource to URL " + this.configurationFile, e);
        }
        try {
            doc = DocumentFactory.getDocumentFromStream((InputStream)inputStream, (String)configUrl);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could load dlm configuration resource " + this.configurationFile, e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Could parse dlm configuration resource " + this.configurationFile, e);
        }
        NodeList fragmentNodes = doc.getElementsByTagName("dlm:fragment");
        List localFragments = this.getFragments(fragmentNodes);
        if (localFragments != null) {
            Collections.sort(localFragments, new FragmentComparator());
            if (this.logger.isDebugEnabled()) {
                StringBuilder bfr = new StringBuilder();
                for (FragmentDefinition fragmentDefinition : localFragments) {
                    bfr.append(fragmentDefinition.getName());
                    bfr.append("[");
                    bfr.append(fragmentDefinition.getPrecedence());
                    bfr.append("],\n");
                }
                this.logger.debug((Object)("Fragments Sorted by Precedence and then index {\n" + bfr.toString() + " }"));
            }
            LinkedHashMap<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
            for (FragmentDefinition fragmentDefinition : localFragments) {
                fragmentsByName.put(fragmentDefinition.getName(), fragmentDefinition);
            }
            LinkedHashMap<String, FragmentDefinition> fragmentsByOwnerId = new LinkedHashMap<String, FragmentDefinition>();
            for (FragmentDefinition fragmentDefinition : localFragments) {
                fragmentsByOwnerId.put(fragmentDefinition.getOwnerId(), fragmentDefinition);
            }
            this.fragments = Collections.unmodifiableList(localFragments);
            this.fragmentsByName = Collections.unmodifiableMap(fragmentsByName);
            this.fragmentsByOwnerId = Collections.unmodifiableMap(fragmentsByOwnerId);
        }
    }

    public List<FragmentDefinition> getFragments() {
        this.loadedFlag.get(new Object[0]);
        return this.fragments;
    }

    public FragmentDefinition getFragmentByName(String name) {
        this.loadedFlag.get(new Object[0]);
        return (FragmentDefinition)this.fragmentsByName.get(name);
    }

    public FragmentDefinition getFragmentByOwnerId(String ownerId) {
        this.loadedFlag.get(new Object[0]);
        return (FragmentDefinition)this.fragmentsByOwnerId.get(ownerId);
    }

    protected List<FragmentDefinition> getFragments(NodeList frags) {
        if (frags == null || frags.getLength() == 0) {
            return null;
        }
        int fragmentCount = frags.getLength();
        this.fragments = new ArrayList(fragmentCount);
        for (int i = 0; i < fragmentCount; ++i) {
            Element fragmentElement = (Element)frags.item(i);
            try {
                FragmentDefinition fragment = new FragmentDefinition(fragmentElement);
                fragment.setIndex(i);
                this.fragments.add(fragment);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("DLM loaded fragment definition '" + fragment.getName() + "' owned by '" + fragment.getOwnerId() + "' with precedence " + fragment.getPrecedence() + (fragment.isNoAudienceIncluded() ? " and no specified audience. It will be editable by '" + fragment.getOwnerId() + "' but " + "not included in any user's layout." : (fragment.isNoAudienceIncluded() ? " with no audience. It will be editable by '" + fragment.getOwnerId() + "' but " + "not included in any user's layout." : " with audiences defined"))));
                continue;
            }
            catch (Exception e) {
                String msg = "Unable to load distributed layout fragment definition. Content from this fragment will not be avilable.";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Unable to load distributed layout fragment definition. Content from this fragment will not be avilable." + XmlUtilitiesImpl.toString((Node)fragmentElement)), (Throwable)e);
                    continue;
                }
                this.logger.warn((Object)("Unable to load distributed layout fragment definition. Content from this fragment will not be avilable. Enable DEBUG logging for stack trace.\n\tCaused By: " + e.getMessage() + " " + XmlUtilitiesImpl.toString((Node)fragmentElement)));
            }
        }
        return this.fragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logConfigFileInfo() {
        if (this.logger.isInfoEnabled()) {
            InputStream is = null;
            try {
                is = this.configurationFile.getInputStream();
                this.logger.info((Object)("DLM config file: " + this.configurationFile));
            }
            catch (Exception exception) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }
}

