/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.dlm.DistributedUserLayout;
import org.jasig.portal.layout.dlm.Noderef;
import org.jasig.portal.layout.dlm.Pathref;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.BrokenSecurityContext;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.xml.XmlUtilities;
import org.jasig.portal.xml.xpath.XPathOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

@Component
public final class NodeReferenceFactory {
    private static final Pattern DLM_PATH_REF_DELIM = Pattern.compile("\\:");
    private static final Pattern USER_NODE_PATTERN = Pattern.compile("\\A([a-zA-Z]\\d*)\\z");
    private static final Pattern DLM_NODE_PATTERN = Pattern.compile("u(\\d+)l\\d+([ns]\\d+)");
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private IUserLayoutStore layoutStore;
    @Autowired
    private IUserIdentityStore userIdentityStore;
    @Autowired
    private XmlUtilities xmlUtilities;
    @Autowired
    private XPathOperations xPathOperations;

    public Noderef getNoderefFromPathref(String layoutOwner, String pathref, String fname, boolean isStructRef, Element layoutElement) {
        org.w3c.dom.Node structIdAttr;
        String[] pathTokens;
        Validate.notNull((Object)layoutOwner, (String)"Argument 'layoutOwner' cannot be null.");
        Validate.notNull((Object)pathref, (String)"Argument 'pathref' cannot be null.");
        if (this.log.isTraceEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("getDlmNoderef: [layoutOwner='").append(layoutOwner).append("', pathref='").append(pathref).append("', fname='").append(fname).append("', isStructRef='").append(isStructRef).append("']");
            this.log.trace((Object)msg.toString());
            this.log.trace((Object)("getDlmNoderef: user layout document follows...\n" + layoutElement.asXML()));
        }
        if ((pathTokens = DLM_PATH_REF_DELIM.split(pathref)).length <= 1) {
            this.log.warn((Object)("Invalid DLM PathRef, no delimiter: " + pathref));
            return null;
        }
        if (pathTokens[0].equals(layoutOwner)) {
            Element target = (Element)layoutElement.selectSingleNode(pathTokens[1]);
            if (target != null) {
                return new Noderef(target.valueOf("@ID"));
            }
            this.log.warn((Object)("Unable to resolve pathref '" + pathref + "' for layoutOwner '" + layoutOwner + "'"));
            return null;
        }
        String layoutOwnerName = pathTokens[0];
        String layoutPath = pathTokens[1];
        Integer layoutOwnerUserId = this.userIdentityStore.getPortalUserId(layoutOwnerName);
        if (layoutOwnerUserId == null) {
            this.log.warn((Object)("Unable to resolve pathref '" + pathref + "' for layoutOwner '" + layoutOwner + "', no userId found for userName: " + layoutOwnerName));
            return null;
        }
        Tuple userLayoutInfo = this.getUserLayoutTuple(layoutOwnerName, layoutOwnerUserId.intValue());
        Document userLayout = ((DistributedUserLayout)userLayoutInfo.second).getLayout();
        org.w3c.dom.Node targetNode = (org.w3c.dom.Node)this.xPathOperations.evaluate(layoutPath, (Object)userLayout, XPathConstants.NODE);
        if (targetNode == null) {
            this.log.warn((Object)("No layout node found for pathref: " + pathref));
            return null;
        }
        NamedNodeMap attributes = targetNode.getAttributes();
        if (fname != null) {
            org.w3c.dom.Node fnameAttr = attributes.getNamedItem("fname");
            if (fnameAttr == null) {
                this.log.warn((Object)("Layout node for pathref does not have fname attribute: " + pathref));
                return null;
            }
            String nodeFname = fnameAttr.getTextContent();
            if (!fname.equals(nodeFname)) {
                this.log.warn((Object)("fname '" + nodeFname + "' on layout node not match specified fname '" + fname + "' for pathref: " + pathref));
                return null;
            }
        }
        if ((structIdAttr = attributes.getNamedItem("struct-id")) != null) {
            String structId = structIdAttr.getTextContent();
            if (isStructRef) {
                return new Noderef(layoutOwnerUserId.intValue(), 1, "s" + structId);
            }
            return new Noderef(layoutOwnerUserId.intValue(), 1, "n" + structId);
        }
        org.w3c.dom.Node idAttr = attributes.getNamedItem("ID");
        return new Noderef(layoutOwnerUserId.intValue(), 1, idAttr.getTextContent());
    }

    public Pathref getPathrefFromNoderef(String layoutOwnerUsername, String dlmNoderef, Element layout) {
        Matcher userNodeMatcher;
        Validate.notNull((Object)layoutOwnerUsername, (String)"Argument 'layoutOwnerUsername' cannot be null.");
        Validate.notNull((Object)dlmNoderef, (String)"Argument 'dlmNoderef' cannot be null.");
        if (this.log.isTraceEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("createPathref: [layoutOwnerUsername='").append(layoutOwnerUsername).append("', dlmNoderef='").append(dlmNoderef).append("']");
            this.log.trace((Object)msg.toString());
        }
        Pathref rslt = null;
        Matcher dlmNodeMatcher = DLM_NODE_PATTERN.matcher(dlmNoderef);
        if (dlmNodeMatcher.matches()) {
            int userId = Integer.valueOf(dlmNodeMatcher.group(1));
            String nodeId = dlmNodeMatcher.group(2);
            String userName = this.userIdentityStore.getPortalUserName(userId);
            Tuple userLayoutInfo = this.getUserLayoutTuple(userName, userId);
            if (userLayoutInfo.second == null) {
                this.log.warn((Object)("no layout for fragment user '" + (String)userLayoutInfo.first + "' Specified dlmNoderef " + dlmNoderef + " cannot be resolved."));
                return null;
            }
            Document fragmentLayout = ((DistributedUserLayout)userLayoutInfo.second).getLayout();
            org.w3c.dom.Node targetElement = (org.w3c.dom.Node)this.xPathOperations.evaluate("//*[@ID = $nodeId]", Collections.singletonMap("nodeId", nodeId), (Object)fragmentLayout, XPathConstants.NODE);
            if (targetElement != null) {
                String xpath = this.xmlUtilities.getUniqueXPath(targetElement);
                String fname = null;
                org.w3c.dom.Node fnameAttr = targetElement.getAttributes().getNamedItem("fname");
                if (fnameAttr != null) {
                    fname = fnameAttr.getTextContent();
                }
                rslt = new Pathref((String)userLayoutInfo.first, xpath, fname);
            }
        }
        if ((userNodeMatcher = USER_NODE_PATTERN.matcher(dlmNoderef)).find()) {
            String structId = userNodeMatcher.group(1);
            Node target = layout.selectSingleNode("//*[@ID = '" + structId + "']");
            if (target == null) {
                this.log.warn((Object)("no match found on layout for user '" + layoutOwnerUsername + "' for the specified dlmNoderef:  " + dlmNoderef));
                return null;
            }
            String fname = null;
            if (target.getName().equals("channel")) {
                fname = target.valueOf("@fname");
            }
            rslt = new Pathref(layoutOwnerUsername, target.getUniquePath(), fname);
        }
        return rslt;
    }

    Tuple<String, DistributedUserLayout> getUserLayoutTuple(String userName, int userId) {
        PersonImpl person = new PersonImpl();
        person.setUserName(userName);
        person.setID(userId);
        person.setSecurityContext((ISecurityContext)new BrokenSecurityContext());
        IUserProfile profile = this.layoutStore.getUserProfileByFname((IPerson)person, "default");
        DistributedUserLayout userLayout = this.layoutStore.getUserLayout((IPerson)person, (IUserProfile)((UserProfile)profile));
        return new Tuple((Object)userName, (Object)userLayout);
    }
}

