/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.apache.commons.lang.Validate;

public final class Noderef {
    private static final String USER_ID_PREFIX = "u";
    private static final String LAYOUT_ID_PREFIX = "l";
    private final int userId;
    private final int layoutId;
    private final String structureId;

    public Noderef(String structureId) {
        this(0, 0, structureId);
    }

    public Noderef(int userId, int layoutId, String structureId) {
        boolean userAndLayoutIdsAreValid = userId > 0 && layoutId > 0 || userId == 0 && layoutId == 0;
        Validate.isTrue((boolean)userAndLayoutIdsAreValid, (String)"Arguments 'userId' and 'layoutId' must either both be zero or both greater than zero.");
        Validate.notNull((Object)structureId, (String)"Argument 'structureId' cannot be null.");
        this.userId = userId;
        this.layoutId = layoutId;
        this.structureId = structureId;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getLayoutId() {
        return this.layoutId;
    }

    public String getStructureId() {
        return this.structureId;
    }

    public String toString() {
        String rslt = null;
        if (this.userId != 0 && this.layoutId != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(USER_ID_PREFIX).append(this.userId).append(LAYOUT_ID_PREFIX).append(this.layoutId).append(this.structureId);
            rslt = sb.toString();
        } else {
            rslt = this.structureId;
        }
        return rslt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.layoutId;
        result = 31 * result + (this.structureId == null ? 0 : this.structureId.hashCode());
        result = 31 * result + this.userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Noderef other = (Noderef)obj;
        if (this.layoutId != other.layoutId) {
            return false;
        }
        if (this.structureId == null ? other.structureId != null : !this.structureId.equals(other.structureId)) {
            return false;
        }
        return this.userId == other.userId;
    }
}

