/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import com.google.common.cache.Cache;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.ehcache.Ehcache;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.PortalException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.io.xml.IPortalDataHandlerService;
import org.jasig.portal.layout.LayoutStructure;
import org.jasig.portal.layout.StructureParameter;
import org.jasig.portal.layout.StylesheetUserPreferencesImpl;
import org.jasig.portal.layout.dao.IStylesheetUserPreferencesDao;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.DistributedUserLayout;
import org.jasig.portal.layout.dlm.EditManager;
import org.jasig.portal.layout.dlm.FragmentActivator;
import org.jasig.portal.layout.dlm.FragmentChannelInfo;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.FragmentNodeInfo;
import org.jasig.portal.layout.dlm.ILFBuilder;
import org.jasig.portal.layout.dlm.IntegrationResult;
import org.jasig.portal.layout.dlm.NodeReferenceFactory;
import org.jasig.portal.layout.dlm.Noderef;
import org.jasig.portal.layout.dlm.PLFIntegrator;
import org.jasig.portal.layout.dlm.Pathref;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.layout.dlm.UserView;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetUserPreferences;
import org.jasig.portal.layout.simple.RDBMUserLayoutStore;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.BrokenSecurityContext;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.MapPopulator;
import org.jasig.portal.utils.Populator;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.xml.XmlUtilities;
import org.jasig.portal.xml.XmlUtilitiesImpl;
import org.jasig.portal.xml.xpath.XPathOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class RDBMDistributedLayoutStore
extends RDBMUserLayoutStore {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log LOG = LogFactory.getLog(RDBMDistributedLayoutStore.class);
    private static final Pattern VALID_PATHREF_PATTERN = Pattern.compile(".+\\:/.+");
    private static final String BAD_PATHREF_MESSAGE = "## DLM: ORPHANED DATA ##";
    private String systemDefaultUser = null;
    private boolean systemDefaultUserLoaded = false;
    private ConfigurationLoader configurationLoader;
    private FragmentActivator fragmentActivator;
    private Ehcache fragmentNodeInfoCache;
    private boolean errorOnMissingPortlet = true;
    private boolean errorOnMissingUser = true;
    static final String TEMPLATE_USER_NAME = "org.jasig.portal.services.Authentication.defaultTemplateUserName";
    private final org.dom4j.DocumentFactory fac = new org.dom4j.DocumentFactory();
    private final ThreadLocal<DOMReader> reader = new /* Unavailable Anonymous Inner Class!! */;
    private final ThreadLocal<DOMWriter> writer = new /* Unavailable Anonymous Inner Class!! */;
    private IUserIdentityStore userIdentityStore;
    private IStylesheetUserPreferencesDao stylesheetUserPreferencesDao;
    private XPathOperations xPathOperations;
    private XmlUtilities xmlUtilities;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletEntityDao portletEntityDao;
    private IPortalDataHandlerService portalDataHandlerService;
    @Autowired
    private NodeReferenceFactory nodeReferenceFactory;
    private final ThreadLocal<Cache<Tuple<String, String>, org.w3c.dom.Document>> layoutCacheHolder = new ThreadLocal();
    private static final List<FormOfLayoutCorruption> KNOWN_FORMS_OF_LAYOUT_CORRUPTION = Collections.unmodifiableList(Arrays.asList(new /* Unavailable Anonymous Inner Class!! */));

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    @Autowired
    public void setPortalDataHandlerService(IPortalDataHandlerService portalDataHandlerService) {
        this.portalDataHandlerService = portalDataHandlerService;
    }

    @Autowired
    public void setPortletEntityDao(@Qualifier(value="transient") IPortletEntityDao portletEntityDao) {
        this.portletEntityDao = portletEntityDao;
    }

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    @Autowired
    public void setXPathOperations(XPathOperations xPathOperations) {
        this.xPathOperations = xPathOperations;
    }

    @Autowired
    public void setIdentityStore(IUserIdentityStore identityStore) {
        this.userIdentityStore = identityStore;
    }

    @Autowired
    public void setStylesheetUserPreferencesDao(IStylesheetUserPreferencesDao stylesheetUserPreferencesDao) {
        this.stylesheetUserPreferencesDao = stylesheetUserPreferencesDao;
    }

    @Autowired
    public void setFragmentNodeInfoCache(@Qualifier(value="org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore.fragmentNodeInfoCache") Ehcache fragmentNodeInfoCache) {
        this.fragmentNodeInfoCache = fragmentNodeInfoCache;
    }

    @Value(value="${org.jasig.portal.io.layout.errorOnMissingPortlet:true}")
    public void setErrorOnMissingPortlet(boolean errorOnMissingPortlet) {
        this.errorOnMissingPortlet = errorOnMissingPortlet;
    }

    @Value(value="${org.jasig.portal.io.layout.errorOnMissingUser:true}")
    public void setErrorOnMissingUser(boolean errorOnMissingUser) {
        this.errorOnMissingUser = errorOnMissingUser;
    }

    public Map<String, org.w3c.dom.Document> getFragmentLayoutCopies() {
        Locale defaultLocale = LocaleManager.getPortalLocales()[0];
        FragmentActivator activator = this.getFragmentActivator();
        HashMap<String, org.w3c.dom.Document> layouts = new HashMap<String, org.w3c.dom.Document>();
        List definitions = this.configurationLoader.getFragments();
        for (FragmentDefinition fragmentDefinition : definitions) {
            org.w3c.dom.Document layout = DocumentFactory.getThreadDocument();
            UserView userView = activator.getUserView(fragmentDefinition, defaultLocale);
            if (userView == null) {
                this.log.warn((Object)("No UserView found for FragmentDefinition " + fragmentDefinition.getName() + ", it will be skipped."));
                continue;
            }
            org.w3c.dom.Node copy = layout.importNode(userView.layout.getDocumentElement(), true);
            layout.appendChild(copy);
            layouts.put(fragmentDefinition.getOwnerId(), layout);
        }
        return layouts;
    }

    @Autowired
    public void setConfigurationLoader(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    @Autowired
    public void setFragmentActivator(FragmentActivator fragmentActivator) {
        this.fragmentActivator = fragmentActivator;
    }

    private FragmentActivator getFragmentActivator() {
        return this.fragmentActivator;
    }

    protected IStylesheetUserPreferences loadDistributedStylesheetUserPreferences(IPerson person, IUserProfile profile, long stylesheetDescriptorId, Set<String> fragmentNames) {
        if (this.isFragmentOwner(person)) {
            return null;
        }
        Locale locale = profile.getLocaleManager().getLocales()[0];
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptor(stylesheetDescriptorId);
        IStylesheetUserPreferences stylesheetUserPreferences = this.stylesheetUserPreferencesDao.getStylesheetUserPreferences(stylesheetDescriptor, person, profile);
        StylesheetUserPreferencesImpl distributedStylesheetUserPreferences = new StylesheetUserPreferencesImpl(stylesheetDescriptorId, person.getID(), profile.getProfileId());
        FragmentActivator fragmentActivator = this.getFragmentActivator();
        for (String fragName : fragmentNames) {
            FragmentDefinition fragmentDefinition = this.configurationLoader.getFragmentByName(fragName);
            UserView userView = fragmentActivator.getUserView(fragmentDefinition, locale);
            if (userView == null) {
                this.log.warn((Object)("No UserView is present for fragment " + fragmentDefinition.getName() + " it will be skipped when loading distributed stylesheet user preferences"));
                continue;
            }
            IStylesheetUserPreferences fragmentStylesheetUserPreferences = this.stylesheetUserPreferencesDao.getStylesheetUserPreferences(stylesheetDescriptor, userView.getUserId(), userView.profileId);
            if (fragmentStylesheetUserPreferences == null) continue;
            Element root = userView.layout.getDocumentElement();
            String labelBase = root.getAttribute("ID");
            boolean modified = false;
            Collection allLayoutAttributeNodeIds = fragmentStylesheetUserPreferences.getAllLayoutAttributeNodeIds();
            for (String fragmentNodeId : allLayoutAttributeNodeIds) {
                String userNodeId = !fragmentNodeId.startsWith("u") ? labelBase + fragmentNodeId : fragmentNodeId;
                MapPopulator layoutAttributesPopulator = new MapPopulator();
                fragmentStylesheetUserPreferences.populateLayoutAttributes(fragmentNodeId, (Populator)layoutAttributesPopulator);
                Map layoutAttributes = layoutAttributesPopulator.getMap();
                for (Map.Entry layoutAttributesEntry : layoutAttributes.entrySet()) {
                    String userValue;
                    String name = (String)layoutAttributesEntry.getKey();
                    String value = (String)layoutAttributesEntry.getValue();
                    distributedStylesheetUserPreferences.setLayoutAttribute(userNodeId, name, value);
                    if (stylesheetUserPreferences == null || (userValue = stylesheetUserPreferences.getLayoutAttribute(userNodeId, name)) == null || !userValue.equals(value)) continue;
                    stylesheetUserPreferences.removeLayoutAttribute(userNodeId, name);
                    EditManager.removePreferenceDirective((IPerson)person, (String)userNodeId, (String)name);
                    modified = true;
                }
            }
            if (!modified) continue;
            this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(stylesheetUserPreferences);
        }
        return distributedStylesheetUserPreferences;
    }

    public double getFragmentPrecedence(int index) {
        List definitions = this.configurationLoader.getFragments();
        if (index < 0 || index > definitions.size() - 1) {
            return 0.0;
        }
        for (FragmentDefinition fragmentDefinition : definitions) {
            if (fragmentDefinition.getIndex() != index) continue;
            return fragmentDefinition.getPrecedence();
        }
        return 0.0;
    }

    public DistributedUserLayout getUserLayout(IPerson person, IUserProfile profile) {
        DistributedUserLayout layout = this._getUserLayout(person, profile);
        return layout;
    }

    private boolean layoutExistsForUser(IPerson person) {
        if (person == null) {
            String msg = "Argument 'person' cannot be null.";
            throw new IllegalArgumentException("Argument 'person' cannot be null.");
        }
        int struct_count = this.jdbcOperations.queryForInt("SELECT COUNT(*) FROM up_layout_struct WHERE user_id = ?", new Object[]{person.getID()});
        return struct_count != 0;
    }

    public org.dom4j.Element exportLayout(IPerson person, IUserProfile profile) {
        org.dom4j.Element layout = this.getExportLayoutDom(person, profile);
        int userId = person.getID();
        String userName = person.getUserName();
        Set portletEntities = this.portletEntityDao.getPortletEntitiesForUser(userId);
        org.dom4j.Element preferencesElement = null;
        for (IPortletEntity portletEntity : portletEntities) {
            List preferencesList = portletEntity.getPortletPreferences();
            if (preferencesList.isEmpty()) continue;
            String layoutNodeId = portletEntity.getLayoutNodeId();
            Pathref dlmPathref = this.nodeReferenceFactory.getPathrefFromNoderef(userName, layoutNodeId, layout);
            if (dlmPathref == null) {
                this.log.warn((Object)(portletEntity + " in user " + userName + "'s layout has no corresponding layout or portlet information and will be ignored"));
                continue;
            }
            for (IPortletPreference portletPreference : preferencesList) {
                if (preferencesElement == null) {
                    if (layout == null) {
                        Document layoutDoc = new org.dom4j.DocumentFactory().createDocument();
                        layout = layoutDoc.addElement("layout");
                        layout.addNamespace("dlm", "http://www.uportal.org/layout/dlm");
                    }
                    preferencesElement = layout.addElement("preferences");
                }
                org.dom4j.Element preferenceEntry = preferencesElement.addElement("entry");
                preferenceEntry.addAttribute("entity", dlmPathref.toString());
                preferenceEntry.addAttribute("channel", dlmPathref.getPortletFname());
                preferenceEntry.addAttribute("name", portletPreference.getName());
                for (String value : portletPreference.getValues()) {
                    org.dom4j.Element valueElement = preferenceEntry.addElement("value");
                    valueElement.setText(value);
                }
            }
        }
        if (layout != null) {
            layout.addAttribute("script", "classpath://org/jasig/portal/io/import-layout_v3-2.crn");
            layout.addAttribute("username", userName);
        }
        return layout;
    }

    private org.dom4j.Element getExportLayoutDom(IPerson person, IUserProfile profile) {
        Pathref dlmPathref;
        if (!this.layoutExistsForUser(person)) {
            return null;
        }
        Document layoutDoc = null;
        try {
            org.w3c.dom.Document layoutDom = this._safeGetUserLayout(person, profile);
            person.setAttribute("RDBMDistributedLayoutStore.PLF", (Object)layoutDom);
            layoutDoc = ((DOMReader)this.reader.get()).read(layoutDom);
        }
        catch (Throwable t) {
            String msg = "Unable to obtain layout & profile for user '" + person.getUserName() + "', profileId " + profile.getProfileId();
            throw new RuntimeException(msg, t);
        }
        if (this.log.isDebugEnabled()) {
            StringWriter str = new StringWriter();
            XMLWriter xml = new XMLWriter((Writer)str, new OutputFormat("  ", true));
            try {
                xml.write(layoutDoc);
                xml.close();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to write the layout for user '" + person.getUserName() + "' to the DEBUG log", t);
            }
            this.log.debug((Object)("Layout for user:  " + person.getUserName() + "\n" + str.getBuffer().toString()));
        }
        if (this.isLayoutCorrupt(layoutDoc)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Layout for user:  " + person.getUserName() + " is corrupt;  " + "layout structures will not be exported."));
            }
            return null;
        }
        int structureStylesheetId = profile.getStructureStylesheetId();
        this.addStylesheetUserPreferencesAttributes(person, profile, layoutDoc, structureStylesheetId, "structure");
        int themeStylesheetId = profile.getThemeStylesheetId();
        this.addStylesheetUserPreferencesAttributes(person, profile, layoutDoc, themeStylesheetId, "theme");
        for (Attribute loc : layoutDoc.selectNodes("//@locale")) {
            loc.getParent().remove(loc);
        }
        for (org.dom4j.Element ch : layoutDoc.selectNodes("//channel[@fname = '']")) {
            ch.getParent().remove(ch);
        }
        List<String> channelAttributeWhitelist = Arrays.asList("fname", "unremovable", "hidden", "immutable", "ID", "dlm:plfID", "dlm:moveAllowed", "dlm:deleteAllowed");
        for (org.dom4j.Element oldCh : layoutDoc.selectNodes("//channel")) {
            org.dom4j.Element parent = oldCh.getParent();
            org.dom4j.Element newCh = this.fac.createElement("channel");
            for (String aName : channelAttributeWhitelist) {
                Attribute a = (Attribute)oldCh.selectSingleNode("@" + aName);
                if (a == null) continue;
                newCh.addAttribute(a.getQName(), a.getValue());
            }
            parent.elements().add(parent.elements().indexOf(oldCh), newCh);
            parent.remove(oldCh);
        }
        for (Attribute org : layoutDoc.selectNodes("//@dlm:origin")) {
            dlmPathref = this.nodeReferenceFactory.getPathrefFromNoderef((String)person.getAttribute("username"), org.getValue(), layoutDoc.getRootElement());
            if (dlmPathref != null) {
                org.setValue(dlmPathref.toString());
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn((Object)("Layout element '" + org.getUniquePath() + "' from user '" + person.getAttribute("username") + "' failed to match noderef '" + org.getValue() + "'"));
        }
        for (Attribute target : layoutDoc.selectNodes("//@dlm:target")) {
            dlmPathref = this.nodeReferenceFactory.getPathrefFromNoderef((String)person.getAttribute("username"), target.getValue(), layoutDoc.getRootElement());
            if (dlmPathref != null) {
                target.setValue(dlmPathref.toString());
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn((Object)("Layout element '" + target.getUniquePath() + "' from user '" + person.getAttribute("username") + "' failed to match noderef '" + target.getValue() + "'"));
        }
        for (Attribute n : layoutDoc.selectNodes("//dlm:*/@name")) {
            if (n.getValue() == null || n.getValue().trim().length() == 0) continue;
            dlmPathref = this.nodeReferenceFactory.getPathrefFromNoderef((String)person.getAttribute("username"), n.getValue(), layoutDoc.getRootElement());
            if (dlmPathref != null) {
                n.setValue(dlmPathref.toString());
                if (dlmPathref.getPortletFname() == null) continue;
                n.getParent().addAttribute("fname", dlmPathref.getPortletFname());
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn((Object)("Layout element '" + n.getUniquePath() + "' from user '" + person.getAttribute("username") + "' failed to match noderef '" + n.getValue() + "'"));
        }
        if (!this.isFragmentOwner(person)) {
            for (Attribute plf : layoutDoc.selectNodes("//@dlm:plfID")) {
                plf.getParent().remove(plf);
            }
            for (Attribute a : layoutDoc.selectNodes("//@ID")) {
                a.getParent().remove(a);
            }
        }
        return layoutDoc.getRootElement();
    }

    private boolean isLayoutCorrupt(Document layoutDoc) {
        boolean rslt = false;
        for (FormOfLayoutCorruption form : KNOWN_FORMS_OF_LAYOUT_CORRUPTION) {
            if (!form.detect(layoutDoc)) continue;
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Corrupt layout detected: " + form.getMessage()));
            }
            rslt = true;
            break;
        }
        return rslt;
    }

    protected void addStylesheetUserPreferencesAttributes(IPerson person, IUserProfile profile, Document layoutDoc, int stylesheetId, String attributeType) {
        IStylesheetDescriptor structureStylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptor((long)stylesheetId);
        IStylesheetUserPreferences ssup = this.stylesheetUserPreferencesDao.getStylesheetUserPreferences(structureStylesheetDescriptor, person, profile);
        if (ssup != null) {
            Collection allLayoutAttributeNodeIds = ssup.getAllLayoutAttributeNodeIds();
            for (String nodeId : allLayoutAttributeNodeIds) {
                MapPopulator layoutAttributesPopulator = new MapPopulator();
                ssup.populateLayoutAttributes(nodeId, (Populator)layoutAttributesPopulator);
                Map layoutAttributes = layoutAttributesPopulator.getMap();
                org.dom4j.Element element = layoutDoc.elementByID(nodeId);
                if (element == null) {
                    this.log.warn((Object)("No node with id '" + nodeId + "' found in layout for: " + person.getUserName() + ". Stylesheet user preference layout attributes will be ignored: " + layoutAttributes));
                    continue;
                }
                for (Map.Entry attributeEntry : layoutAttributes.entrySet()) {
                    String name = (String)attributeEntry.getKey();
                    String value = (String)attributeEntry.getValue();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding structure folder attribute:  name=" + name + ", value=" + value));
                    }
                    org.dom4j.Element structAttrElement = this.fac.createElement(attributeType + "-attribute");
                    org.dom4j.Element nameAttribute = structAttrElement.addElement("name");
                    nameAttribute.setText(name);
                    org.dom4j.Element valueAttribute = structAttrElement.addElement("value");
                    valueAttribute.setText(value);
                    element.elements().add(0, structAttrElement);
                }
            }
        } else {
            LOG.debug((Object)("no StylesheetUserPreferences found for " + person + ", " + profile));
        }
    }

    @Transactional
    public void importLayout(org.dom4j.Element layout) {
        Noderef dlmNoderef;
        int ownerId;
        if (layout.getNamespaceForPrefix("dlm") == null) {
            layout.add(new Namespace("dlm", "http://www.uportal.org/layout/dlm"));
        }
        List comments = layout.selectNodes("//comment()");
        for (Node comment : comments) {
            comment.detach();
        }
        Node preferencesElement = layout.selectSingleNode("preferences");
        if (preferencesElement != null) {
            preferencesElement.getParent().remove(preferencesElement);
        }
        String ownerUsername = layout.valueOf("@username");
        Node profileElement = layout.selectSingleNode("profile");
        if (profileElement != null) {
            profileElement.getParent().remove(profileElement);
            Document profileDocument = new org.dom4j.DocumentFactory().createDocument();
            profileDocument.setRootElement((org.dom4j.Element)profileElement);
            profileDocument.setName(ownerUsername + ".profile");
            DocumentSource profileSource = new DocumentSource(profileElement);
            this.portalDataHandlerService.importData((Source)profileSource);
        }
        PersonImpl person = new PersonImpl();
        person.setUserName(ownerUsername);
        try {
            ownerId = this.userIdentityStore.getPortalUID((IPerson)person);
        }
        catch (AuthorizationException t) {
            if (this.errorOnMissingUser) {
                throw new RuntimeException("Unrecognized user " + person.getUserName() + "; you must import users before their layouts or set org.jasig.portal.io.layout.errorOnMissingUser to false.", t);
            }
            ownerId = this.userIdentityStore.getPortalUID((IPerson)person, true);
        }
        if (ownerId == -1) {
            throw new RuntimeException("Unrecognized user " + person.getUserName() + "; you must import users before their layouts or set org.jasig.portal.io.layout.errorOnMissingUser to false.");
        }
        person.setID(ownerId);
        UserProfile profile = null;
        try {
            person.setSecurityContext((ISecurityContext)new BrokenSecurityContext());
            profile = this.getUserProfileByFname((IPerson)person, "default");
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to load profile for " + person.getUserName() + "; This user must have a profile for import to continue.", t);
        }
        int nextId = 1;
        Iterator it = layout.selectNodes("folder | dlm:* | channel").iterator();
        while (it.hasNext()) {
            nextId = this.addIdAttributesIfNecessary((org.dom4j.Element)it.next(), nextId);
        }
        this.jdbcOperations.update("UPDATE up_user SET next_struct_id = ? WHERE user_id = ?", new Object[]{nextId, person.getID()});
        for (Attribute a : layout.selectNodes("//@dlm:origin")) {
            dlmNoderef = this.nodeReferenceFactory.getNoderefFromPathref(ownerUsername, a.getValue(), null, true, layout);
            if (dlmNoderef != null) {
                a.setValue(dlmNoderef.toString());
                a.getParent().addAttribute("ID", dlmNoderef.toString());
                continue;
            }
            a.setValue("## DLM: ORPHANED DATA ##");
        }
        Iterator itr = layout.selectNodes("//@dlm:target").iterator();
        while (itr.hasNext()) {
            Attribute a;
            dlmNoderef = this.nodeReferenceFactory.getNoderefFromPathref(ownerUsername, (a = (Attribute)itr.next()).getValue(), null, true, layout);
            a.setValue(dlmNoderef != null ? dlmNoderef.toString() : "## DLM: ORPHANED DATA ##");
        }
        for (Attribute a : layout.selectNodes("//dlm:*/@name")) {
            String value = a.getValue().trim();
            if (!VALID_PATHREF_PATTERN.matcher(value).matches()) continue;
            Attribute fname = a.getParent().attribute("fname");
            Noderef dlmNoderef2 = null;
            if (fname != null) {
                dlmNoderef2 = this.nodeReferenceFactory.getNoderefFromPathref(ownerUsername, value, fname.getValue(), false, layout);
                fname.getParent().remove(fname);
            } else {
                dlmNoderef2 = this.nodeReferenceFactory.getNoderefFromPathref(ownerUsername, value, null, true, layout);
            }
            a.setValue(dlmNoderef2 != null ? dlmNoderef2.toString() : "## DLM: ORPHANED DATA ##");
        }
        for (org.dom4j.Element c : layout.selectNodes("//channel")) {
            String fname = c.valueOf("@fname");
            IPortletDefinition cd = this.portletDefinitionRegistry.getPortletDefinitionByFname(fname);
            if (cd == null) {
                String msg = "No portlet with fname=" + fname + " exists referenced by node " + c.valueOf("@ID") + " from layout for " + ownerUsername;
                if (this.errorOnMissingPortlet) {
                    throw new IllegalArgumentException(msg);
                }
                this.log.warn((Object)msg);
                c.getParent().remove(c);
                continue;
            }
            c.addAttribute("chanID", String.valueOf(cd.getPortletDefinitionId().getStringId()));
        }
        org.w3c.dom.Document layoutDom = null;
        try {
            int structureStylesheetId = profile.getStructureStylesheetId();
            this.loadStylesheetUserPreferencesAttributes((IPerson)person, (IUserProfile)profile, layout, structureStylesheetId, "structure");
            int themeStylesheetId = profile.getThemeStylesheetId();
            this.loadStylesheetUserPreferencesAttributes((IPerson)person, (IUserProfile)profile, layout, themeStylesheetId, "theme");
            for (Text txt : layout.selectNodes("descendant::text()")) {
                if (txt.getText().trim().length() != 0) continue;
                txt.getParent().remove(txt);
            }
            org.dom4j.Element copy = layout.createCopy();
            Document doc = this.fac.createDocument(copy);
            doc.normalize();
            layoutDom = ((DOMWriter)this.writer.get()).write(doc);
            person.setAttribute("RDBMDistributedLayoutStore.PLF", (Object)layoutDom);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to set UserPreferences for user:  " + person.getUserName(), t);
        }
        try {
            this.setUserLayout((IPerson)person, (IUserProfile)profile, layoutDom, true, true);
        }
        catch (Throwable t) {
            String msg = "Unable to persist layout for user:  " + ownerUsername;
            throw new RuntimeException(msg, t);
        }
        if (preferencesElement != null) {
            int ownerUserId = this.userIdentityStore.getPortalUserId(ownerUsername);
            LinkedHashSet oldPortletEntities = new LinkedHashSet(this.portletEntityDao.getPortletEntitiesForUser(ownerUserId));
            List entries = preferencesElement.selectNodes("entry");
            for (org.dom4j.Element entry : entries) {
                String dlmPathRef = entry.attributeValue("entity");
                String fname = entry.attributeValue("channel");
                String prefName = entry.attributeValue("name");
                Noderef dlmNoderef3 = this.nodeReferenceFactory.getNoderefFromPathref(person.getUserName(), dlmPathRef, fname, false, layout);
                if (dlmNoderef3 == null || "".equals(dlmNoderef3) || fname == null || "null".equals(fname)) continue;
                IPortletEntity portletEntity = this.getPortletEntity(fname, dlmNoderef3.toString(), ownerUserId);
                oldPortletEntities.remove(portletEntity);
                List portletPreferences = portletEntity.getPortletPreferences();
                List valueElements = entry.selectNodes("value");
                ArrayList<String> values = new ArrayList<String>(valueElements.size());
                for (org.dom4j.Element valueElement : valueElements) {
                    values.add(valueElement.getText());
                }
                portletPreferences.add(new PortletPreferenceImpl(prefName, false, values.toArray(new String[values.size()])));
                this.portletEntityDao.updatePortletEntity(portletEntity);
            }
            for (IPortletEntity portletEntity : oldPortletEntities) {
                portletEntity.setPortletPreferences(null);
                if (this.portletEntityRegistry.shouldBePersisted(portletEntity)) {
                    this.portletEntityDao.updatePortletEntity(portletEntity);
                    continue;
                }
                this.portletEntityDao.deletePortletEntity(portletEntity);
            }
        }
    }

    protected IPortletEntity getPortletEntity(String fName, String layoutNodeId, int userId) {
        IPortletDefinition portletDefinition;
        IPortletEntity portletEntity = this.portletEntityDao.getPortletEntity(layoutNodeId, userId);
        if (portletEntity != null) {
            return portletEntity;
        }
        try {
            portletDefinition = this.portletDefinitionRegistry.getPortletDefinitionByFname(fName);
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("Failed to retrieve ChannelDefinition for fName='" + fName + "'", (Throwable)e);
        }
        if (portletDefinition == null) {
            throw new EmptyResultDataAccessException("No ChannelDefinition exists for fName='" + fName + "'", 1);
        }
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        return this.portletEntityDao.createPortletEntity(portletDefinitionId, layoutNodeId, userId);
    }

    protected void loadStylesheetUserPreferencesAttributes(IPerson person, IUserProfile profile, org.dom4j.Element layout, int structureStylesheetId, String nodeType) {
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptor((long)structureStylesheetId);
        List structureAttributes = layout.selectNodes("//" + nodeType + "-attribute");
        IStylesheetUserPreferences ssup = this.stylesheetUserPreferencesDao.getStylesheetUserPreferences(stylesheetDescriptor, person, profile);
        if (structureAttributes.isEmpty()) {
            if (ssup != null) {
                this.stylesheetUserPreferencesDao.deleteStylesheetUserPreferences(ssup);
            }
        } else {
            if (ssup == null) {
                ssup = this.stylesheetUserPreferencesDao.createStylesheetUserPreferences(stylesheetDescriptor, person, profile);
            }
            HashMap<String, Map> oldLayoutAttributes = new HashMap<String, Map>();
            for (String string : ssup.getAllLayoutAttributeNodeIds()) {
                MapPopulator nodeAttributes = new MapPopulator();
                ssup.populateLayoutAttributes(string, (Populator)nodeAttributes);
                oldLayoutAttributes.put(string, nodeAttributes.getMap());
            }
            for (org.dom4j.Element element : structureAttributes) {
                org.dom4j.Element layoutElement = element.getParent();
                String nodeId = layoutElement.valueOf("@ID");
                if (StringUtils.isEmpty((String)nodeId)) {
                    this.log.warn((Object)("@ID is empty for layout element, the attribute will be ignored: " + element.asXML()));
                }
                String name = element.valueOf("name");
                if (StringUtils.isEmpty((String)nodeId)) {
                    this.log.warn((Object)("name is empty for layout element, the attribute will be ignored: " + element.asXML()));
                    continue;
                }
                String value = element.valueOf("value");
                if (StringUtils.isEmpty((String)nodeId)) {
                    this.log.warn((Object)("value is empty for layout element, the attribute will be ignored: " + element.asXML()));
                    continue;
                }
                Map oldAttrs = (Map)oldLayoutAttributes.get(nodeId);
                if (oldAttrs != null) {
                    oldAttrs.remove(name);
                }
                ssup.setLayoutAttribute(nodeId, name, value);
                layoutElement.remove(element);
            }
            for (Map.Entry entry : oldLayoutAttributes.entrySet()) {
                String nodeId = (String)entry.getKey();
                for (String name : ((Map)entry.getValue()).keySet()) {
                    ssup.removeLayoutAttribute(nodeId, name);
                }
            }
            this.stylesheetUserPreferencesDao.storeStylesheetUserPreferences(ssup);
        }
    }

    private final int addIdAttributesIfNecessary(org.dom4j.Element e, int nextId) {
        int idAfterThisOne = nextId;
        Node idAttribute = e.selectSingleNode("@ID | @dlm:plfID");
        if (idAttribute == null) {
            char prefix;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No ID or dlm:plfID attribute for the following node (one will be generated and added):  element" + e.getName() + ", name=" + e.valueOf("@name") + ", fname=" + e.valueOf("@fname")));
            }
            if (e.getName().equals("folder")) {
                prefix = 's';
            } else if (e.getName().equals("channel")) {
                prefix = 'n';
            } else if (e.getQName().getNamespacePrefix().equals("dlm")) {
                prefix = 'd';
            } else {
                throw new RuntimeException("Unrecognized element type:  " + e.getName());
            }
            String origin = e.valueOf("@dlm:origin");
            if (origin != null && origin.length() != 0) {
                e.addAttribute("dlm:plfID", prefix + String.valueOf(nextId));
            } else {
                e.addAttribute("ID", prefix + String.valueOf(nextId));
            }
            ++idAfterThisOne;
        } else {
            String id = idAttribute.getText();
            try {
                idAfterThisOne = Integer.parseInt(id.substring(1)) + 1;
            }
            catch (NumberFormatException nfe) {
                this.log.warn((Object)("Could not parse int value from id: " + id + " The next layout id will be: " + idAfterThisOne), (Throwable)nfe);
            }
        }
        for (org.dom4j.Element child : e.selectNodes("folder | channel | dlm:*")) {
            idAfterThisOne = this.addIdAttributesIfNecessary(child, idAfterThisOne);
        }
        return idAfterThisOne;
    }

    public void setLayoutImportExportCache(Cache<Tuple<String, String>, org.w3c.dom.Document> layoutCache) {
        if (layoutCache == null) {
            this.layoutCacheHolder.remove();
        } else {
            this.layoutCacheHolder.set(layoutCache);
        }
    }

    public Cache<Tuple<String, String>, org.w3c.dom.Document> getLayoutImportExportCache() {
        return (Cache)this.layoutCacheHolder.get();
    }

    private org.w3c.dom.Document _safeGetUserLayout(IPerson person, IUserProfile profile) {
        org.w3c.dom.Document layoutDoc;
        Tuple key = null;
        Cache layoutCache = this.getLayoutImportExportCache();
        if (layoutCache != null && (layoutDoc = (org.w3c.dom.Document)layoutCache.getIfPresent((Object)(key = new Tuple((Object)person.getUserName(), (Object)profile.getProfileFname())))) != null) {
            return (org.w3c.dom.Document)layoutDoc.cloneNode(true);
        }
        layoutDoc = super.getPersonalUserLayout(person, profile);
        Element layout = layoutDoc.getDocumentElement();
        layout.setAttribute("xmlns:dlm", "http://www.uportal.org/layout/dlm");
        if (layoutCache != null && key != null) {
            layoutCache.put((Object)key, (Object)((org.w3c.dom.Document)layoutDoc.cloneNode(true)));
        }
        return layoutDoc;
    }

    private DistributedUserLayout _getUserLayout(IPerson person, IUserProfile profile) {
        String userName = (String)person.getAttribute("username");
        FragmentDefinition ownedFragment = this.getOwnedFragment(person);
        boolean isLayoutOwnerDefault = this.isLayoutOwnerDefault(person);
        if (ownedFragment != null || isLayoutOwnerDefault) {
            org.w3c.dom.Document ILF = null;
            org.w3c.dom.Document PLF = this._safeGetUserLayout(person, profile);
            ILF = (org.w3c.dom.Document)PLF.cloneNode(true);
            Element layoutNode = ILF.getDocumentElement();
            if (ownedFragment != null) {
                layoutNode.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:fragmentName", ownedFragment.getName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User '" + userName + "' is owner of '" + ownedFragment.getName() + "' fragment."));
                }
            } else if (isLayoutOwnerDefault) {
                layoutNode.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:isTemplateUser", "true");
                layoutNode.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:templateLoginID", (String)person.getAttribute("username"));
            }
            person.setAttribute("RDBMDistributedLayoutStore.PLF", (Object)PLF);
            return new DistributedUserLayout(ILF);
        }
        return this.getCompositeLayout(person, profile);
    }

    public org.w3c.dom.Document getFragmentLayout(IPerson person, IUserProfile profile) {
        return this._safeGetUserLayout(person, profile);
    }

    public String getNextStructDirectiveId(IPerson person) {
        return super.getNextStructId(person, "d");
    }

    private void updateCachedLayout(org.w3c.dom.Document layout, IUserProfile profile, FragmentDefinition fragment) {
        Locale locale = profile.getLocaleManager().getLocales()[0];
        layout = (org.w3c.dom.Document)layout.cloneNode(true);
        FragmentActivator activator = this.getFragmentActivator();
        Element root = layout.getDocumentElement();
        UserView userView = activator.getUserView(fragment, locale);
        if (userView == null) {
            throw new IllegalStateException("No UserView found for fragment: " + fragment.getName());
        }
        root.setAttribute("ID", "u" + userView.getUserId() + "l" + "1");
        try {
            activator.clearChacheForOwner(fragment.getOwnerId());
            activator.getUserView(fragment, locale);
        }
        catch (Exception e) {
            LOG.error((Object)"An exception occurred attempting to update a layout.", (Throwable)e);
        }
    }

    private boolean isLayoutOwnerDefault(IPerson person) {
        String globalDefault;
        String userName = (String)person.getAttribute("username");
        List definitions = this.configurationLoader.getFragments();
        if (userName != null && definitions != null) {
            for (FragmentDefinition fragmentDefinition : definitions) {
                if (fragmentDefinition.defaultLayoutOwnerID == null || !fragmentDefinition.defaultLayoutOwnerID.equals(userName)) continue;
                return true;
            }
        }
        if ((globalDefault = PropertiesManager.getProperty((String)"org.jasig.portal.layout.dlm.defaultLayoutOwner")) != null && globalDefault.equals(userName)) {
            return true;
        }
        if (!this.systemDefaultUserLoaded) {
            this.systemDefaultUserLoaded = true;
            try {
                this.systemDefaultUser = PropertiesManager.getProperty((String)"org.jasig.portal.services.Authentication.defaultTemplateUserName");
            }
            catch (RuntimeException re) {
                LOG.error((Object)"Property 'org.jasig.portal.services.Authentication.defaultTemplateUserName' not defined.", (Throwable)re);
            }
            if (this.systemDefaultUser != null && this.systemDefaultUser.equals(userName)) {
                return true;
            }
        }
        return false;
    }

    public boolean isFragmentOwner(IPerson person) {
        return this.getOwnedFragment(person) != null;
    }

    public boolean isFragmentOwner(String username) {
        boolean rslt = false;
        List definitions = this.configurationLoader.getFragments();
        if (definitions != null) {
            for (FragmentDefinition fragmentDefinition : definitions) {
                if (!fragmentDefinition.getOwnerId().equals(username)) continue;
                rslt = true;
                break;
            }
        }
        return rslt;
    }

    private FragmentDefinition getOwnedFragment(IPerson person) {
        String userName = person.getUserName();
        return this.configurationLoader.getFragmentByOwnerId(userName);
    }

    private DistributedUserLayout getCompositeLayout(IPerson person, IUserProfile profile) {
        org.w3c.dom.Document PLF;
        LinkedHashSet<String> fragmentNames = new LinkedHashSet<String>();
        LinkedList<org.w3c.dom.Document> applicables = new LinkedList<org.w3c.dom.Document>();
        Locale locale = profile.getLocaleManager().getLocales()[0];
        List definitions = this.configurationLoader.getFragments();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to check applicability of " + definitions.size() + " fragments"));
        }
        FragmentActivator activator = this.getFragmentActivator();
        if (definitions != null) {
            for (FragmentDefinition fragmentDefinition : definitions) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Checking applicability of the following fragment:  " + fragmentDefinition.getName()));
                }
                if (!fragmentDefinition.isApplicable(person)) continue;
                UserView userView = activator.getUserView(fragmentDefinition, locale);
                if (userView != null) {
                    applicables.add(userView.layout);
                }
                fragmentNames.add(fragmentDefinition.getName());
            }
        }
        if (null == (PLF = (org.w3c.dom.Document)person.getAttribute("RDBMDistributedLayoutStore.PLF"))) {
            PLF = this._safeGetUserLayout(person, profile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PLF for " + person.getAttribute("username") + " immediately after loading\n" + XmlUtilitiesImpl.toString((org.w3c.dom.Node)PLF)));
        }
        org.w3c.dom.Document ILF = ILFBuilder.constructILF((org.w3c.dom.Document)PLF, applicables, (IPerson)person);
        person.setAttribute("RDBMDistributedLayoutStore.PLF", (Object)PLF);
        IntegrationResult result = new IntegrationResult();
        PLFIntegrator.mergePLFintoILF((org.w3c.dom.Document)PLF, (org.w3c.dom.Document)ILF, (IntegrationResult)result);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PLF for " + person.getAttribute("username") + " after MERGING\n" + XmlUtilitiesImpl.toString((org.w3c.dom.Node)PLF)));
            LOG.debug((Object)("ILF for " + person.getAttribute("username") + " after MERGING\n" + XmlUtilitiesImpl.toString((org.w3c.dom.Node)ILF)));
        }
        if (result.changedPLF) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving PLF for " + person.getAttribute("username") + " due to changes during merge."));
            }
            super.setUserLayout(person, profile, PLF, false);
        }
        int structureStylesheetId = profile.getStructureStylesheetId();
        IStylesheetUserPreferences distributedStructureStylesheetUserPreferences = this.loadDistributedStylesheetUserPreferences(person, profile, (long)structureStylesheetId, fragmentNames);
        int themeStylesheetId = profile.getThemeStylesheetId();
        IStylesheetUserPreferences distributedThemeStylesheetUserPreferences = this.loadDistributedStylesheetUserPreferences(person, profile, (long)themeStylesheetId, fragmentNames);
        return new DistributedUserLayout(ILF, fragmentNames, distributedStructureStylesheetUserPreferences, distributedThemeStylesheetUserPreferences);
    }

    public void setUserLayout(IPerson person, IUserProfile profile, org.w3c.dom.Document layoutXML, boolean channelsAdded) {
        this.setUserLayout(person, profile, layoutXML, channelsAdded, true);
    }

    public void setUserLayout(IPerson person, IUserProfile profile, org.w3c.dom.Document layoutXML, boolean channelsAdded, boolean updateFragmentCache) {
        FragmentDefinition fragment;
        org.w3c.dom.Document plf = (org.w3c.dom.Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PLF for " + person.getAttribute("username") + "\n" + XmlUtilitiesImpl.toString((org.w3c.dom.Node)plf)));
        }
        super.setUserLayout(person, profile, plf, channelsAdded);
        if (updateFragmentCache && (fragment = this.getOwnedFragment(person)) != null) {
            this.updateCachedLayout(plf, profile, fragment);
        }
    }

    public FragmentChannelInfo getFragmentChannelInfo(String sId) {
        FragmentNodeInfo node = this.getFragmentNodeInfo(sId);
        if (node != null && node instanceof FragmentChannelInfo) {
            return (FragmentChannelInfo)node;
        }
        return null;
    }

    public FragmentNodeInfo getFragmentNodeInfo(String sId) {
        Object info;
        List fragments = this.configurationLoader.getFragments();
        Locale defaultLocale = LocaleManager.getPortalLocales()[0];
        FragmentActivator activator = this.getFragmentActivator();
        net.sf.ehcache.Element element = this.fragmentNodeInfoCache.get((Serializable)((Object)sId));
        FragmentNodeInfo fragmentNodeInfo = info = element != null ? (FragmentNodeInfo)element.getObjectValue() : null;
        if (info == null) {
            for (FragmentDefinition fragmentDefinition : fragments) {
                UserView userView = activator.getUserView(fragmentDefinition, defaultLocale);
                if (userView == null) {
                    this.log.warn((Object)("No UserView is present for fragment " + fragmentDefinition.getName() + " it will be skipped when fragment node information"));
                    continue;
                }
                Element node = userView.layout.getElementById(sId);
                if (node == null) continue;
                info = node.getTagName().equals("channel") ? new FragmentChannelInfo(node) : new FragmentNodeInfo(node);
                this.fragmentNodeInfoCache.put(new net.sf.ehcache.Element((Object)sId, info));
                break;
            }
        }
        return info;
    }

    private String getPlfId(org.w3c.dom.Document PLF, String incdId) {
        Element element = null;
        try {
            XPathFactory fac = XPathFactory.newInstance();
            XPath xp = fac.newXPath();
            element = (Element)xp.evaluate("//*[@ID = '" + incdId + "']", PLF, XPathConstants.NODE);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        if (element == null) {
            this.log.warn((Object)("The specified folderId was not found in the user's PLF:  " + incdId));
            return null;
        }
        Attr attr = element.getAttributeNode("dlm:plfID");
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    protected Element getStructure(org.w3c.dom.Document doc, LayoutStructure ls) {
        String prefix;
        Element structure = null;
        String type = ls.getType();
        if (type != null && type.startsWith("cp:")) {
            type = "dlm:" + type.substring("cp:".length());
        }
        if (ls.isChannel()) {
            IPortletDefinition channelDef = this.portletDefinitionRegistry.getPortletDefinition(String.valueOf(ls.getChanId()));
            if (channelDef != null && RDBMDistributedLayoutStore.channelApproved((Date)channelDef.getApprovalDate())) {
                structure = this.getElementForChannel(doc, "n" + ls.getStructId(), channelDef, ls.getLocale());
            } else {
                String missingChannel = "Unknown";
                if (channelDef != null) {
                    missingChannel = channelDef.getName();
                }
                structure = this.getElementForChannel(doc, "n" + ls.getStructId(), MissingPortletDefinition.INSTANCE, null);
            }
        } else {
            structure = type != null && type.startsWith("dlm:") ? doc.createElementNS("http://www.uportal.org/layout/dlm", type) : doc.createElement("folder");
            structure.setAttribute("name", ls.getName());
            structure.setAttribute("type", type != null ? type : "regular");
        }
        structure.setAttribute("hidden", ls.isHidden() ? "true" : "false");
        structure.setAttribute("immutable", ls.isImmutable() ? "true" : "false");
        structure.setAttribute("unremovable", ls.isUnremovable() ? "true" : "false");
        if (localeAware) {
            structure.setAttribute("locale", ls.getLocale());
        }
        if (ls.getParameters() != null) {
            Iterator itr = ls.getParameters().iterator();
            block0: while (itr.hasNext()) {
                StructureParameter sp = (StructureParameter)itr.next();
                String pName = sp.getName();
                if (pName.startsWith("cp:")) {
                    pName = "dlm:" + sp.getName().substring("cp:".length());
                }
                if (!ls.isChannel()) {
                    if (pName.startsWith("dlm:")) {
                        structure.setAttributeNS("http://www.uportal.org/layout/dlm", pName, sp.getValue());
                        continue;
                    }
                    structure.setAttribute(pName, sp.getValue());
                    continue;
                }
                if (pName.startsWith("dlm:")) {
                    structure.setAttributeNS("http://www.uportal.org/layout/dlm", pName, sp.getValue());
                    itr.remove();
                    continue;
                }
                NodeList nodeListParameters = structure.getElementsByTagName("parameter");
                for (int j = 0; j < nodeListParameters.getLength(); ++j) {
                    Element parmElement = (Element)nodeListParameters.item(j);
                    NamedNodeMap nm = parmElement.getAttributes();
                    String nodeName = nm.getNamedItem("name").getNodeValue();
                    if (!nodeName.equals(pName)) continue;
                    org.w3c.dom.Node override = nm.getNamedItem("override");
                    if (override != null && override.getNodeValue().equals("yes")) {
                        org.w3c.dom.Node valueNode = nm.getNamedItem("value");
                        valueNode.setNodeValue(sp.getValue());
                    }
                    itr.remove();
                    continue block0;
                }
            }
            if (ls.isChannel()) {
                for (StructureParameter sp : ls.getParameters()) {
                    Element parameter = doc.createElement("parameter");
                    parameter.setAttribute("name", sp.getName());
                    parameter.setAttribute("value", sp.getValue());
                    parameter.setAttribute("override", "yes");
                    structure.appendChild(parameter);
                }
            }
        }
        String origin = structure.getAttribute("dlm:origin");
        String string = prefix = ls.isChannel() ? "n" : "s";
        if (!origin.equals("")) {
            structure.setAttributeNS("http://www.uportal.org/layout/dlm", "dlm:plfID", prefix + ls.getStructId());
            structure.setAttribute("ID", origin);
        } else if (!ls.isChannel()) {
            if (type != null && type.startsWith("dlm:")) {
                structure.setAttribute("ID", "d" + ls.getStructId());
            } else {
                structure.setAttribute("ID", "s" + ls.getStructId());
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding identifier s" + ls.getStructId()));
            }
            structure.setAttribute("ID", "n" + ls.getStructId());
        }
        structure.setIdAttribute("ID", true);
        return structure;
    }

    protected int saveStructure(org.w3c.dom.Node node, PreparedStatement structStmt, PreparedStatement parmStmt) throws SQLException {
        if (node == null) {
            return 0;
        }
        if (node.getNodeName().equals("parameter")) {
            return this.saveStructure(node.getNextSibling(), structStmt, parmStmt);
        }
        if (!(node instanceof Element)) {
            return 0;
        }
        Element structure = (Element)node;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveStructure XML content: " + XmlUtilitiesImpl.toString((org.w3c.dom.Node)node)));
        }
        int saveStructId = -1;
        String plfID = structure.getAttribute("dlm:plfID");
        if (!plfID.equals("")) {
            saveStructId = Integer.parseInt(plfID.substring(1));
        } else {
            String id = structure.getAttribute("ID");
            saveStructId = Integer.parseInt(id.substring(1));
        }
        int nextStructId = 0;
        int childStructId = 0;
        int chanId = -1;
        IPortletDefinition portletDef = null;
        boolean isChannel = node.getNodeName().equals("channel");
        if (isChannel && (portletDef = this.portletDefinitionRegistry.getPortletDefinition(String.valueOf(chanId = Integer.parseInt(node.getAttributes().getNamedItem("chanID").getNodeValue())))) == null) {
            return 0;
        }
        if (node.hasChildNodes()) {
            childStructId = this.saveStructure(node.getFirstChild(), structStmt, parmStmt);
        }
        nextStructId = this.saveStructure(node.getNextSibling(), structStmt, parmStmt);
        structStmt.clearParameters();
        structStmt.setInt(1, saveStructId);
        structStmt.setInt(2, nextStructId);
        structStmt.setInt(3, childStructId);
        String externalId = structure.getAttribute("external_id");
        if (externalId != null && externalId.trim().length() > 0) {
            Integer eID = new Integer(externalId);
            structStmt.setInt(4, eID);
        } else {
            structStmt.setNull(4, 2);
        }
        if (isChannel) {
            structStmt.setInt(5, chanId);
            structStmt.setNull(6, 12);
        } else {
            structStmt.setNull(5, 2);
            structStmt.setString(6, structure.getAttribute("name"));
        }
        String structType = structure.getAttribute("type");
        structStmt.setString(7, structType);
        structStmt.setString(8, RDBMServices.dbFlag((boolean)RDBMDistributedLayoutStore.xmlBool((String)structure.getAttribute("hidden"))));
        structStmt.setString(9, RDBMServices.dbFlag((boolean)RDBMDistributedLayoutStore.xmlBool((String)structure.getAttribute("immutable"))));
        structStmt.setString(10, RDBMServices.dbFlag((boolean)RDBMDistributedLayoutStore.xmlBool((String)structure.getAttribute("unremovable"))));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)structStmt.toString());
        }
        structStmt.executeUpdate();
        NamedNodeMap attribs = node.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            org.w3c.dom.Node attrib = attribs.item(i);
            String name = attrib.getNodeName();
            if (!name.startsWith("dlm:") || name.equals("dlm:plfID") || name.equals("dlm:fragment") || name.equals("dlm:precedence")) continue;
            parmStmt.clearParameters();
            parmStmt.setInt(1, saveStructId);
            parmStmt.setString(2, name);
            parmStmt.setString(3, attrib.getNodeValue());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)parmStmt.toString());
            }
            parmStmt.executeUpdate();
        }
        NodeList parameters = node.getChildNodes();
        if (parameters != null && isChannel) {
            for (int i = 0; i < parameters.getLength(); ++i) {
                IPortletDefinitionParameter cp;
                if (!parameters.item(i).getNodeName().equals("parameter")) continue;
                Element parmElement = (Element)parameters.item(i);
                NamedNodeMap nm = parmElement.getAttributes();
                String parmName = nm.getNamedItem("name").getNodeValue();
                String parmValue = nm.getNamedItem("value").getNodeValue();
                org.w3c.dom.Node override = nm.getNamedItem("override");
                if (override != null && !override.getNodeValue().equals("yes") || (cp = portletDef.getParameter(parmName)) != null && cp.getValue().equals(parmValue)) continue;
                parmStmt.clearParameters();
                parmStmt.setInt(1, saveStructId);
                parmStmt.setString(2, parmName);
                parmStmt.setString(3, parmValue);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)parmStmt);
                }
                parmStmt.executeUpdate();
            }
        }
        return saveStructId;
    }

    public static org.w3c.dom.Document getPLF(IPerson person) throws PortalException {
        try {
            return (org.w3c.dom.Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        }
        catch (Exception ex) {
            throw new PortalException((Throwable)ex);
        }
    }

    private Element getElementForChannel(org.w3c.dom.Document doc, String chanId, IPortletDefinition def, String locale) {
        Element channel = doc.createElement("channel");
        channel.setAttribute("ID", chanId);
        channel.setIdAttribute("ID", true);
        channel.setAttribute("chanID", def.getPortletDefinitionId().getStringId());
        channel.setAttribute("timeout", String.valueOf(def.getTimeout()));
        if (locale != null) {
            channel.setAttribute("name", def.getName(locale));
            channel.setAttribute("title", def.getTitle(locale));
            channel.setAttribute("description", def.getDescription(locale));
            channel.setAttribute("locale", locale);
        } else {
            channel.setAttribute("name", def.getName());
            channel.setAttribute("title", def.getTitle());
            channel.setAttribute("description", def.getDescription());
        }
        channel.setAttribute("fname", def.getFName());
        channel.setAttribute("typeID", String.valueOf(def.getType().getId()));
        for (IPortletDefinitionParameter param : def.getParameters()) {
            Element parameter = doc.createElement("parameter");
            parameter.setAttribute("name", param.getName());
            parameter.setAttribute("value", param.getValue());
            channel.appendChild(parameter);
        }
        return channel;
    }
}

