/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.providers;

import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.providers.AttributeEvaluator;
import org.jasig.portal.layout.dlm.providers.Paren;
import org.jasig.portal.xml.XmlUtilitiesImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersonEvaluatorFactory
implements EvaluatorFactory {
    public static final String RCS_ID = "@(#) $Header$";
    private static final int OR = 0;
    private static final int AND = 1;
    private static final int NOT = 2;

    public Evaluator getEvaluator(Node audience) {
        return this.getGroupEvaluator(0, audience);
    }

    private Evaluator getGroupEvaluator(int type, Node node) {
        NodeList nodes = node.getChildNodes();
        Evaluator container = null;
        if (nodes == null || nodes.getLength() == 0 || (container = this.createGroupEvaluator(type, nodes)) == null) {
            throw new RuntimeException("Invalid content. Expected one to many <paren>, <NOT>, or <attribute> in '" + XmlUtilitiesImpl.toString((Node)node) + "'");
        }
        return container;
    }

    private Evaluator createGroupEvaluator(int type, NodeList nodes) {
        if (nodes.getLength() == 1 && (type == 0 || type == 1)) {
            return this.createEvaluator(nodes.item(0));
        }
        Paren container = null;
        if (type == 2) {
            container = new Paren(Paren.Type.NOT);
        } else if (type == 0) {
            container = new Paren(Paren.Type.OR);
        } else if (type == 1) {
            container = new Paren(Paren.Type.AND);
        }
        boolean validContentAdded = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Evaluator e;
            if (nodes.item(i).getNodeType() != 1 || (e = this.createEvaluator(nodes.item(i))) == null) continue;
            validContentAdded = true;
            container.addEvaluator(e);
        }
        if (validContentAdded) {
            return container;
        }
        return null;
    }

    private Evaluator createEvaluator(Node node) {
        String nodeName = node.getNodeName();
        if (nodeName.equals("paren")) {
            return this.createParen(node);
        }
        if (nodeName.equals("attribute")) {
            return this.createAttributeEvaluator(node);
        }
        throw new RuntimeException("Unrecognized element '" + nodeName + "' in '" + XmlUtilitiesImpl.toString((Node)node) + "'");
    }

    private Evaluator createParen(Node n) {
        NamedNodeMap attribs = n.getAttributes();
        Node opNode = attribs.getNamedItem("mode");
        if (opNode == null) {
            throw new RuntimeException("Invalid mode. Expected 'AND','OR', or 'NOT' in '" + XmlUtilitiesImpl.toString((Node)n) + "'");
        }
        if (opNode.getNodeValue().equals("OR")) {
            return this.getGroupEvaluator(0, n);
        }
        if (opNode.getNodeValue().equals("NOT")) {
            return this.getGroupEvaluator(2, n);
        }
        if (opNode.getNodeValue().equals("AND")) {
            return this.getGroupEvaluator(1, n);
        }
        throw new RuntimeException("Invalid mode. Expected 'AND','OR', or 'NOT' in '" + XmlUtilitiesImpl.toString((Node)n) + "'");
    }

    private Evaluator createAttributeEvaluator(Node n) {
        NamedNodeMap attribs = n.getAttributes();
        Node attribNode = attribs.getNamedItem("name");
        if (attribNode == null || attribNode.getNodeValue().equals("")) {
            throw new RuntimeException("Missing or empty name attribute in '" + XmlUtilitiesImpl.toString((Node)n) + "'");
        }
        String name = attribNode.getNodeValue();
        String value = null;
        attribNode = attribs.getNamedItem("value");
        if (attribNode != null) {
            value = attribNode.getNodeValue();
        }
        if ((attribNode = attribs.getNamedItem("mode")) == null || attribNode.getNodeValue().equals("")) {
            throw new RuntimeException("Missing or empty mode attribute in '" + XmlUtilitiesImpl.toString((Node)n) + "'");
        }
        String mode = attribNode.getNodeValue();
        Evaluator eval = null;
        try {
            eval = this.getAttributeEvaluator(name, mode, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage() + " in '" + XmlUtilitiesImpl.toString((Node)n), e);
        }
        return eval;
    }

    public Evaluator getAttributeEvaluator(String name, String mode, String value) throws Exception {
        return new AttributeEvaluator(name, mode, value);
    }
}

