/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityNameFinder;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.jasig.portal.security.AuthorizationPrincipalHelper;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.EntityNameFinderService;
import org.jasig.portal.services.GroupService;

public class GroupListHelperImpl
implements IGroupListHelper {
    private static final String PRINCIPAL_SEPARATOR = "\\.";
    private static final Log log = LogFactory.getLog(GroupListHelperImpl.class);

    public Set<JsonEntityBean> search(String entityType, String searchTerm) {
        Class identifierType;
        EntityIdentifier[] identifiers;
        HashSet<JsonEntityBean> results = new HashSet<JsonEntityBean>();
        EntityEnum entityEnum = EntityEnum.getEntityEnum((String)entityType);
        if (entityEnum.isGroup()) {
            identifiers = GroupService.searchForGroups((String)searchTerm, (int)4, (Class)entityEnum.getClazz());
            identifierType = IEntityGroup.class;
        } else {
            identifiers = GroupService.searchForEntities((String)searchTerm, (int)4, (Class)entityEnum.getClazz());
            identifierType = entityEnum.getClazz();
        }
        for (int i = 0; i < identifiers.length; ++i) {
            if (!identifiers[i].getType().equals(identifierType)) continue;
            IGroupMember entity = GroupService.getGroupMember((EntityIdentifier)identifiers[i]);
            if (entity != null) {
                JsonEntityBean jsonBean = this.getEntity(entity);
                results.add(jsonBean);
                continue;
            }
            log.warn((Object)("Grouper member entity of " + identifiers[i].getKey() + " is null."));
        }
        return results;
    }

    public JsonEntityBean getRootEntity(String groupType) {
        EntityEnum type = EntityEnum.getEntityEnum((String)groupType);
        if (!EntityEnum.GROUP.equals((Object)type)) {
            if (EntityEnum.CATEGORY.equals((Object)type)) {
                IEntityGroup categoryGroup = GroupService.getDistinguishedGroup((String)IGroupConstants.PORTLET_CATEGORIES);
                return new JsonEntityBean(categoryGroup, EntityEnum.CATEGORY);
            }
            throw new IllegalArgumentException("Unable to determine a root entity for group type '" + groupType + "'");
        }
        String rootKey = "local.0";
        JsonEntityBean bean = this.getEntity(groupType, rootKey, false);
        return bean;
    }

    public JsonEntityBean getIndividualBestRootEntity(IPerson person, String groupType, String permissionOwner, String permissionActivity) {
        return this.getIndividualBestRootEntity(person, groupType, permissionOwner, new String[]{permissionActivity});
    }

    public JsonEntityBean getIndividualBestRootEntity(IPerson person, String groupType, String permissionOwner, String[] permissionActivities) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Choosing best root group for user='" + person.getUserName() + "', groupType='" + groupType + "', permissionOwner='" + permissionOwner + "', permissionActivities='" + Arrays.toString(permissionActivities) + "'"));
        }
        IAuthorizationPrincipal principal = AuthorizationPrincipalHelper.principalFromUser((IPerson)person);
        JsonEntityBean canonicalRootGroup = this.getRootEntity(groupType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found for groupType='" + groupType + "' the following canonicalRootGroup:  " + canonicalRootGroup));
        }
        String canonicalSuperTarget = null;
        if ("group".equals(groupType)) {
            canonicalSuperTarget = "ALL_GROUPS";
        } else if ("category".equals(groupType)) {
            canonicalSuperTarget = "ALL_CATEGORIES";
        } else {
            throw new RuntimeException("Unrecognized groupType:  " + groupType);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Identified for groupType='" + groupType + "' the following canonicalSuperTarget:  " + canonicalSuperTarget));
        }
        for (String activity : permissionActivities) {
            if (!principal.hasPermission(permissionOwner, activity, canonicalSuperTarget)) continue;
            return canonicalRootGroup;
        }
        for (String activity : permissionActivities) {
            if (!principal.hasPermission(permissionOwner, activity, canonicalRootGroup.getId())) continue;
            return canonicalRootGroup;
        }
        JsonEntityBean rslt = null;
        ArrayList<IPermission> permissionsOfRelevantActivity = new ArrayList<IPermission>();
        for (String activity : permissionActivities) {
            permissionsOfRelevantActivity.addAll(Arrays.asList(principal.getAllPermissions(permissionOwner, activity, null)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("For user='" + person.getUserName() + "', groupType='" + groupType + "', permissionOwner='" + permissionOwner + "', permissionActivities='" + Arrays.toString(permissionActivities) + "' permissionsOfRelevantTypes.size()=" + permissionsOfRelevantActivity.size()));
        }
        switch (permissionsOfRelevantActivity.size()) {
            case 0: {
                break;
            }
            default: {
                for (IPermission p : permissionsOfRelevantActivity) {
                    JsonEntityBean candidate = this.getEntity(groupType, p.getTarget(), true);
                    if (!candidate.getEntityTypeAsString().equalsIgnoreCase(groupType)) continue;
                    if (rslt == null) {
                        rslt = candidate;
                        continue;
                    }
                    if (candidate.getChildren().size() <= rslt.getChildren().size()) continue;
                    rslt = candidate;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected for user='" + person.getUserName() + "', groupType='" + groupType + "', permissionOwner='" + permissionOwner + "', permissionActivities='" + Arrays.toString(permissionActivities) + "' the following best root group:  " + rslt));
        }
        return rslt;
    }

    public Set<String> getEntityTypesForGroupType(String groupType) {
        HashSet<String> set = new HashSet<String>();
        set.add(groupType);
        EntityEnum type = EntityEnum.getEntityEnum((String)groupType);
        if (EntityEnum.GROUP.equals((Object)type)) {
            set.add(EntityEnum.PERSON.toString());
        } else if (EntityEnum.CATEGORY.equals((Object)type)) {
            set.add(EntityEnum.PORTLET.toString());
        } else {
            throw new IllegalArgumentException("Unable to determine a root entity for group type '" + groupType + "'");
        }
        return set;
    }

    public JsonEntityBean getEntity(String entityType, String entityId, boolean populateChildren) {
        EntityEnum entityEnum = EntityEnum.getEntityEnum((String)entityType);
        if (entityEnum.isGroup()) {
            IEntityGroup entity = GroupService.findGroup((String)entityId);
            if (entity == null) {
                return null;
            }
            JsonEntityBean jsonBean = new JsonEntityBean(entity, entityEnum);
            if (populateChildren) {
                Iterator members = entity.getMembers();
                jsonBean = this.populateChildren(jsonBean, members);
            }
            if (jsonBean.getEntityType().isGroup() || EntityEnum.PERSON.equals((Object)jsonBean.getEntityType())) {
                IAuthorizationPrincipal principal = this.getPrincipalForEntity(jsonBean);
                jsonBean.setPrincipalString(principal.getPrincipalString());
            }
            return jsonBean;
        }
        IGroupMember entity = GroupService.getGroupMember((String)entityId, (Class)entityEnum.getClazz());
        if (entity == null || entity instanceof IEntityGroup) {
            return null;
        }
        JsonEntityBean jsonBean = new JsonEntityBean(entity, entityEnum);
        jsonBean.setName(this.lookupEntityName(jsonBean));
        if (EntityEnum.GROUP.equals((Object)jsonBean.getEntityType()) || EntityEnum.PERSON.equals((Object)jsonBean.getEntityType())) {
            IAuthorizationPrincipal principal = this.getPrincipalForEntity(jsonBean);
            jsonBean.setPrincipalString(principal.getPrincipalString());
        }
        return jsonBean;
    }

    public JsonEntityBean getEntity(IGroupMember member) {
        EntityEnum entityEnum = this.getEntityType(member);
        JsonEntityBean entity = entityEnum.isGroup() ? new JsonEntityBean((IEntityGroup)member, entityEnum) : new JsonEntityBean(member, entityEnum);
        if (entity.getName() == null) {
            entity.setName(this.lookupEntityName(entity));
        }
        if (EntityEnum.GROUP.equals((Object)entity.getEntityType()) || EntityEnum.PERSON.equals((Object)entity.getEntityType())) {
            IAuthorizationPrincipal principal = this.getPrincipalForEntity(entity);
            entity.setPrincipalString(principal.getPrincipalString());
        }
        return entity;
    }

    public JsonEntityBean getEntityForPrincipal(String principalString) {
        String[] parts = principalString.split(PRINCIPAL_SEPARATOR, 2);
        String key = parts[1];
        int typeId = Integer.parseInt(parts[0]);
        Class type = EntityTypes.getEntityType((Integer)typeId);
        String entityType = "person";
        if (IEntityGroup.class.isAssignableFrom(type)) {
            entityType = "group";
        }
        JsonEntityBean bean = this.getEntity(entityType, key, false);
        return bean;
    }

    public IAuthorizationPrincipal getPrincipalForEntity(JsonEntityBean entity) {
        EntityEnum jsonType = entity.getEntityType();
        Class entityType = jsonType.isGroup() ? IEntityGroup.class : jsonType.getClazz();
        AuthorizationService authService = AuthorizationService.instance();
        IAuthorizationPrincipal p = authService.newPrincipal(entity.getId(), entityType);
        return p;
    }

    private JsonEntityBean populateChildren(JsonEntityBean jsonBean, Iterator<IGroupMember> children) {
        while (children.hasNext()) {
            IGroupMember member = children.next();
            JsonEntityBean jsonChild = this.getEntity(member);
            jsonBean.addChild(jsonChild);
        }
        jsonBean.setChildrenInitialized(true);
        return jsonBean;
    }

    public EntityEnum getEntityType(IGroupMember entity) {
        if (IEntityGroup.class.isAssignableFrom(entity.getClass())) {
            return EntityEnum.getEntityEnum((Class)entity.getEntityType(), (boolean)true);
        }
        return EntityEnum.getEntityEnum((Class)entity.getEntityType(), (boolean)false);
    }

    public List<JsonEntityBean> getEntityBeans(List<String> params) {
        if (params == null || params.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JsonEntityBean> beans = new ArrayList<JsonEntityBean>();
        for (String param : params) {
            String[] parts = param.split(":", 2);
            JsonEntityBean member = this.getEntity(parts[0], parts[1], false);
            beans.add(member);
        }
        return beans;
    }

    public String lookupEntityName(JsonEntityBean entity) {
        EntityEnum entityEnum = entity.getEntityType();
        IEntityNameFinder finder = entityEnum.isGroup() ? EntityNameFinderService.instance().getNameFinder(IEntityGroup.class) : EntityNameFinderService.instance().getNameFinder(entityEnum.getClazz());
        try {
            return finder.getName(entity.getId());
        }
        catch (Exception e) {
            log.warn((Object)("Couldn't find name for entity " + entity.getId()), (Throwable)e);
            return null;
        }
    }
}

