/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.persondir.dao.jpa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.NaturalId;
import org.jasig.portal.persondir.ILocalAccountPerson;
import org.jasig.portal.persondir.dao.jpa.LocalAccountPersonAttributeImpl;
import org.springframework.util.Assert;

@Entity
@Table(name="UP_PERSON_DIR")
@SequenceGenerator(name="UP_PERSON_DIR_GEN", sequenceName="UP_PERSON_DIR_SEQ", allocationSize=5)
@TableGenerator(name="UP_PERSON_DIR_GEN", pkColumnValue="UP_PERSON_DIR", allocationSize=5)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class LocalAccountPersonImpl
implements Serializable,
ILocalAccountPerson {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_PERSON_DIR_GEN")
    @Column(name="USER_DIR_ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="USER_NAME", length=35, nullable=false)
    private final String name;
    @Column(name="ENCRPTD_PSWD", length=256)
    private String password;
    @Column(name="LST_PSWD_CGH_DT")
    private Date lastPasswordChange;
    @OneToMany(targetEntity=LocalAccountPersonAttributeImpl.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="USER_DIR_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Collection<LocalAccountPersonAttributeImpl> attributes = new ArrayList(0);

    private LocalAccountPersonImpl() {
        this.id = -1L;
        this.entityVersion = -1L;
        this.name = null;
    }

    public LocalAccountPersonImpl(String name) {
        Assert.notNull((Object)name);
        this.id = -1L;
        this.entityVersion = -1L;
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Date getLastPasswordChange() {
        return this.lastPasswordChange;
    }

    public void setLastPasswordChange(Date lastPasswordChange) {
        this.lastPasswordChange = lastPasswordChange;
    }

    public Object getAttributeValue(String name) {
        List values = this.getAttributeValues(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public List<Object> getAttributeValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        for (LocalAccountPersonAttributeImpl attribute : this.attributes) {
            if (!name.equals(attribute.getName())) continue;
            return this.getObjectValues(attribute);
        }
        return null;
    }

    public Map<String, List<Object>> getAttributes() {
        LinkedHashMap<String, List> attributeMap = new LinkedHashMap<String, List>();
        for (LocalAccountPersonAttributeImpl attribute : this.attributes) {
            List objValues = this.getObjectValues(attribute);
            attributeMap.put(attribute.getName(), objValues);
        }
        return Collections.unmodifiableMap(attributeMap);
    }

    public void setAttribute(String name, String ... values) {
        this.setAttribute(name, Arrays.asList(values));
    }

    public void setAttribute(String name, List<String> values) {
        for (LocalAccountPersonAttributeImpl attribute : this.attributes) {
            if (!name.equals(attribute.getName())) continue;
            attribute.setValues(values);
            return;
        }
        this.attributes.add(new LocalAccountPersonAttributeImpl(name, values));
    }

    public void setAttribute(String name, String value) {
        for (LocalAccountPersonAttributeImpl attribute : this.attributes) {
            if (!name.equals(attribute.getName())) continue;
            attribute.setValues(Collections.singletonList(value));
            return;
        }
        this.attributes.add(new LocalAccountPersonAttributeImpl(name, Collections.singletonList(value)));
    }

    public boolean removeAttribute(String name) {
        Iterator itr = this.attributes.iterator();
        while (itr.hasNext()) {
            if (!((LocalAccountPersonAttributeImpl)itr.next()).getName().equals(name)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        String name;
        attributes = new LinkedHashMap<String, List<String>>(attributes);
        Iterator attributesItr = this.attributes.iterator();
        while (attributesItr.hasNext()) {
            LocalAccountPersonAttributeImpl localAccountPersonAttributeImpl = (LocalAccountPersonAttributeImpl)attributesItr.next();
            name = localAccountPersonAttributeImpl.getName();
            List<String> newValues = attributes.remove(name);
            if (newValues == null) {
                attributesItr.remove();
                continue;
            }
            localAccountPersonAttributeImpl.setValues(new ArrayList<String>(newValues));
        }
        for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
            name = entry.getKey();
            List<String> values = entry.getValue();
            this.attributes.add(new LocalAccountPersonAttributeImpl(name, values));
        }
    }

    protected List<Object> getObjectValues(LocalAccountPersonAttributeImpl attribute) {
        List values = attribute.getValues();
        ArrayList objValues = new ArrayList(values.size());
        objValues.addAll(values);
        return Collections.unmodifiableList(objValues);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.lastPasswordChange == null ? 0 : this.lastPasswordChange.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalAccountPersonImpl)) {
            return false;
        }
        LocalAccountPersonImpl other = (LocalAccountPersonImpl)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.lastPasswordChange == null ? other.lastPasswordChange != null : !this.lastPasswordChange.equals(other.lastPasswordChange)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.password == null ? other.password != null : !this.password.equals(other.password));
    }

    public String toString() {
        return "LocalAccountPersonImpl [id=" + this.id + ", entityVersion=" + this.entityVersion + ", name=" + this.name + ", lastPasswordChange=" + this.lastPasswordChange + "]";
    }
}

